/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.uiDesigner.LoaderFactory;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.LwIntroComponentProperty;
import com.intellij.uiDesigner.lw.LwIntroEnumProperty;
import com.intellij.uiDesigner.lw.LwIntroListModelProperty;
import com.intellij.uiDesigner.lw.LwIntrospectedProperty;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiPropertiesProvider
implements PropertiesProvider {
    private final Module myModule;
    private final HashMap<String, HashMap> myCache;

    public PsiPropertiesProvider(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/uiDesigner/PsiPropertiesProvider", "<init>"));
        }
        this.myModule = module;
        this.myCache = new HashMap();
    }

    @Nullable
    public HashMap getLwProperties(String className) {
        PsiMethod[] methods;
        if (this.myCache.containsKey(className)) {
            return this.myCache.get(className);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
        PsiClass aClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(className, scope);
        if (aClass == null) {
            return null;
        }
        HashMap<String, LwIntrospectedProperty> result = new HashMap<String, LwIntrospectedProperty>();
        for (PsiMethod method : methods = aClass.getAllMethods()) {
            LwIntrospectedProperty property;
            String name;
            block10: {
                if (!PropertyUtil.isSimplePropertySetter((PsiMethod)method)) continue;
                name = PropertyUtil.getPropertyName((PsiMethod)method);
                if (name == null) {
                    throw new IllegalStateException();
                }
                PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)aClass, (String)name, (boolean)false, (boolean)true);
                if (getter == null) continue;
                PsiType type = getter.getReturnType();
                String propertyClassName = StringUtil.defaultIfEmpty((String)StringUtil.substringBefore((String)type.getCanonicalText(), (String)"<"), (String)type.getCanonicalText());
                property = CompiledClassPropertiesProvider.propertyFromClassName((String)propertyClassName, (String)name);
                if (property == null) {
                    PsiClass propClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(propertyClassName, scope);
                    if (propClass == null) continue;
                    if (propClass.isEnum()) {
                        String enumClassName = ClassUtil.getJVMClassName((PsiClass)propClass);
                        ClassLoader loader = LoaderFactory.getInstance(this.myModule.getProject()).getLoader(this.myModule);
                        try {
                            property = new LwIntroEnumProperty(name, loader.loadClass(enumClassName));
                            break block10;
                        }
                        catch (ClassNotFoundException e) {
                            continue;
                        }
                    }
                    PsiClass componentClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(Component.class.getName(), scope);
                    PsiClass listModelClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(ListModel.class.getName(), scope);
                    if (componentClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)propClass, (PsiClass)componentClass, (boolean)true)) {
                        property = new LwIntroComponentProperty(name, propertyClassName);
                    } else {
                        if (componentClass == null || listModelClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)propClass, (PsiClass)listModelClass, (boolean)true)) continue;
                        property = new LwIntroListModelProperty(name, propertyClassName);
                    }
                }
            }
            result.put(name, property);
        }
        this.myCache.put(className, result);
        return result;
    }
}

