/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0014J\"\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J7\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000fH\u0014J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0014J2\u0010'\u001a\u00020\u00052\b\u0010(\u001a\u0004\u0018\u00010\r2\b\u0010!\u001a\u0004\u0018\u00010\u000f2\u0014\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010*H\u0014\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/actions/NewKotlinFileAction;", "Lcom/intellij/ide/actions/CreateFileFromTemplateAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "buildDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/psi/PsiDirectory;", "builder", "Lcom/intellij/ide/actions/CreateFileFromTemplateDialog$Builder;", "createFileFromTemplate", "Lcom/intellij/psi/PsiFile;", "name", "", "template", "Lcom/intellij/ide/fileTemplates/FileTemplate;", "dir", "createFromTemplate", "className", "equals", "", "obj", "", "findOrCreateTarget", "Lkotlin/Pair;", "directorySeparators", "", "", "(Lcom/intellij/psi/PsiDirectory;Ljava/lang/String;[Ljava/lang/Character;)Lkotlin/Pair;", "getActionName", "newName", "templateName", "hashCode", "", "isAvailable", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "postProcess", "createdElement", "customProperties", "", "idea"})
public final class NewKotlinFileAction
extends CreateFileFromTemplateAction
implements DumbAware {
    protected void postProcess(@Nullable PsiFile createdElement, @Nullable String templateName, @Nullable Map<String, String> customProperties) {
        Module module;
        super.postProcess((PsiElement)createdElement, templateName, customProperties);
        PsiFile psiFile = createdElement;
        if (psiFile == null) {
            Intrinsics.throwNpe();
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile))) != null) {
            ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(module);
        }
    }

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        builder.setTitle("New Kotlin File/Class").addKind("File", KotlinFileType.INSTANCE.getIcon(), "Kotlin File").addKind("Class", KotlinIcons.CLASS, "Kotlin Class").addKind("Interface", KotlinIcons.INTERFACE, "Kotlin Interface").addKind("Enum class", KotlinIcons.ENUM, "Kotlin Enum").addKind("Object", KotlinIcons.OBJECT, "Kotlin Object");
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName2, @NotNull String templateName) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)newName2, (String)"newName");
        Intrinsics.checkParameterIsNotNull((Object)templateName, (String)"templateName");
        return "Kotlin File/Class";
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isAvailable(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        if (super.isAvailable(dataContext)) {
            boolean bl;
            block4: {
                void $receiver$iv;
                Object object = LangDataKeys.IDE_VIEW.getData(dataContext);
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                IdeView ideView = (IdeView)object;
                Object object2 = PlatformDataKeys.PROJECT.getData(dataContext);
                if (object2 == null) {
                    Intrinsics.throwNpe();
                }
                Project project = (Project)object2;
                ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                Object[] objectArray = ideView.getDirectories();
                for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
                    void element$iv = $receiver$iv[i];
                    PsiDirectory it = (PsiDirectory)element$iv;
                    if (!projectFileIndex.isInSourceContent(it.getVirtualFile())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof NewKotlinFileAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    protected PsiFile createFileFromTemplate(@NotNull String name2, @NotNull FileTemplate template2, @NotNull PsiDirectory dir) {
        Character[] characterArray;
        Object elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)template2, (String)"template");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        if (Intrinsics.areEqual((Object)template2.getName(), (Object)"Kotlin File")) {
            Character[] characterArray2 = new Character[]{Character.valueOf('/'), Character.valueOf('\\')};
            characterArray = (Character[])((Object[])elements$iv);
        } else {
            elements$iv = new Character[]{Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('.')};
            characterArray = (Character[])((Object[])elements$iv);
        }
        Character[] directorySeparators = characterArray;
        Pair<String, PsiDirectory> pair2 = this.findOrCreateTarget(dir, name2, directorySeparators);
        elements$iv = (String)pair2.component1();
        PsiDirectory psiDirectory = (PsiDirectory)pair2.component2();
        pair2 = null;
        DumbService service = DumbService.getInstance((Project)dir.getProject());
        service.setAlternativeResolveEnabled(true);
        try {
            void className2;
            void targetDir;
            PsiFile psiFile = this.createFromTemplate((PsiDirectory)targetDir, (String)className2, template2);
            return psiFile;
        }
        finally {
            service.setAlternativeResolveEnabled(false);
        }
    }

    private final Pair<String, PsiDirectory> findOrCreateTarget(PsiDirectory dir, String name2, Character[] directorySeparators) {
        String className2 = StringsKt.removeSuffix((String)name2, (CharSequence)".kt");
        PsiDirectory targetDir = dir;
        for (int i = 0; i < directorySeparators.length; ++i) {
            char splitChar = directorySeparators[i].charValue();
            if (!StringsKt.contains$default((CharSequence)className2, (char)splitChar, (boolean)false, (int)2, null)) continue;
            String string = className2;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            List names = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), (char[])new char[]{splitChar}, (boolean)false, (int)0, (int)6, null);
            for (String dirName : CollectionsKt.dropLast((List)names, (int)1)) {
                PsiDirectory psiDirectory = targetDir.findSubdirectory(dirName);
                if (psiDirectory == null) {
                    PsiDirectory psiDirectory2 = targetDir.createSubdirectory(dirName);
                    psiDirectory = psiDirectory2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory2, (String)"targetDir.createSubdirectory(dirName)");
                }
                targetDir = psiDirectory;
            }
            className2 = (String)CollectionsKt.last((List)names);
            break;
        }
        return new Pair((Object)className2, (Object)targetDir);
    }

    private final PsiFile createFromTemplate(PsiDirectory dir, String className2, FileTemplate template2) {
        PsiElement element2;
        PsiElement psiElement;
        Project project = dir.getProject();
        Properties defaultProperties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
        Properties properties2 = new Properties(defaultProperties);
        try {
            psiElement = new CreateFromTemplateDialog(project, dir, template2, new AttributesDefaults(className2).withFixedName(true), properties2).create();
        }
        catch (IncorrectOperationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            NewKotlinFileAction.access$getLOG$p$s-1549423502().error((Throwable)e);
            return null;
        }
        PsiElement psiElement2 = element2 = psiElement;
        return psiElement2 != null ? psiElement2.getContainingFile() : null;
    }

    public NewKotlinFileAction() {
        super("Kotlin File/Class", "Creates new Kotlin file or class", KotlinFileType.INSTANCE.getIcon());
    }

    public static final /* synthetic */ Logger access$getLOG$p$s-1549423502() {
        return CreateFileFromTemplateAction.LOG;
    }
}

