/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.util.List;
import javax.swing.Icon;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtFunction;

public class KotlinLineBreakpointType
extends JavaLineBreakpointType {
    public KotlinLineBreakpointType() {
        super("kotlin-line", "Kotlin Line Breakpoints");
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint, @NotNull SourcePosition position2) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "matchesPosition"));
        }
        if (position2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "matchesPosition"));
        }
        JavaBreakpointProperties properties2 = KotlinLineBreakpointType.getProperties(breakpoint);
        if (properties2 == null || properties2 instanceof JavaLineBreakpointProperties) {
            if (properties2 != null && ((JavaLineBreakpointProperties)properties2).getLambdaOrdinal() == null) {
                return true;
            }
            PsiElement containingMethod = this.getContainingMethod(breakpoint);
            if (containingMethod == null) {
                return false;
            }
            return KotlinLineBreakpointType.inTheMethod(position2, containingMethod);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint) {
        Integer ordinal;
        KtFunction lambda2;
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "getContainingMethod"));
        }
        SourcePosition position2 = breakpoint.getSourcePosition();
        if (position2 == null) {
            return null;
        }
        JavaBreakpointProperties properties2 = KotlinLineBreakpointType.getProperties(breakpoint);
        if (properties2 instanceof JavaLineBreakpointProperties && (lambda2 = KotlinLineBreakpointType.getLambdaByOrdinal(position2, ordinal = ((JavaLineBreakpointProperties)properties2).getLambdaOrdinal())) != null) {
            return lambda2;
        }
        return KotlinLineBreakpointType.getContainingMethod(position2.getElementAt());
    }

    @Nullable
    private static JavaBreakpointProperties getProperties(@NotNull LineBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "getProperties"));
        }
        XBreakpoint xBreakpoint = breakpoint.getXBreakpoint();
        return xBreakpoint != null ? (JavaBreakpointProperties)xBreakpoint.getProperties() : null;
    }

    @Nullable
    private static KtFunction getLambdaByOrdinal(SourcePosition position2, Integer ordinal) {
        List<KtFunction> lambdas;
        if (ordinal != null && ordinal >= 0 && (lambdas = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(position2)).size() > ordinal) {
            return lambdas.get(ordinal);
        }
        return null;
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable PsiElement elem) {
        return PsiTreeUtil.getParentOfType((PsiElement)elem, (Class[])new Class[]{KtFunction.class, KtClassInitializer.class});
    }

    public static boolean inTheMethod(@NotNull SourcePosition pos, @NotNull PsiElement method) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "inTheMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "inTheMethod"));
        }
        PsiElement elem = pos.getElementAt();
        if (elem == null) {
            return false;
        }
        return Comparing.equal((Object)KotlinLineBreakpointType.getContainingMethod(elem), (Object)method);
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "canPutAt"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "canPutAt"));
        }
        return BreakpointTypeUtilsKt.canPutAt(file2, line, project, ((Object)((Object)this)).getClass());
    }

    @NotNull
    public List<JavaLineBreakpointType.JavaBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "computeVariants"));
        }
        if (position2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "computeVariants"));
        }
        List<JavaLineBreakpointType.JavaBreakpointVariant> list2 = BreakpointTypeUtilsKt.computeVariants(project, position2, this);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "computeVariants"));
        }
        return list2;
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        KtFunction lambda2;
        SourcePosition position2;
        Breakpoint javaBreakpoint;
        Integer ordinal;
        JavaLineBreakpointProperties properties2 = (JavaLineBreakpointProperties)breakpoint.getProperties();
        if (properties2 != null && (ordinal = properties2.getLambdaOrdinal()) != null && (javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint)) instanceof LineBreakpoint && (position2 = ((LineBreakpoint)javaBreakpoint).getSourcePosition()) != null && (lambda2 = KotlinLineBreakpointType.getLambdaByOrdinal(position2, ordinal)) != null) {
            return lambda2.getTextRange();
        }
        return null;
    }

    public class KotlinLineBreakpointVariant
    extends JavaLineBreakpointType.ExactJavaBreakpointVariant {
        public KotlinLineBreakpointVariant(XSourcePosition position2, PsiElement element2) {
            super((JavaLineBreakpointType)KotlinLineBreakpointType.this, position2, element2, Integer.valueOf(-1));
        }

        public String getText() {
            return StringsKt.replace((String)super.getText(), (String)"  ", (String)"", (boolean)true);
        }

        public Icon getIcon() {
            return KotlinIcons.FUNCTION;
        }
    }

    public class KotlinLambdaBreakpointVariant
    extends JavaLineBreakpointType.ExactJavaBreakpointVariant {
        public KotlinLambdaBreakpointVariant(XSourcePosition position2, KtFunction function2, Integer lambdaOrdinal2) {
            super((JavaLineBreakpointType)KotlinLineBreakpointType.this, position2, (PsiElement)function2, lambdaOrdinal2);
        }

        public Icon getIcon() {
            return KotlinIcons.LAMBDA;
        }
    }
}

