/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/fixers/KotlinPropertySetterBodyFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "psiElement", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class KotlinPropertySetterBodyFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement psiElement) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        if (!(psiElement instanceof KtPropertyAccessor)) {
            return;
        }
        if (!((KtPropertyAccessor)psiElement).isSetter()) {
            return;
        }
        if (((KtPropertyAccessor)psiElement).getBodyExpression() != null || ((KtPropertyAccessor)psiElement).getEqualsToken() != null) {
            return;
        }
        PsiElement psiElement2 = psiElement;
        KtDeclaration parentDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDeclaration.class, (boolean)true);
        if (parentDeclaration instanceof KtClassOrObject && (KtPsiUtil.isTrait((KtClassOrObject)parentDeclaration) || ((KtPropertyAccessor)psiElement).hasModifier(KtTokens.ABSTRACT_KEYWORD))) {
            return;
        }
        if (PsiUtilsKt.getEndOffset(((KtPropertyAccessor)psiElement).getNamePlaceholder()) == PsiUtilsKt.getEndOffset(psiElement)) {
            return;
        }
        Document doc = editor.getDocument();
        int endOffset = FixersUtilKt.getEnd(FixersUtilKt.getRange(psiElement));
        String string = ((KtPropertyAccessor)psiElement).getText();
        if (Intrinsics.areEqual((Object)(string != null ? Character.valueOf(StringsKt.last((CharSequence)string)) : null), (Object)Character.valueOf(';'))) {
            doc.deleteString(endOffset - 1, endOffset);
            --endOffset;
        }
        doc.insertString(endOffset, (CharSequence)"{}");
    }
}

