/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertNegatedBooleanSequenceIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "splitBooleanSequence", "", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "expression", "idea"})
public final class ConvertNegatedBooleanSequenceIntention
extends SelfTargetingOffsetIndependentIntention<KtBinaryExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (element2.getParent() instanceof KtBinaryExpression) {
            return false;
        }
        IElementType opToken = element2.getOperationToken();
        if (Intrinsics.areEqual((Object)opToken, (Object)((Object)KtTokens.ANDAND)) ^ true && Intrinsics.areEqual((Object)opToken, (Object)((Object)KtTokens.OROR)) ^ true) {
            return false;
        }
        return this.splitBooleanSequence(element2) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtBinaryExpression element2, @Nullable Editor editor) {
        void $receiver$iv;
        void initial$iv;
        String prefixExpression;
        String destination$iv$iv;
        List $receiver$iv$iv;
        void $receiver$iv2;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        IElementType iElementType = element2.getOperationToken();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ANDAND))) {
            string = KtTokens.OROR.getValue();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.OROR))) {
            string = KtTokens.ANDAND.getValue();
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        String operatorText = string;
        List<KtPrefixExpression> list2 = this.splitBooleanSequence(element2);
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        List<KtPrefixExpression> elements = list2;
        Iterable iterable = elements;
        void var7_6 = $receiver$iv2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            KtPrefixExpression ktPrefixExpression = (KtPrefixExpression)item$iv$iv;
            void var15_11 = destination$iv$iv;
            KtExpression ktExpression = ((KtPrefixExpression)((Object)prefixExpression)).getBaseExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            String string2 = ktExpression.getText();
            var15_11.add(string2);
        }
        List bareExpressions = (List)((Object)destination$iv$iv);
        $receiver$iv$iv = bareExpressions.subList(0, CollectionsKt.getLastIndex((List)bareExpressions));
        destination$iv$iv = "!(" + (String)CollectionsKt.last((List)bareExpressions);
        String accumulator$iv = initial$iv;
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                void expression2;
                prefixExpression = accumulator$iv;
                String negated = (String)iterator$iv.previous();
                accumulator$iv = (String)expression2 + " " + operatorText + " " + negated;
            }
        }
        String negatedExpression = accumulator$iv;
        KtExpression newExpression2 = KtPsiFactoryKt.KtPsiFactory((PsiElement)element2).createExpression(negatedExpression + ")");
        PsiElement insertedElement = element2.replace((PsiElement)newExpression2);
        PsiElement psiElement = insertedElement.getParent();
        if (!(psiElement instanceof KtParenthesizedExpression)) {
            psiElement = null;
        }
        KtParenthesizedExpression ktParenthesizedExpression = (KtParenthesizedExpression)psiElement;
        if (ktParenthesizedExpression == null) {
            return;
        }
        KtParenthesizedExpression insertedElementParent = ktParenthesizedExpression;
        if (KtPsiUtil.areParenthesesUseless(insertedElementParent)) {
            insertedElementParent.replace(insertedElement);
        }
    }

    private final List<KtPrefixExpression> splitBooleanSequence(KtBinaryExpression expression2) {
        LinkedList<KtExpression> itemList = new LinkedList<KtExpression>();
        IElementType firstOperator = expression2.getOperationToken();
        KtBinaryExpression currentItem = expression2;
        while (currentItem != null) {
            KtExpression ktExpression;
            KtExpression leftChild;
            KtPrefixExpression rightChild;
            if (Intrinsics.areEqual((Object)currentItem.getOperationToken(), (Object)firstOperator) ^ true) {
                return null;
            }
            KtExpression ktExpression2 = currentItem.getRight();
            if (!(ktExpression2 instanceof KtPrefixExpression)) {
                ktExpression2 = null;
            }
            if ((KtPrefixExpression)ktExpression2 == null) {
                return null;
            }
            itemList.add(rightChild);
            KtExpression ktExpression3 = leftChild = currentItem.getLeft();
            if (ktExpression3 instanceof KtPrefixExpression) {
                itemList.add(leftChild);
            } else if (!(ktExpression3 instanceof KtBinaryExpression)) {
                return null;
            }
            if (!((ktExpression = leftChild) instanceof KtBinaryExpression)) {
                ktExpression = null;
            }
            currentItem = (KtBinaryExpression)ktExpression;
        }
        return itemList;
    }

    public ConvertNegatedBooleanSequenceIntention() {
        super(KtBinaryExpression.class, "Replace negated sequence with DeMorgan equivalent", null, 4, null);
    }
}

