/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.replaceWith;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.replaceWith.DeprecatedSymbolUsageFixBase;
import org.jetbrains.kotlin.idea.quickfix.replaceWith.ReplaceWith;
import org.jetbrains.kotlin.idea.quickfix.replaceWith.UsageReplacementStrategy;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0014B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/replaceWith/DeprecatedSymbolUsageFix;", "Lorg/jetbrains/kotlin/idea/quickfix/replaceWith/DeprecatedSymbolUsageFixBase;", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "replaceWith", "Lorg/jetbrains/kotlin/idea/quickfix/replaceWith/ReplaceWith;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/idea/quickfix/replaceWith/ReplaceWith;)V", "getFamilyName", "", "getText", "invoke", "", "replacementStrategy", "Lorg/jetbrains/kotlin/idea/quickfix/replaceWith/UsageReplacementStrategy;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "idea"})
public final class DeprecatedSymbolUsageFix
extends DeprecatedSymbolUsageFixBase
implements CleanupFix,
HighPriorityAction {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return "Replace deprecated symbol usage";
    }

    @NotNull
    public String getText() {
        return "Replace with '" + this.getReplaceWith().getPattern() + "'";
    }

    @Override
    protected void invoke(@NotNull UsageReplacementStrategy replacementStrategy, @NotNull Project project, @Nullable Editor editor) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)replacementStrategy, (String)"replacementStrategy");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Function0<KtElement> function0 = replacementStrategy.createReplacer((KtSimpleNameExpression)this.getElement());
            if (function0 == null) {
                Intrinsics.throwNpe();
            }
            KtElement result2 = (KtElement)function0.invoke();
            KtExpression ktExpression = CallUtilKt.getCalleeExpressionIfAny(result2);
            int offset2 = (ktExpression != null ? (KtElement)ktExpression : result2).getTextOffset();
            Editor editor2 = editor;
            if (editor2 == null) break block1;
            GenerateUtilKt.moveCaret$default(editor2, offset2, null, 2, null);
        }
    }

    public DeprecatedSymbolUsageFix(@NotNull KtSimpleNameExpression element2, @NotNull ReplaceWith replaceWith) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)replaceWith, (String)"replaceWith");
        super(element2, replaceWith);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/replaceWith/DeprecatedSymbolUsageFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "isImportToBeRemoved", "", "import", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            void replacement;
            void nameExpression2;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DeprecatedSymbolUsageFixBase.Companion.Data data = DeprecatedSymbolUsageFixBase.Companion.extractDataFromDiagnostic(diagnostic);
            if (data == null) {
                return null;
            }
            DeprecatedSymbolUsageFixBase.Companion.Data data2 = data;
            KtSimpleNameExpression ktSimpleNameExpression = data2.component1();
            ReplaceWith replaceWith = data2.component2();
            data2 = null;
            return new DeprecatedSymbolUsageFix((KtSimpleNameExpression)nameExpression2, (ReplaceWith)replacement);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isImportToBeRemoved(@NotNull KtImportDirective ktImportDirective) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)ktImportDirective, (String)"import");
            if (ktImportDirective.isAllUnder()) return false;
            Iterable $receiver$iv = UtilsKt.targetDescriptors$default(ktImportDirective, null, 1, null);
            Iterator iterator2 = $receiver$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                Project project = ktImportDirective.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"import.project");
                if (DeprecatedSymbolUsageFixBase.Companion.fetchReplaceWithPattern(it, project) == null) return false;
                bl = true;
            } while (bl);
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

