/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.testIntegration.JavaTestFinder;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.testIntegration.KotlinTestFinder$findSourceElement$;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/testIntegration/KotlinTestFinder;", "Lcom/intellij/testIntegration/JavaTestFinder;", "()V", "findClassesForTest", "", "Lcom/intellij/psi/PsiElement;", "element", "findSourceElement", "Lcom/intellij/psi/PsiClass;", "from", "findTestsForClass", "isTest", "", "idea"})
public final class KotlinTestFinder
extends JavaTestFinder {
    @Nullable
    public PsiClass findSourceElement(@NotNull PsiElement from) {
        Object v2;
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
            PsiClass psiClass = super.findSourceElement(from);
            if (psiClass != null) {
                PsiClass psiClass2 = psiClass;
                PsiClass it = psiClass2;
                return it;
            }
            Sequence $receiver$iv = PsiUtilsKt.getParentsWithSelf(from);
            Sequence sequence2 = SequencesKt.filter($receiver$iv, (Function1)findSourceElement$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            $receiver$iv = sequence2;
            for (Object element$iv : $receiver$iv) {
                KtClassOrObject it = (KtClassOrObject)element$iv;
                if (!(!it.isLocal())) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        KtClassOrObject ktClassOrObject = v2;
        if (ktClassOrObject != null) {
            KtClassOrObject ktClassOrObject2 = ktClassOrObject;
            KtClassOrObject it = ktClassOrObject2;
            return ResolutionUtils.resolveToDescriptorIfAny(it) == null ? (PsiClass)null : (PsiClass)LightClassUtilsKt.toLightClass(it);
        }
        PsiFile psiFile = from.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        return ktFile != null ? LightClassUtilsKt.findFacadeClass(ktFile) : null;
    }

    public boolean isTest(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiClass psiClass = this.findSourceElement(element2);
        if (psiClass == null) {
            return false;
        }
        PsiClass sourceElement = psiClass;
        return super.isTest((PsiElement)sourceElement);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiClass psiClass = this.findSourceElement(element2);
        if (psiClass == null) {
            return SetsKt.emptySet();
        }
        PsiClass klass2 = psiClass;
        GlobalSearchScope scope2 = this.getSearchScope(element2, true);
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)element2.getProject());
        TestFrameworks frameworks = TestFrameworks.getInstance();
        ArrayList<Pair> classesWithWeights = new ArrayList<Pair>();
        for (Pair candidateNameWithWeight : TestFinderHelper.collectPossibleClassNamesWithWeights((String)klass2.getName())) {
            PsiClass[] psiClassArray = cache2.getClassesByName((String)candidateNameWithWeight.first, scope2);
            for (int i = 0; i < psiClassArray.length; ++i) {
                PsiClass eachClass = psiClassArray[i];
                if (eachClass.isAnnotationType() || frameworks.isTestClass(eachClass)) continue;
                if (eachClass instanceof KtLightClassForFacade) {
                    void $receiver$iv;
                    Iterable iterable = ((KtLightClassForFacade)eachClass).getFiles();
                    for (Object item$iv : $receiver$iv) {
                        Pair pair2;
                        void it;
                        KtFile ktFile = (KtFile)item$iv;
                        Collection collection = classesWithWeights;
                        Intrinsics.checkExpressionValueIsNotNull((Object)Pair.create((Object)it, (Object)candidateNameWithWeight.second), (String)"Pair.create(it, candidateNameWithWeight.second)");
                        collection.add(pair2);
                    }
                    continue;
                }
                if (!eachClass.isPhysical() && !(eachClass instanceof KtLightClassForSourceDeclaration)) continue;
                classesWithWeights.add(Pair.create((Object)eachClass, (Object)candidateNameWithWeight.second));
            }
        }
        Collection collection = TestFinderHelper.getSortedElements((List)classesWithWeights, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"TestFinderHelper.getSort\u2026lassesWithWeights, false)");
        return collection;
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiClass psiClass = this.findSourceElement(element2);
        if (psiClass == null) {
            return SetsKt.emptySet();
        }
        PsiClass klass2 = psiClass;
        ArrayList classesWithProximities = new ArrayList();
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor((Collection)classesWithProximities);
        String string = klass2.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String klassName = string;
        Pattern pattern = Pattern.compile(".*" + StringUtil.escapeToRegexp((String)klassName) + ".*", 2);
        GlobalSearchScope scope2 = this.getSearchScope((PsiElement)klass2, false);
        TestFrameworks frameworks = TestFrameworks.getInstance();
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)klass2.getProject());
        HashSet names = new HashSet();
        cache2.getAllClassNames(names);
        for (String candidateName : names) {
            if (!pattern.matcher(candidateName).matches()) continue;
            PsiClass[] psiClassArray = cache2.getClassesByName(candidateName, scope2);
            for (int i = 0; i < psiClassArray.length; ++i) {
                PsiClass candidateClass = psiClassArray[i];
                if (!frameworks.isTestClass(candidateClass) && !frameworks.isPotentialTestClass(candidateClass) || !candidateClass.isPhysical() && !(candidateClass instanceof KtLightClassForSourceDeclaration)) continue;
                processor2.process((Object)Pair.create((Object)candidateClass, (Object)TestFinderHelper.calcTestNameProximity((String)klassName, (String)candidateName)));
            }
        }
        Collection collection = TestFinderHelper.getSortedElements((List)classesWithProximities, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"TestFinderHelper.getSort\u2026sesWithProximities, true)");
        return collection;
    }
}

