/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.ReferenceSearcher;
import org.jetbrains.kotlin.j2k.UtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001$B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J(\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J \u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/j2k/OverloadReducer;", "", "methods", "", "Lcom/intellij/psi/PsiMethod;", "isOpenClass", "", "referenceSearcher", "Lorg/jetbrains/kotlin/j2k/ReferenceSearcher;", "(Ljava/util/Collection;ZLorg/jetbrains/kotlin/j2k/ReferenceSearcher;)V", "methodToLastParameterDefaults", "Ljava/util/HashMap;", "Ljava/util/ArrayList;", "Lcom/intellij/psi/PsiExpression;", "methodsToDrop", "Ljava/util/HashSet;", "buildOverloadEquivalenceMap", "", "Lorg/jetbrains/kotlin/j2k/OverloadReducer$EquivalentOverloadInfo;", "calcTargetParameterDefaults", "", "method", "target", "targetCall", "Lcom/intellij/psi/PsiMethodCallExpression;", "dropOverloadsForDefaultValues", "", "equivalenceMap", "findEquivalentOverload", "overloads", "getAnnotationsFingerprint", "parameterDefault", "parameterIndex", "", "shouldDropMethod", "shouldSkipOverload", "EquivalentOverloadInfo", "j2k"})
public final class OverloadReducer {
    private final HashMap<PsiMethod, ArrayList<PsiExpression>> methodToLastParameterDefaults;
    private final HashSet<PsiMethod> methodsToDrop;
    private final Collection<PsiMethod> methods;
    private final boolean isOpenClass;
    private final ReferenceSearcher referenceSearcher;

    public final boolean shouldDropMethod(@NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        return this.methodsToDrop.contains(method);
    }

    @Nullable
    public final PsiExpression parameterDefault(@NotNull PsiMethod method, int parameterIndex2) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        ArrayList<PsiExpression> arrayList = this.methodToLastParameterDefaults.get(method);
        if (arrayList == null) {
            return null;
        }
        ArrayList<PsiExpression> defaults = arrayList;
        int index2 = method.getParameterList().getParametersCount() - parameterIndex2 - 1;
        return index2 < defaults.size() ? defaults.get(index2) : (PsiExpression)null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PsiMethod, EquivalentOverloadInfo> buildOverloadEquivalenceMap() {
        Collection destination$iv$iv;
        Object it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = this.methods;
        Iterable iterable = $receiver$iv;
        Map map2 = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            it = (PsiMethod)element$iv$iv;
            List key$iv$iv = CollectionsKt.listOf((Object[])new Object[]{it.isConstructor() ? (String)null : it.getName(), UtilsKt.accessModifier((PsiModifierListOwner)it), it.getReturnType(), it.hasModifierProperty("static"), this.getAnnotationsFingerprint((PsiMethod)it)});
            Collection collection = destination$iv$iv;
            Object value$iv$iv$iv = collection.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                collection.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv.values();
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (List)element$iv$iv;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void $receiver$iv$iv2;
            void $receiver$iv2;
            it = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            Iterable $i$a$2$filter = (Iterable)it;
            void $i$f$filterTo = $receiver$iv2;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                PsiMethod it2 = (PsiMethod)element$iv$iv;
                if (this.shouldSkipOverload(it2)) continue;
                collection2.add(element$iv$iv);
            }
            List list2 = (List)collection2;
            collection.add(list2);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (List)element$iv$iv;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List overloadGroups = (List)destination$iv$iv;
        HashMap map3 = new HashMap();
        for (List group : overloadGroups) {
            for (PsiMethod method : group) {
                EquivalentOverloadInfo overloadInfo;
                if (this.findEquivalentOverload(method, group) == null) {
                    continue;
                }
                EquivalentOverloadInfo furtherOverloadInfo = (EquivalentOverloadInfo)map3.get(overloadInfo.getMethod());
                EquivalentOverloadInfo resultOverloadInfo = furtherOverloadInfo != null ? new EquivalentOverloadInfo(furtherOverloadInfo.getMethod(), CollectionsKt.plus((Collection)overloadInfo.getParameterDefaults(), (Iterable)furtherOverloadInfo.getParameterDefaults())) : overloadInfo;
                Map map4 = map3;
                Iterator iterator2 = resultOverloadInfo;
                map4.put(method, iterator2);
                for (Map.Entry entry : map3.entrySet()) {
                    if (!Intrinsics.areEqual((Object)((EquivalentOverloadInfo)entry.getValue()).getMethod(), (Object)method)) continue;
                    List newParameterDefaults = CollectionsKt.plus((Collection)((EquivalentOverloadInfo)entry.getValue()).getParameterDefaults(), (Iterable)resultOverloadInfo.getParameterDefaults());
                    entry.setValue(new EquivalentOverloadInfo(resultOverloadInfo.getMethod(), newParameterDefaults));
                }
            }
        }
        return map3;
    }

    private final boolean shouldSkipOverload(PsiMethod method) {
        if (method.isConstructor()) {
            return false;
        }
        if (method.hasModifierProperty("abstract")) {
            return true;
        }
        if (method.hasModifierProperty("native")) {
            return true;
        }
        if (method.hasModifierProperty("synchronized")) {
            return true;
        }
        Collection collection = method.getHierarchicalMethodSignature().getSuperSignatures();
        if (!collection.isEmpty()) {
            return true;
        }
        return this.isOpenClass && this.referenceSearcher.hasOverrides(method);
    }

    private final EquivalentOverloadInfo findEquivalentOverload(PsiMethod method, Collection<? extends PsiMethod> overloads) {
        String string;
        PsiExpression psiExpression;
        PsiStatement statement2;
        PsiStatement psiStatement = method.getBody();
        if (psiStatement == null || (psiStatement = psiStatement.getStatements()) == null || (psiStatement = (PsiStatement)ArraysKt.singleOrNull((Object[])((Object[])psiStatement))) == null) {
            return null;
        }
        PsiStatement psiStatement2 = statement2 = psiStatement;
        if (!((psiStatement2 instanceof PsiExpressionStatement ? ((PsiExpressionStatement)statement2).getExpression() : (psiExpression = psiStatement2 instanceof PsiReturnStatement ? ((PsiReturnStatement)statement2).getReturnValue() : (PsiExpression)null)) instanceof PsiMethodCallExpression)) {
            psiExpression = null;
        }
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)psiExpression;
        if (psiMethodCallExpression == null) {
            return null;
        }
        PsiMethodCallExpression methodCall = psiMethodCallExpression;
        if (method.isConstructor()) {
            string = "this";
        } else {
            String string2 = method.getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"method.name");
        }
        String expectedMethodName = string;
        PsiReferenceExpression refExpr = methodCall.getMethodExpression();
        if (refExpr.isQualified() || Intrinsics.areEqual((Object)refExpr.getReferenceName(), (Object)expectedMethodName) ^ true) {
            return null;
        }
        PsiElement psiElement = refExpr.resolve();
        if (!(psiElement instanceof PsiMethod)) {
            psiElement = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement;
        if (psiMethod == null) {
            return null;
        }
        PsiMethod target = psiMethod;
        if (overloads.contains(target) ^ true) {
            return null;
        }
        List<PsiExpression> list2 = this.calcTargetParameterDefaults(method, target, methodCall);
        if (list2 == null) {
            return null;
        }
        List<PsiExpression> parameterDefaults = list2;
        return new EquivalentOverloadInfo(target, parameterDefaults);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiExpression> calcTargetParameterDefaults(PsiMethod method, PsiMethod target, PsiMethodCallExpression targetCall) {
        PsiParameter[] targetParameters;
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (((Object[])parameters2).length >= ((Object[])(targetParameters = target.getParameterList().getParameters())).length) {
            return null;
        }
        PsiExpression[] args = targetCall.getArgumentList().getExpressions();
        if (((Object[])args).length != ((Object[])targetParameters).length) {
            return null;
        }
        int n = 0;
        int n2 = parameters2.length - 1;
        if (n <= n2) {
            while (true) {
                void i;
                PsiParameter parameter = parameters2[i];
                PsiParameter targetParameter = targetParameters[i];
                if (Intrinsics.areEqual((Object)parameter.getName(), (Object)targetParameter.getName()) ^ true || Intrinsics.areEqual((Object)parameter.getType(), (Object)targetParameter.getType()) ^ true) {
                    return null;
                }
                PsiExpression arg = args[i];
                if (!(arg instanceof PsiReferenceExpression) || Intrinsics.areEqual((Object)((PsiReferenceExpression)arg).resolve(), (Object)parameter) ^ true) {
                    return null;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return ArraysKt.drop((Object[])args, (int)((Object[])parameters2).length);
    }

    /*
     * WARNING - void declaration
     */
    private final void dropOverloadsForDefaultValues(Map<PsiMethod, EquivalentOverloadInfo> equivalenceMap) {
        String it2;
        Comparator destination$iv$iv;
        void $receiver$iv$iv;
        Object $receiver$iv = equivalenceMap;
        Iterator iterator2 = $receiver$iv;
        Collection collection = new ArrayList($receiver$iv.size());
        void var6_6 = $receiver$iv$iv;
        Iterator iterator3 = var6_6.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator3.next();
            void var15_14 = destination$iv$iv;
            PsiMethod psiMethod = (PsiMethod)it2.getKey();
            var15_14.add(psiMethod);
        }
        $receiver$iv = (List)((Object)destination$iv$iv);
        iterator2 = $receiver$iv;
        destination$iv$iv = new Comparator<PsiMethod>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int compare(Object a, Object b) {
                PsiMethod it = (PsiMethod)b;
                Comparable comparable = Integer.valueOf(it.getParameterList().getParametersCount());
                it = (PsiMethod)a;
                Comparable comparable2 = comparable;
                Integer n = it.getParameterList().getParametersCount();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        List dropCandidates = CollectionsKt.sortedWith((Iterable)((Object)iterator2), (Comparator)destination$iv$iv);
        block1: for (PsiMethod method : dropCandidates) {
            Object object;
            void key$iv;
            void $receiver$iv22;
            EquivalentOverloadInfo targetInfo;
            int targetParamCount;
            int paramCount = method.getParameterList().getParametersCount();
            if (equivalenceMap.get(method) == null) {
                Intrinsics.throwNpe();
            }
            boolean item$iv$iv = paramCount < (targetParamCount = targetInfo.getMethod().getParameterList().getParametersCount());
            if (_Assertions.ENABLED && !item$iv$iv) {
                it2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)it2));
            }
            List<PsiExpression> defaults = targetInfo.getParameterDefaults();
            boolean it2 = defaults.size() == targetParamCount - paramCount;
            if (_Assertions.ENABLED && !it2) {
                String $i$a$1$map = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$1$map));
            }
            Map $i$a$1$map = this.methodToLastParameterDefaults;
            PsiMethod $i$f$mapTo = targetInfo.getMethod();
            Object value$iv = $receiver$iv22.get(key$iv);
            if (value$iv == null) {
                ArrayList answer$iv = new ArrayList();
                $receiver$iv22.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ArrayList targetDefaults = (ArrayList)object;
            int $receiver$iv22 = 0;
            int n = ((Collection)defaults).size() - 1;
            if ($receiver$iv22 <= n) {
                while (true) {
                    void i;
                    PsiExpression psiExpression = defaults.get(defaults.size() - i - 1);
                    if (i < targetDefaults.size()) {
                        if (Intrinsics.areEqual((Object)((PsiExpression)targetDefaults.get((int)i)).getText(), (Object)psiExpression.getText()) ^ true) {
                            continue block1;
                        }
                    } else {
                        targetDefaults.add(psiExpression);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            this.methodsToDrop.add(method);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Object getAnnotationsFingerprint(PsiMethod method) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Object[] $receiver$iv = method.getModifierList().getAnnotations();
        Object[] objectArray = $receiver$iv;
        Collection collection = new ArrayList($receiver$iv.length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void it;
            void item$iv$iv = $receiver$iv$iv[i];
            PsiAnnotation psiAnnotation = (PsiAnnotation)item$iv$iv;
            void var11_8 = destination$iv$iv;
            String string = it.getText();
            var11_8.add(string);
        }
        return (List)destination$iv$iv;
    }

    public OverloadReducer(@NotNull Collection<? extends PsiMethod> methods2, boolean isOpenClass, @NotNull ReferenceSearcher referenceSearcher) {
        Intrinsics.checkParameterIsNotNull(methods2, (String)"methods");
        Intrinsics.checkParameterIsNotNull((Object)referenceSearcher, (String)"referenceSearcher");
        this.methods = methods2;
        this.isOpenClass = isOpenClass;
        this.referenceSearcher = referenceSearcher;
        this.methodToLastParameterDefaults = new HashMap();
        this.methodsToDrop = new HashSet();
        Map<PsiMethod, EquivalentOverloadInfo> map2 = this.buildOverloadEquivalenceMap();
        this.dropOverloadsForDefaultValues(map2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/j2k/OverloadReducer$EquivalentOverloadInfo;", "", "method", "Lcom/intellij/psi/PsiMethod;", "parameterDefaults", "", "Lcom/intellij/psi/PsiExpression;", "(Lcom/intellij/psi/PsiMethod;Ljava/util/List;)V", "getMethod", "()Lcom/intellij/psi/PsiMethod;", "getParameterDefaults", "()Ljava/util/List;", "j2k"})
    private static final class EquivalentOverloadInfo {
        @NotNull
        private final PsiMethod method;
        @NotNull
        private final List<PsiExpression> parameterDefaults;

        @NotNull
        public final PsiMethod getMethod() {
            return this.method;
        }

        @NotNull
        public final List<PsiExpression> getParameterDefaults() {
            return this.parameterDefaults;
        }

        public EquivalentOverloadInfo(@NotNull PsiMethod method, @NotNull List<? extends PsiExpression> parameterDefaults) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull(parameterDefaults, (String)"parameterDefaults");
            this.method = method;
            this.parameterDefaults = parameterDefaults;
        }
    }
}

