/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidOSProcessHandler;
import org.jetbrains.annotations.NotNull;

public final class AndroidExecutionUtil {
    private AndroidExecutionUtil() {
    }

    @NotNull
    public static Map<AndroidCompilerMessageKind, List<String>> doExecute(String ... argv) throws IOException {
        Map<AndroidCompilerMessageKind, List<String>> map = AndroidExecutionUtil.doExecute(argv, Collections.emptyMap());
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidExecutionUtil", "doExecute"));
        }
        return map;
    }

    @NotNull
    public static Map<AndroidCompilerMessageKind, List<String>> doExecute(String[] argv, @NotNull Map<? extends String, ? extends String> enviroment) throws IOException {
        Process process;
        if (enviroment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enviroment", "org/jetbrains/android/util/AndroidExecutionUtil", "doExecute"));
        }
        AndroidBuildTestingManager testingManager = AndroidBuildTestingManager.getTestingManager();
        if (testingManager != null) {
            process = testingManager.getCommandExecutor().createProcess(argv, enviroment);
        } else {
            ProcessBuilder builder = new ProcessBuilder(argv);
            builder.environment().putAll(enviroment);
            process = builder.start();
        }
        ProcessResult result = AndroidExecutionUtil.readProcessOutput(process, StringUtil.join((String[])argv, (String)" "));
        Map<AndroidCompilerMessageKind, List<String>> messages = result.getMessages();
        int code = result.getExitCode();
        List<String> errMessages = messages.get((Object)AndroidCompilerMessageKind.ERROR);
        if (code != 0 && errMessages.isEmpty()) {
            throw new IOException("Command \"" + AndroidExecutionUtil.concat(argv) + "\" execution failed with exit code " + code);
        }
        if (code == 0) {
            messages.get((Object)AndroidCompilerMessageKind.WARNING).addAll(errMessages);
            errMessages.clear();
        }
        Map<AndroidCompilerMessageKind, List<String>> map = messages;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidExecutionUtil", "doExecute"));
        }
        return map;
    }

    private static String concat(String ... strs) {
        StringBuilder builder = new StringBuilder();
        int n = strs.length;
        for (int i = 0; i < n; ++i) {
            builder.append(strs[i]);
            if (i >= n - 1) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    @NotNull
    private static ProcessResult readProcessOutput(@NotNull Process process, @NotNull String commandLine) throws IOException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/android/util/AndroidExecutionUtil", "readProcessOutput"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "org/jetbrains/android/util/AndroidExecutionUtil", "readProcessOutput"));
        }
        AndroidOSProcessHandler handler = new AndroidOSProcessHandler(process, commandLine);
        handler.startNotify();
        handler.waitFor();
        int exitCode = handler.getProcess().exitValue();
        ProcessResult processResult = new ProcessResult(handler.getInfoMessages(), handler.getErrorMessages(), exitCode);
        if (processResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidExecutionUtil", "readProcessOutput"));
        }
        return processResult;
    }

    public static <T> void addMessages(@NotNull Map<T, List<String>> messages, @NotNull Map<T, List<String>> toAdd) {
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "org/jetbrains/android/util/AndroidExecutionUtil", "addMessages"));
        }
        if (toAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAdd", "org/jetbrains/android/util/AndroidExecutionUtil", "addMessages"));
        }
        for (Map.Entry<T, List<String>> entry : toAdd.entrySet()) {
            List<String> list = messages.get(entry.getKey());
            if (list == null) {
                list = new ArrayList<String>();
                messages.put(entry.getKey(), list);
            }
            list.addAll((Collection<String>)entry.getValue());
        }
    }

    private static final class ProcessResult {
        private final int myExitCode;
        private final Map<AndroidCompilerMessageKind, List<String>> myMessages;

        public ProcessResult(List<String> information, List<String> error, int exitCode) {
            this.myExitCode = exitCode;
            this.myMessages = new HashMap<AndroidCompilerMessageKind, List<String>>(2);
            this.myMessages.put(AndroidCompilerMessageKind.INFORMATION, information);
            this.myMessages.put(AndroidCompilerMessageKind.ERROR, error);
            this.myMessages.put(AndroidCompilerMessageKind.WARNING, new ArrayList());
        }

        public Map<AndroidCompilerMessageKind, List<String>> getMessages() {
            return this.myMessages;
        }

        public int getExitCode() {
            return this.myExitCode;
        }
    }
}

