/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class ConvertSimpleGetterToPropertyIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertSimpleGetterToPropertyIntention", "processIntention"));
        }
        GrMethod method = (GrMethod)element.getParent();
        GrStatement statement = method.getBlock().getStatements()[0];
        GrExpression value = statement instanceof GrReturnStatement ? ((GrReturnStatement)statement).getReturnValue() : (GrExpression)statement;
        String fieldName = GroovyPropertyUtils.getPropertyNameByGetter(method);
        String[] modifiers = method.hasModifierProperty("static") ? new String[]{"static", "final"} : new String[]{"final"};
        GrVariableDeclaration declaration = GroovyPsiElementFactory.getInstance(project).createFieldDeclaration(modifiers, fieldName, value, method.getReturnType());
        PsiClass aClass = method.getContainingClass();
        PsiElement replaced = aClass.addBefore((PsiElement)declaration, (PsiElement)method);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced);
        method.delete();
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                PsiElement parent = element.getParent();
                if (!(parent instanceof GrMethod) || ((GrMethod)parent).getNameIdentifierGroovy() != element) {
                    return false;
                }
                GrMethod method = (GrMethod)parent;
                GrOpenBlock block = method.getBlock();
                if (block == null) {
                    return false;
                }
                GrStatement[] statements = block.getStatements();
                if (statements.length != 1) {
                    return false;
                }
                if (!GroovyPropertyUtils.isSimplePropertyGetter(method)) {
                    return false;
                }
                if (GroovyPropertyUtils.findFieldForAccessor(method, true) != null) {
                    return false;
                }
                GrStatement statement = statements[0];
                return statement instanceof GrReturnStatement && ((GrReturnStatement)statement).getReturnValue() != null || statement instanceof GrExpression && !PsiType.VOID.equals((Object)((GrExpression)statement).getType());
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertSimpleGetterToPropertyIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }
}

