/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import org.intellij.lang.xpath.context.XPathVersion;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathNumber;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.impl.XPathElementImpl;
import org.jetbrains.annotations.NotNull;

public class XPathNumberImpl
extends XPathElementImpl
implements XPathNumber {
    public XPathNumberImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public XPathType getType() {
        if (this.getXPathVersion() == XPathVersion.V1) {
            XPathType xPathType = XPathType.NUMBER;
            if (xPathType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathNumberImpl", "getType"));
            }
            return xPathType;
        }
        if (this.isScientificNotation()) {
            XPath2Type xPath2Type = XPath2Type.DOUBLE;
            if (xPath2Type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathNumberImpl", "getType"));
            }
            return xPath2Type;
        }
        if (this.textContains('.')) {
            XPath2Type xPath2Type = XPath2Type.DECIMAL;
            if (xPath2Type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathNumberImpl", "getType"));
            }
            return xPath2Type;
        }
        XPath2Type xPath2Type = XPath2Type.INTEGER;
        if (xPath2Type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathNumberImpl", "getType"));
        }
        return xPath2Type;
    }

    public boolean isScientificNotation() {
        return this.textContains('e') || this.textContains('E');
    }

    @Override
    public double getValue() {
        return Double.parseDouble(this.getText());
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathNumber(this);
    }
}

