/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SelfReference
implements PsiReference {
    private final XmlAttributeValue myValue;
    private final PsiElement myTarget;
    private final int myStartOffset;

    public SelfReference(XmlAttribute element, PsiElement target, int startOffset) {
        this.myTarget = target;
        this.myValue = element.getValueElement();
        this.myStartOffset = startOffset;
    }

    SelfReference(XmlAttribute element, PsiElement target) {
        this(element, target, 0);
    }

    public PsiElement getElement() {
        return this.myValue;
    }

    public TextRange getRangeInElement() {
        return TextRange.from((int)(1 + this.myStartOffset), (int)(this.myValue.getTextLength() - (2 + this.myStartOffset)));
    }

    @Nullable
    public PsiElement resolve() {
        return this.myValue.isValid() ? this.myTarget : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myValue.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/references/SelfReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.myValue;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/impl/references/SelfReference", "bindToElement"));
        }
        return this.myValue;
    }

    public boolean isReferenceTo(PsiElement element) {
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/references/SelfReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    public static SelfReference create(XmlAttribute element, PsiElement target) {
        if (element.getValue().contains(":")) {
            return new SelfReference(element, target, element.getValue().indexOf(58) + 1);
        }
        return new SelfReference(element, target);
    }
}

