/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.HaxmAlert;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdConfigurationOptionHelpPanel
extends JPanel {
    private JBLabel myValidationLabel;
    private HaxmAlert myHaxmAlert;
    private JBLabel myTitle;
    private JSeparator mySeparator;
    private JBLabel myDescription;
    private JPanel myContentPanel;
    private JPanel myRoot;
    private JPanel myValidationPanel;
    private static Map<ScopedStateStore.Key<?>, String> TITLES = ImmutableMap.builder().put(AvdWizardConstants.RAM_STORAGE_KEY, (Object)"Device RAM").put(AvdWizardConstants.VM_HEAP_STORAGE_KEY, (Object)"Virtual Machine Heap").put(AvdWizardConstants.INTERNAL_STORAGE_KEY, (Object)"Internal Flash").put(AvdWizardConstants.SD_CARD_STORAGE_KEY, (Object)"Built-in SD Card Size").put(AvdWizardConstants.EXISTING_SD_LOCATION, (Object)"Location of external SD card image").put(AvdWizardConstants.SCALE_SELECTION_KEY, (Object)"Start-Up Size").put(AvdWizardConstants.DEFAULT_ORIENTATION_KEY, (Object)"Default Orientation").put(AvdWizardConstants.NETWORK_SPEED_KEY, (Object)"Network Speed").put(AvdWizardConstants.NETWORK_LATENCY_KEY, (Object)"Network Latency").put(AvdWizardConstants.FRONT_CAMERA_KEY, (Object)"Front Camera").put(AvdWizardConstants.BACK_CAMERA_KEY, (Object)"Back Camera").put(AvdWizardConstants.HOST_GPU_MODE_KEY, (Object)"Graphics Rendering").put(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, (Object)"Custom Device Frame").put(AvdWizardConstants.DISPLAY_NAME_KEY, (Object)"AVD Name").put(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY, (Object)"Enable keyboard input").put(AvdWizardConstants.AVD_ID_KEY, (Object)"AVD Id").put(AvdWizardConstants.DEVICE_FRAME_KEY, (Object)"Enable device frame").put(AvdWizardConstants.CPU_CORES_KEY, (Object)"Number of cores").build();
    private static Map<ScopedStateStore.Key<?>, String> DESCRIPTIONS = ImmutableMap.builder().put(AvdWizardConstants.RAM_STORAGE_KEY, (Object)"The amount of physical RAM on the device.\n1 MB = 1024 KB\n1 GB = 1024 MB").put(AvdWizardConstants.VM_HEAP_STORAGE_KEY, (Object)"The amount of RAM available to Java virtual machine (VM) to allocate to running apps on the device. A larger VM heap allows application to run longer between garbage collection event.").put(AvdWizardConstants.INTERNAL_STORAGE_KEY, (Object)"The amount of non-removable space available to store data on the device.").put(AvdWizardConstants.SD_CARD_STORAGE_KEY, (Object)"The amount of removable space available to store data on the device. We recommend at least 100MB in order to use the camera in the emulator.").put(AvdWizardConstants.EXISTING_SD_LOCATION, (Object)"Choose a file path to an existing SD Card image. Using an external SD Card is useful when sharing SD Card data (pictures, media, files, etc.) between Android Virtual Devices. See http://d.android.com/tools/help/mksdcard.html for more details. ").put(AvdWizardConstants.SCALE_SELECTION_KEY, (Object)"Enables you to test your application on a screen that uses a resolution or density not supported by the built-in AVD device frames, you can create an AVD that uses a custom resolution by selecting one of the scale values.").put(AvdWizardConstants.DEFAULT_ORIENTATION_KEY, (Object)"Sets the initial orientation of the device. During AVD emulation you can also rotate the device screen. ").put(AvdWizardConstants.NETWORK_SPEED_KEY, (Object)"Sets the initial state of the simulated network transfer rate used by AVD.  The network speed can also be adjusted in the emulator.").put(AvdWizardConstants.NETWORK_LATENCY_KEY, (Object)"Sets the initial state of the simulated network transfer latency used by AVD.  Latency is the delay in processing data across the network. The latency speed can also be adjusted in the emulator.").put(AvdWizardConstants.FRONT_CAMERA_KEY, (Object)"None - no camera installed for AVD<br>Emulated - use a simulated camera<br>Device -  use host computer webcam or built-in camera").put(AvdWizardConstants.BACK_CAMERA_KEY, (Object)"None - no camera installed for AVD<br>Emulated - use a simulated camera<br>Device -  use host computer webcam or built-in camera").put(AvdWizardConstants.HOST_GPU_MODE_KEY, (Object)"Choose how the graphics should be rendered in the emulator.<br><br><b>Hardware</b><br>Use your computer's graphics card for faster rendering.<br><br><b>Software</b><br>Emulate the graphics in software, use this to work around issues with your computer's graphics card.<br><br><b>Auto</b><br>Let the emulator decide the best option based on knowledge about your graphics card.").put(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, (Object)"A collection of images and configuration data that indicates how to populate the window. Each skin can have several \"layouts\" (e.g. \"landscape\" and \"portrait\") corresponding to different orientation / physical configurations of the emulated device.").put(AvdWizardConstants.DISPLAY_NAME_KEY, (Object)"The name of this AVD.").put(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY, (Object)"Enables you to enter text input and interact with the AVD with your hardware computer keyboard instead of a of the on on-screen software keyboard.").put(AvdWizardConstants.AVD_ID_KEY, (Object)"Identification name used to save an AVD on disk. This AVD name can also be used with Android command line tools.").put(AvdWizardConstants.DEVICE_FRAME_KEY, (Object)"Enable a frame around the Android emulator window that mimics the look of a real Android device. Click on Show Advanced Settings for more options.").put(AvdWizardConstants.CPU_CORES_KEY, (Object)"Select the number of CPU cores for the emulator to use.").build();

    public AvdConfigurationOptionHelpPanel() {
        this.$$$setupUI$$$();
        this.mySeparator.setForeground(JBColor.foreground());
        this.myRoot.setBackground((Color)JBColor.WHITE);
        this.myTitle.setFont(AvdWizardConstants.TITLE_FONT);
        this.myValidationLabel.setForeground((Color)JBColor.RED);
        this.add(this.myRoot);
        Dimension preferred = new Dimension(JBUI.scale((int)500), -1);
        this.myTitle.setPreferredSize(preferred);
        this.myDescription.setPreferredSize(preferred);
        this.myValidationLabel.setPreferredSize(preferred);
        this.myValidationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Error"), BorderFactory.createEmptyBorder(0, 5, 3, 5)));
    }

    public void setSystemImageDescription(SystemImageDescription desc) {
        this.myHaxmAlert.setSystemImageDescription(desc);
    }

    public void setDescriptionText(@Nullable String descriptionText) {
        if (descriptionText == null || descriptionText.isEmpty()) {
            ((CardLayout)this.myContentPanel.getLayout()).show(this.myContentPanel, "NothingSelected");
        } else {
            ((CardLayout)this.myContentPanel.getLayout()).show(this.myContentPanel, "Info");
            Iterable iterable = Splitter.on((char)'|').split((CharSequence)descriptionText);
            this.myTitle.setText("<html>" + (String)Iterables.getFirst((Iterable)iterable, null) + "</html>");
            this.myDescription.setText("<html>" + (String)Iterables.getLast((Iterable)iterable, null) + "</html>");
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.pack();
        }
    }

    public void setErrorMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/avdmanager/AvdConfigurationOptionHelpPanel", "setErrorMessage"));
        }
        if (message == null || message.isEmpty()) {
            this.myValidationPanel.setVisible(false);
            return;
        }
        this.myValidationPanel.setVisible(true);
        this.myValidationLabel.setText("<html>" + message + "</html>");
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.pack();
        }
    }

    public String getDescription(ScopedStateStore.Key<?> key) {
        return TITLES.get(key) + "|" + DESCRIPTIONS.get(key);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        HaxmAlert haxmAlert;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JSeparator jSeparator;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myRoot = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel2.setOpaque(false);
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Nothing Selected");
        jBLabel4.setHorizontalAlignment(0);
        jPanel2.add((Component)jBLabel4, "NothingSelected");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setOpaque(false);
        jPanel2.add((Component)jPanel4, "Info");
        this.mySeparator = jSeparator = new JSeparator();
        jPanel4.add((Component)jSeparator, new GridConstraints(1, 0, 1, 1, 1, 1, 0, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setOpaque(false);
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        Font font = jPanel5.getFont();
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(15, 15, 5, 15), null, 0, 0, new Font(font.getName(), font.getStyle(), font.getSize()), null));
        this.myTitle = jBLabel3 = new JBLabel();
        jBLabel3.setHorizontalTextPosition(10);
        jPanel5.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.setOpaque(false);
        ((Component)jPanel6).setVisible(true);
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 15, 10, 15), null, 0, 0, null, null));
        this.myDescription = jBLabel2 = new JBLabel();
        jPanel6.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.setOpaque(false);
        jPanel3.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 20, 20, 20), null, 0, 0, null, null));
        this.myHaxmAlert = haxmAlert = new HaxmAlert();
        jPanel7.add((Component)haxmAlert, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myValidationPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setOpaque(false);
        ((Component)jPanel).setVisible(false);
        jPanel7.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myValidationLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

