/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.UiCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.ImageCellController;
import com.android.tools.idea.editors.gfxtrace.controllers.ImagePanelController;
import com.android.tools.idea.editors.gfxtrace.renderers.ImageCellRenderer;
import com.android.tools.idea.editors.gfxtrace.service.ResourceInfo;
import com.android.tools.idea.editors.gfxtrace.service.Resources;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.gfxapi.Cubemap;
import com.android.tools.idea.editors.gfxtrace.service.gfxapi.Texture2D;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.service.image.Format;
import com.android.tools.idea.editors.gfxtrace.service.image.ImageInfo;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.service.path.ResourcePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ResourcesPath;
import com.android.tools.idea.editors.gfxtrace.service.path.ThumbnailPath;
import com.android.tools.idea.editors.gfxtrace.widgets.ImageCellList;
import com.android.tools.rpclib.futures.FutureController;
import com.android.tools.rpclib.futures.SingleInFlight;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TexturesController
extends ImagePanelController {
    private static final Dimension DISPLAY_SIZE = new Dimension(8192, 8192);

    public static JComponent createUI(GfxTraceEditor editor) {
        return new TexturesController((GfxTraceEditor)editor).myPanel;
    }

    public TexturesController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController", "<init>"));
        }
        super(editor, "Select a frame or command");
        this.myPanel.add((Component)new DropDownController((GfxTraceEditor)editor){

            @Override
            public void selected(DropDownController.Data item) {
                TexturesController.this.setEmptyText(this.myList.isEmpty() ? "No textures have been created by this point" : "Select a texture");
                TexturesController.this.setImage(item == null ? null : FetchedImage.load(this.myEditor.getClient(), item.path.as(Format.RGBA)));
            }
        }.myList, "North");
        this.initToolbar(new DefaultActionGroup(), true);
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
    }

    private static abstract class DropDownController
    extends ImageCellController<Data> {
        private static final Dimension CONTROL_SIZE = JBUI.size((int)100, (int)50);
        private static final Dimension REQUEST_SIZE = JBUI.size((int)100, (int)100);
        @NotNull
        private static final Logger LOG = Logger.getInstance(TexturesController.class);
        @NotNull
        private final PathStore<ResourcesPath> myResourcesPath;
        @NotNull
        private final PathStore<AtomPath> myAtomPath;
        @NotNull
        private Resources myResources;

        private DropDownController(@NotNull GfxTraceEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController$DropDownController", "<init>"));
            }
            super(editor);
            this.myResourcesPath = new PathStore();
            this.myAtomPath = new PathStore();
            this.usingComboBoxWidget(CONTROL_SIZE);
            ((ImageCellRenderer)this.myList.getRenderer()).setLayout(ImageCellRenderer.Layout.LEFT_TO_RIGHT);
        }

        @Override
        public void loadCell(Data cell, Runnable onLoad) {
            ServiceClient client = this.myEditor.getClient();
            ThumbnailPath path = cell.path.thumbnail(REQUEST_SIZE, Format.RGBA);
            this.loadCellImage(cell, client, path, onLoad);
            this.loadCellMetadata(cell);
        }

        private void loadCellMetadata(final Data cell) {
            Rpc.listen(this.myEditor.getClient().get(cell.path), (Logger)LOG, (FutureController)cell.extraController, (Rpc.Callback)new UiCallback<Object, String>(){

                @Override
                protected String onRpcThread(Rpc.Result<Object> result) throws RpcException, ExecutionException {
                    Object resource = result.get();
                    if (resource instanceof Texture2D) {
                        Texture2D texture = (Texture2D)resource;
                        return DropDownController.getTextureDisplayLabel(cell, texture.getLevels()[0], texture.getLevels().length);
                    }
                    if (resource instanceof Cubemap) {
                        Cubemap texture = (Cubemap)resource;
                        return DropDownController.getTextureDisplayLabel(cell, texture.getLevels()[0].getNegativeZ(), texture.getLevels().length);
                    }
                    return null;
                }

                @Override
                protected void onUiThread(String result) {
                    if (result != null) {
                        cell.extraLabel = result;
                        myList.repaint();
                    }
                }
            });
        }

        static String getTextureDisplayLabel(Data cell, ImageInfo base, int mipmapLevels) {
            return " - " + base.getFormat().getDisplayName() + " - " + base.getWidth() + "x" + base.getHeight() + (mipmapLevels > 1 ? " - " + mipmapLevels + " mip levels" : "") + " - Modified " + cell.info.getAccesses().length + " times";
        }

        protected void update(boolean resourcesChanged) {
            if (this.myAtomPath.getPath() != null && this.myResources != null) {
                ArrayList<Data> cells = new ArrayList<Data>();
                this.addTextures(cells, this.myResources.getTextures1D(), "1D");
                this.addTextures(cells, this.myResources.getTextures2D(), "2D");
                this.addTextures(cells, this.myResources.getTextures3D(), "3D");
                this.addTextures(cells, this.myResources.getCubemaps(), "Cubemap");
                int selectedIndex = this.myList.getSelectedItem();
                this.myList.setData(cells);
                if (!resourcesChanged && selectedIndex >= 0 && selectedIndex < cells.size()) {
                    this.myList.selectItem(selectedIndex, false);
                    this.selected(cells.get(selectedIndex));
                } else {
                    this.myList.selectItem(-1, false);
                    this.selected(null);
                }
            }
        }

        private void addTextures(List<Data> cells, ResourceInfo[] textures, String typeLabel) {
            AtomPath atomPath = this.myAtomPath.getPath();
            for (ResourceInfo info : textures) {
                if (info.getFirstAccess() > atomPath.getIndex()) continue;
                cells.add(new Data(info, typeLabel, atomPath.resourceAfter(info.getID())));
            }
        }

        @Override
        public void notifyPath(PathListener.PathEvent event) {
            if (this.myResourcesPath.updateIfNotNull(CapturePath.resources(event.findCapturePath()))) {
                Rpc.listen(this.myEditor.getClient().get(this.myResourcesPath.getPath()), (Logger)LOG, (Rpc.Callback)new UiCallback<Resources, Resources>(){

                    @Override
                    protected Resources onRpcThread(Rpc.Result<Resources> result) throws RpcException, ExecutionException {
                        return (Resources)result.get();
                    }

                    @Override
                    protected void onUiThread(Resources result) {
                        myResources = result;
                        this.update(true);
                    }
                });
            }
            if (this.myAtomPath.updateIfNotNull(event.findAtomPath())) {
                this.update(false);
            }
        }

        public static class Data
        extends ImageCellList.Data {
            @NotNull
            public final SingleInFlight extraController;
            @NotNull
            public final ResourceInfo info;
            @NotNull
            public final ResourcePath path;
            public String extraLabel;

            public Data(@NotNull ResourceInfo info, @NotNull String typeLabel, @NotNull ResourcePath path) {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController$DropDownController$Data", "<init>"));
                }
                if (typeLabel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeLabel", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController$DropDownController$Data", "<init>"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController$DropDownController$Data", "<init>"));
                }
                super(typeLabel + " " + info.getName());
                this.extraController = new SingleInFlight();
                this.info = info;
                this.path = path;
            }

            @Override
            public String getLabel() {
                return super.getLabel() + (this.extraLabel == null ? "" : " " + this.extraLabel);
            }
        }
    }
}

