/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.TreeTraversal;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteredTraverserBase<T, Self extends FilteredTraverserBase<T, Self>>
implements Iterable<T> {
    protected final Meta<T> meta;
    protected final Function<T, ? extends Iterable<? extends T>> tree;

    protected FilteredTraverserBase(@Nullable Meta<T> meta, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/FilteredTraverserBase", "<init>"));
        }
        this.tree = tree;
        this.meta = meta == null ? Meta.empty() : meta;
    }

    @NotNull
    public final T getRoot() {
        Object t = this.meta.roots.iterator().next();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "getRoot"));
        }
        return t;
    }

    @NotNull
    public final Iterable<? extends T> getRoots() {
        Iterable iterable = this.meta.roots;
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "getRoots"));
        }
        return iterable;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.traverse().iterator();
    }

    @NotNull
    protected abstract Self newInstance(Meta<T> var1);

    @NotNull
    public final JBIterable<T> traverse(@NotNull TreeTraversal traversal) {
        if (traversal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traversal", "com/intellij/util/containers/FilteredTraverserBase", "traverse"));
        }
        Function adjusted = new Function<T, Iterable<? extends T>>(){

            @Override
            public Iterable<? extends T> fun(T t) {
                return FilteredTraverserBase.this.children(t);
            }
        };
        JBIterable jBIterable = traversal.traversal(this.getRoots(), adjusted).filter(this.meta.filter.AND);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "traverse"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> traverse() {
        JBIterable<T> jBIterable = this.traverse(this.meta.traversal);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "traverse"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> preOrderDfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.PRE_ORDER_DFS);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "preOrderDfsTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> postOrderDfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.POST_ORDER_DFS);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "postOrderDfsTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> bfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.PLAIN_BFS);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "bfsTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> tracingBfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.TRACING_BFS);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "tracingBfsTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final Self reset() {
        Self Self = this.newInstance(this.meta.reset());
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "reset"));
        }
        return Self;
    }

    @NotNull
    public final Self withRoot(@Nullable T root) {
        Self Self = this.newInstance(this.meta.withRoots(ContainerUtil.createMaybeSingletonList(root)));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "withRoot"));
        }
        return Self;
    }

    @NotNull
    public final Self withRoots(@NotNull Iterable<? extends T> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/FilteredTraverserBase", "withRoots"));
        }
        Self Self = this.newInstance(this.meta.withRoots(roots));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "withRoots"));
        }
        return Self;
    }

    @NotNull
    public final Self withTraversal(TreeTraversal type) {
        Self Self = this.newInstance(this.meta.withTraversal(type));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "withTraversal"));
        }
        return Self;
    }

    @NotNull
    public final Self expand(@NotNull Condition<? super T> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/FilteredTraverserBase", "expand"));
        }
        Self Self = this.newInstance(this.meta.expand(c));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "expand"));
        }
        return Self;
    }

    @NotNull
    public final Self regard(@NotNull Condition<? super T> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/FilteredTraverserBase", "regard"));
        }
        Self Self = this.newInstance(this.meta.regard(c));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "regard"));
        }
        return Self;
    }

    @NotNull
    public final Self expandAndFilter(Condition<? super T> c) {
        Self Self = this.newInstance(this.meta.expand(c).filter(c));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "expandAndFilter"));
        }
        return Self;
    }

    @NotNull
    public final Self expandAndSkip(Condition<? super T> c) {
        Self Self = this.newInstance(this.meta.expand(c).filter(Conditions.not(c)));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "expandAndSkip"));
        }
        return Self;
    }

    @NotNull
    public final Self filter(@NotNull Condition<? super T> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/FilteredTraverserBase", "filter"));
        }
        Self Self = this.newInstance(this.meta.filter(c));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "filter"));
        }
        return Self;
    }

    @NotNull
    public final <C> JBIterable<C> filter(@NotNull Class<C> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/containers/FilteredTraverserBase", "filter"));
        }
        JBIterable<C> jBIterable = this.traverse().filter(type);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "filter"));
        }
        return jBIterable;
    }

    @NotNull
    public final Self unique() {
        Self Self = this.withTraversal(this.meta.traversal.unique());
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "unique"));
        }
        return Self;
    }

    @NotNull
    public final Self unique(@NotNull Function<T, Object> identity) {
        if (identity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identity", "com/intellij/util/containers/FilteredTraverserBase", "unique"));
        }
        Self Self = this.withTraversal(this.meta.traversal.unique(identity));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "unique"));
        }
        return Self;
    }

    @NotNull
    public final Self forceIgnore(@NotNull Condition<? super T> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/FilteredTraverserBase", "forceIgnore"));
        }
        Self Self = this.newInstance(this.meta.forceIgnore(c));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "forceIgnore"));
        }
        return Self;
    }

    @NotNull
    public final Self forceDisregard(@NotNull Condition<? super T> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/FilteredTraverserBase", "forceDisregard"));
        }
        Self Self = this.newInstance(this.meta.forceDisregard(c));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "forceDisregard"));
        }
        return Self;
    }

    @NotNull
    public final JBIterable<T> children(@Nullable T node) {
        if (node == null || this.isAlwaysLeaf(node)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "children"));
            }
            return jBIterable;
        }
        if (this.meta.regard.next == null && this.meta.forceDisregard.next == null) {
            JBIterable jBIterable = JBIterable.from(this.tree.fun(node)).filter(Conditions.not(this.meta.forceIgnore.OR));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "children"));
            }
            return jBIterable;
        }
        JBIterable<T> jBIterable = TreeTraversal.GUIDED_TRAVERSAL(this.meta.createChildrenGuide(node)).traversal(node, this.tree);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "children"));
        }
        return jBIterable;
    }

    protected boolean isAlwaysLeaf(@NotNull T node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/containers/FilteredTraverserBase", "isAlwaysLeaf"));
        }
        return !this.meta.expand.valueAnd(node);
    }

    @NotNull
    public final List<T> toList() {
        List<T> list = this.traverse().toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "toList"));
        }
        return list;
    }

    @NotNull
    public final Set<T> toSet() {
        Set<T> set = this.traverse().toSet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "toSet"));
        }
        return set;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{traversal=" + this.meta.traversal + '}';
    }

    private static class Cond<T> {
        static final Cond TRUE = new Cond<Object>(Conditions.TRUE, null);
        static final Cond FALSE = new Cond<Object>(Conditions.FALSE, null);
        final Condition<? super T> impl;
        final Cond<T> next;
        final Condition<? super T> OR = new Condition<T>(){

            @Override
            public boolean value(T t) {
                return Cond.this.valueOr(t);
            }
        };
        final Condition<? super T> AND = new Condition<T>(){

            @Override
            public boolean value(T t) {
                return Cond.this.valueAnd(t);
            }
        };

        Cond(Condition<? super T> impl, Cond<T> next) {
            this.impl = impl;
            this.next = next;
        }

        Cond<T> append(Condition<? super T> impl) {
            return new Cond<T>(impl, this);
        }

        boolean valueAnd(T t) {
            Cond<T> c = this;
            while (c != null) {
                if (!c.impl.value(t)) {
                    return false;
                }
                c = c.next;
            }
            return true;
        }

        boolean valueOr(T t) {
            Cond<T> c = this;
            while (c != null) {
                if (c.impl.value(t)) {
                    return true;
                }
                c = c.next;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Cond{");
            Cond<T> c = this;
            while (c != null) {
                sb.append(JBIterator.toShortString(c.impl));
                if (c.next != null) {
                    sb.append(", ");
                }
                c = c.next;
            }
            return sb.append("}").toString();
        }
    }

    protected static class Meta<T> {
        final Iterable<? extends T> roots;
        final TreeTraversal traversal;
        final Cond<T> expand;
        final Cond<T> regard;
        final Cond<T> filter;
        final Cond<T> forceIgnore;
        final Cond<T> forceDisregard;
        private static final Meta<?> EMPTY = new Meta(JBIterable.empty(), TreeTraversal.PRE_ORDER_DFS, Cond.TRUE, Cond.TRUE, Cond.TRUE, Cond.FALSE, Cond.FALSE);

        public Meta(@NotNull Iterable<? extends T> roots, @NotNull TreeTraversal traversal, @NotNull Cond<T> expand, @NotNull Cond<T> regard, @NotNull Cond<T> filter, @NotNull Cond<T> forceIgnore, @NotNull Cond<T> forceDisregard) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            if (traversal == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traversal", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            if (expand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expand", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            if (regard == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regard", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            if (forceIgnore == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forceIgnore", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            if (forceDisregard == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forceDisregard", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            this.roots = roots;
            this.traversal = traversal;
            this.expand = expand;
            this.regard = regard;
            this.filter = filter;
            this.forceIgnore = forceIgnore;
            this.forceDisregard = forceDisregard;
        }

        public Meta<T> reset() {
            return new Meta<T>(this.roots, TreeTraversal.PRE_ORDER_DFS, Cond.TRUE, Cond.TRUE, Cond.TRUE, this.forceIgnore, this.forceDisregard);
        }

        public Meta<T> withRoots(@NotNull Iterable<? extends T> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/FilteredTraverserBase$Meta", "withRoots"));
            }
            return new Meta<T>(roots, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard);
        }

        public Meta<T> withTraversal(TreeTraversal traversal) {
            return new Meta<T>(this.roots, traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard);
        }

        public Meta<T> expand(@NotNull Condition<? super T> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/FilteredTraverserBase$Meta", "expand"));
            }
            return new Meta<T>(this.roots, this.traversal, this.expand.append(c), this.regard, this.filter, this.forceIgnore, this.forceDisregard);
        }

        public Meta<T> regard(@NotNull Condition<? super T> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/FilteredTraverserBase$Meta", "regard"));
            }
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard.append(c), this.filter, this.forceIgnore, this.forceDisregard);
        }

        public Meta<T> filter(@NotNull Condition<? super T> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/FilteredTraverserBase$Meta", "filter"));
            }
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter.append(c), this.forceIgnore, this.forceDisregard);
        }

        public Meta<T> forceIgnore(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore.append(c), this.forceDisregard);
        }

        public Meta<T> forceDisregard(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard.append(c));
        }

        TreeTraversal.GuidedIt.Guide<T> createChildrenGuide(final T parent) {
            return new TreeTraversal.GuidedIt.Guide<T>(){
                final Condition<? super T> expand;
                {
                    this.expand = Meta.this.buildExpandConditionForChildren(parent);
                }

                @Override
                public void guide(@NotNull TreeTraversal.GuidedIt<T> guidedIt) {
                    if (guidedIt == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guidedIt", "com/intellij/util/containers/FilteredTraverserBase$Meta$1", "guide"));
                    }
                    Meta.this.doPerformChildrenGuidance(guidedIt, this.expand);
                }
            };
        }

        private void doPerformChildrenGuidance(TreeTraversal.GuidedIt<T> it, Condition<? super T> expand) {
            if (it.curChild == null) {
                return;
            }
            if (this.forceIgnore.valueOr(it.curChild)) {
                return;
            }
            if (it.curParent == null || expand.value(it.curChild)) {
                it.queueNext(it.curChild);
            } else {
                it.result(it.curChild);
            }
        }

        private Condition<? super T> buildExpandConditionForChildren(T parent) {
            Cond copy = null;
            boolean invert = true;
            Cond<T> c = this.regard;
            while (c != null) {
                Condition impl = JBIterable.Stateful.copy(c.impl);
                if (impl != (invert ? Condition.TRUE : Condition.FALSE)) {
                    copy = new Cond(invert ? Conditions.not(impl) : impl, copy);
                    if (impl instanceof EdgeFilter) {
                        ((EdgeFilter)impl).edgeSource = parent;
                    }
                }
                if (c.next == null) {
                    c = invert ? this.forceDisregard : null;
                    invert = false;
                    continue;
                }
                c = c.next;
            }
            return copy == null ? Condition.FALSE : copy.OR;
        }

        public static <T> Meta<T> empty() {
            return EMPTY;
        }
    }

    public static abstract class EdgeFilter<T>
    extends JBIterable.StatefulFilter<T> {
        protected T edgeSource;
    }
}

