/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;

@State(name="TaskProjectConfiguration")
public class TaskProjectConfiguration
implements PersistentStateComponent<TaskProjectConfiguration> {
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="server")
    public List<SharedServer> servers = new ArrayList<SharedServer>();
    private final TaskManagerImpl myManager;

    public TaskProjectConfiguration() {
        this.myManager = null;
    }

    public TaskProjectConfiguration(TaskManagerImpl manager) {
        this.myManager = manager;
    }

    public TaskProjectConfiguration getState() {
        this.servers.clear();
        for (TaskRepository repository : this.myManager.getAllRepositories()) {
            if (!repository.isShared()) continue;
            SharedServer server = new SharedServer();
            server.type = repository.getRepositoryType().getName();
            server.url = repository.getUrl();
            this.servers.add(server);
        }
        return this;
    }

    public void loadState(TaskProjectConfiguration state) {
        this.servers.clear();
        for (SharedServer server : state.servers) {
            if (server.url == null || server.type == null) continue;
            this.servers.add(server);
        }
    }

    @Tag(value="server")
    public static class SharedServer {
        @Attribute(value="type")
        public String type;
        @Attribute(value="url")
        public String url;
    }
}

