/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class MapSubject
extends Subject<MapSubject, Map<?, ?>> {
    MapSubject(FailureStrategy failureStrategy, @Nullable Map<?, ?> map) {
        super(failureStrategy, map);
    }

    @Override
    public void isEqualTo(@Nullable Object other) {
        if (!Objects.equal(this.getSubject(), (Object)other)) {
            if (other instanceof Map) {
                String string;
                String string2;
                MapDifference diff = Maps.difference((Map)((Map)other), (Map)((Map)this.getSubject()));
                String errorMsg = "The subject";
                if (!diff.entriesOnlyOnLeft().isEmpty()) {
                    string2 = String.valueOf(errorMsg);
                    string = String.valueOf(diff.entriesOnlyOnLeft());
                    errorMsg = new StringBuilder(35 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" is missing the following entries: ").append(string).toString();
                    if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                        errorMsg = String.valueOf(errorMsg).concat(" and");
                    }
                }
                if (!diff.entriesOnlyOnRight().isEmpty()) {
                    string2 = String.valueOf(errorMsg);
                    string = String.valueOf(diff.entriesOnlyOnRight());
                    errorMsg = new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" has the following extra entries: ").append(string).toString();
                    if (!diff.entriesDiffering().isEmpty()) {
                        errorMsg = String.valueOf(errorMsg).concat(" and");
                    }
                }
                if (!diff.entriesDiffering().isEmpty()) {
                    string2 = String.valueOf(errorMsg);
                    string = String.valueOf(diff.entriesDiffering());
                    errorMsg = new StringBuilder(38 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" has the following different entries: ").append(string).toString();
                }
                String string3 = String.valueOf(errorMsg);
                this.failWithRawMessage(string3.length() != 0 ? "Not true that %s is equal to <%s>. ".concat(string3) : new String("Not true that %s is equal to <%s>. "), this.getDisplaySubject(), other);
            } else {
                this.fail("is equal to", other);
            }
        }
    }

    public void isEmpty() {
        if (!((Map)this.getSubject()).isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (((Map)this.getSubject()).isEmpty()) {
            this.fail("is not empty");
        }
    }

    public void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize (%s) must be >= 0", (Object[])new Object[]{expectedSize});
        int actualSize = ((Map)this.getSubject()).size();
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public void containsKey(@Nullable Object key) {
        if (!((Map)this.getSubject()).containsKey(key)) {
            this.fail("contains key", key);
        }
    }

    public void doesNotContainKey(@Nullable Object key) {
        if (((Map)this.getSubject()).containsKey(key)) {
            this.fail("does not contain key", key);
        }
    }

    public void containsEntry(@Nullable Object key, @Nullable Object value) {
        Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
        if (!((Map)this.getSubject()).entrySet().contains(entry)) {
            this.fail("contains entry", (Object)entry);
        }
    }

    public void doesNotContainEntry(@Nullable Object key, @Nullable Object value) {
        Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
        if (((Map)this.getSubject()).entrySet().contains(entry)) {
            this.fail("does not contain entry", (Object)entry);
        }
    }

    public Ordered containsExactly() {
        return this.check().that(((Map)this.getSubject()).entrySet()).containsExactly(new Object[0]);
    }

    public Ordered containsExactly(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        Preconditions.checkArgument((rest.length % 2 == 0 ? 1 : 0) != 0, (String)"There must be an equal number of key/value pairs (i.e., the number of key/value parameters (%s) must be even).", (Object[])new Object[]{rest.length + 2});
        LinkedHashMap expectedMap = Maps.newLinkedHashMap();
        expectedMap.put(k0, v0);
        LinkedHashMultiset keys = LinkedHashMultiset.create();
        keys.add(k0);
        for (int i = 0; i < rest.length; i += 2) {
            Object key = rest[i];
            expectedMap.put(key, rest[i + 1]);
            keys.add(key);
        }
        Preconditions.checkArgument((keys.size() == expectedMap.size() ? 1 : 0) != 0, (String)"Duplicate keys (%s) cannot be passed to containsExactly().", (Object[])new Object[]{keys});
        return this.containsExactlyEntriesIn(expectedMap);
    }

    public Ordered containsExactlyEntriesIn(Map<?, ?> expectedMap) {
        return this.check().that(((Map)this.getSubject()).entrySet()).containsExactlyElementsIn(expectedMap.entrySet());
    }
}

