/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;

public class GradleConfigurationsContributor
implements GradleMethodContextContributor {
    private static final String CONFIGURATIONS = "configurations";

    @Override
    public void process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (methodCallInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallInfo", "org/jetbrains/plugins/gradle/service/resolve/GradleConfigurationsContributor", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleConfigurationsContributor", "process"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleConfigurationsContributor", "process"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleConfigurationsContributor", "process"));
        }
        if (methodCallInfo.isEmpty()) {
            return;
        }
        String methodCall = methodCallInfo.get(0);
        String contributorClass = null;
        if (methodCallInfo.size() == 1) {
            if (methodCall.startsWith("configurations.")) {
                contributorClass = "org.gradle.api.artifacts.Configuration";
            } else if (CONFIGURATIONS.equals(methodCall)) {
                contributorClass = "org.gradle.api.artifacts.ConfigurationContainer";
                if (place instanceof GrReferenceExpressionImpl) {
                    GradleResolverUtil.addImplicitVariable(processor, state, (GrReferenceExpressionImpl)place, "org.gradle.api.artifacts.Configuration");
                    return;
                }
            }
        } else if (methodCallInfo.size() == 2 && CONFIGURATIONS.equals(methodCallInfo.get(1))) {
            contributorClass = "org.gradle.api.artifacts.ConfigurationContainer";
            if (place instanceof GrReferenceExpressionImpl) {
                GradleResolverUtil.addImplicitVariable(processor, state, (GrReferenceExpressionImpl)place, "org.gradle.api.artifacts.Configuration");
                return;
            }
        }
        if (contributorClass != null) {
            GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
            GradleResolverUtil.processDeclarations(psiManager, processor, state, place, contributorClass);
        }
    }
}

