/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.settings.LocationSettingType;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemSettingsControlCustomizer;
import com.intellij.openapi.externalSystem.service.ui.ExternalSystemJdkComboBox;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControlBuilder;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class IdeaGradleProjectSettingsControlBuilder
implements GradleProjectSettingsControlBuilder {
    private static final long BALLOON_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    @NotNull
    private final GradleInstallationManager myInstallationManager;
    @NotNull
    private final GradleProjectSettings myInitialSettings;
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private LocationSettingType myGradleHomeSettingType;
    private boolean myShowBalloonIfNecessary;
    private ActionListener myActionListener;
    private boolean dropUseAutoImportBox;
    private boolean dropCreateEmptyContentRootDirectoriesBox;
    @Nullable
    private JLabel myGradleHomeLabel;
    @Nullable
    private TextFieldWithBrowseButton myGradleHomePathField;
    private boolean dropGradleHomePathComponents;
    @Nullable
    private JLabel myGradleJdkLabel;
    @Nullable
    private ExternalSystemJdkComboBox myGradleJdkComboBox;
    private boolean dropGradleJdkComponents;
    @Nullable
    private JBRadioButton myUseWrapperButton;
    private boolean dropUseWrapperButton;
    @Nullable
    private JBRadioButton myUseWrapperWithVerificationButton;
    @Nullable
    private JBLabel myUseWrapperVerificationLabel;
    private boolean dropCustomizableWrapperButton;
    @Nullable
    private JBRadioButton myUseLocalDistributionButton;
    private boolean dropUseLocalDistributionButton;
    @Nullable
    private JBRadioButton myUseBundledDistributionButton;
    private boolean dropUseBundledDistributionButton;
    @Nullable
    private JBCheckBox myResolveModulePerSourceSetCheckBox;
    private boolean dropResolveModulePerSourceSetCheckBox;

    public IdeaGradleProjectSettingsControlBuilder(@NotNull GradleProjectSettings initialSettings) {
        if (initialSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSettings", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder", "<init>"));
        }
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myGradleHomeSettingType = LocationSettingType.UNKNOWN;
        this.myInstallationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
        this.myInitialSettings = initialSettings;
        this.myActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField == null) {
                    return;
                }
                boolean localDistributionEnabled = IdeaGradleProjectSettingsControlBuilder.this.myUseLocalDistributionButton != null && IdeaGradleProjectSettingsControlBuilder.this.myUseLocalDistributionButton.isSelected();
                IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.setEnabled(localDistributionEnabled);
                if (localDistributionEnabled) {
                    if (IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.getText().isEmpty()) {
                        IdeaGradleProjectSettingsControlBuilder.this.deduceGradleHomeIfPossible();
                    } else if (IdeaGradleProjectSettingsControlBuilder.this.myInstallationManager.isGradleSdkHome(IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.getText())) {
                        IdeaGradleProjectSettingsControlBuilder.this.myGradleHomeSettingType = LocationSettingType.EXPLICIT_CORRECT;
                    } else {
                        IdeaGradleProjectSettingsControlBuilder.this.myGradleHomeSettingType = LocationSettingType.EXPLICIT_INCORRECT;
                        IdeaGradleProjectSettingsControlBuilder.this.myShowBalloonIfNecessary = true;
                    }
                    IdeaGradleProjectSettingsControlBuilder.this.showBalloonIfNecessary();
                } else {
                    IdeaGradleProjectSettingsControlBuilder.this.myAlarm.cancelAllRequests();
                }
            }
        };
    }

    public IdeaGradleProjectSettingsControlBuilder dropGradleJdkComponents() {
        this.dropGradleJdkComponents = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseWrapperButton() {
        this.dropUseWrapperButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropGradleHomePathComponents() {
        this.dropGradleHomePathComponents = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropCustomizableWrapperButton() {
        this.dropCustomizableWrapperButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseLocalDistributionButton() {
        this.dropUseLocalDistributionButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseBundledDistributionButton() {
        this.dropUseBundledDistributionButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseAutoImportBox() {
        this.dropUseAutoImportBox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropCreateEmptyContentRootDirectoriesBox() {
        this.dropCreateEmptyContentRootDirectoriesBox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropResolveModulePerSourceSetCheckBox() {
        this.dropResolveModulePerSourceSetCheckBox = true;
        return this;
    }

    @Override
    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi((Object)this, (boolean)show);
    }

    @Override
    @NotNull
    public GradleProjectSettings getInitialSettings() {
        GradleProjectSettings gradleProjectSettings = this.myInitialSettings;
        if (gradleProjectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder", "getInitialSettings"));
        }
        return gradleProjectSettings;
    }

    @Override
    public ExternalSystemSettingsControlCustomizer getExternalSystemSettingsControlCustomizer() {
        return new ExternalSystemSettingsControlCustomizer(this.dropUseAutoImportBox, this.dropCreateEmptyContentRootDirectoriesBox);
    }

    @Override
    public void createAndFillControls(PaintAwarePanel content, int indentLevel) {
        content.setPaintCallback(graphics -> this.showBalloonIfNecessary());
        content.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!"ancestor".equals(evt.getPropertyName())) {
                    return;
                }
                IdeaGradleProjectSettingsControlBuilder.this.myShowBalloonIfNecessary = evt.getNewValue() != null && evt.getOldValue() == null;
                if (evt.getNewValue() == null && evt.getOldValue() != null) {
                    IdeaGradleProjectSettingsControlBuilder.this.myAlarm.cancelAllRequests();
                }
            }
        });
        if (!this.dropResolveModulePerSourceSetCheckBox) {
            this.myResolveModulePerSourceSetCheckBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.create.module.per.sourceset", new Object[0]));
            content.add((Component)this.myResolveModulePerSourceSetCheckBox, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
        this.addGradleChooserComponents(content, indentLevel);
        this.addGradleHomeComponents(content, indentLevel);
        this.addGradleJdkComponents(content, indentLevel);
    }

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi((Object)this);
    }

    private void deduceGradleHomeIfPossible() {
        if (this.myGradleHomePathField == null) {
            return;
        }
        File gradleHome = this.myInstallationManager.getAutodetectedGradleHome();
        if (gradleHome == null) {
            new DelayedBalloonInfo(MessageType.WARNING, LocationSettingType.UNKNOWN, BALLOON_DELAY_MILLIS).run();
            return;
        }
        this.myGradleHomeSettingType = LocationSettingType.DEDUCED;
        new DelayedBalloonInfo(MessageType.INFO, LocationSettingType.DEDUCED, BALLOON_DELAY_MILLIS).run();
        this.myGradleHomePathField.setText(gradleHome.getPath());
        this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.DEDUCED.getColor());
    }

    @Override
    public IdeaGradleProjectSettingsControlBuilder addGradleJdkComponents(PaintAwarePanel content, int indentLevel) {
        if (!this.dropGradleJdkComponents) {
            this.myGradleJdkLabel = new JBLabel(GradleBundle.message("gradle.settings.text.jvm.path", new Object[0]));
            this.myGradleJdkComboBox = new ExternalSystemJdkComboBox().withoutJre();
            content.add((Component)this.myGradleJdkLabel, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
            content.add((Component)this.myGradleJdkComboBox, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)0));
        }
        return this;
    }

    @Override
    public IdeaGradleProjectSettingsControlBuilder addGradleChooserComponents(PaintAwarePanel content, int indentLevel) {
        ButtonGroup buttonGroup = new ButtonGroup();
        if (!this.dropUseWrapperButton) {
            this.myUseWrapperButton = new JBRadioButton(GradleBundle.message("gradle.settings.text.use.default_wrapper.configured", new Object[0]));
            this.myUseWrapperButton.addActionListener(this.myActionListener);
            buttonGroup.add((AbstractButton)this.myUseWrapperButton);
            content.add((Component)this.myUseWrapperButton, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
        if (!this.dropCustomizableWrapperButton) {
            this.myUseWrapperWithVerificationButton = new JBRadioButton(GradleBundle.message("gradle.settings.text.use.customizable_wrapper", new Object[0]));
            this.myUseWrapperWithVerificationButton.addActionListener(this.myActionListener);
            this.myUseWrapperVerificationLabel = new JBLabel(GradleBundle.message("gradle.settings.text.wrapper.customization.compatibility", new Object[0]));
            this.myUseWrapperVerificationLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI));
            this.myUseWrapperVerificationLabel.setIcon(UIUtil.getBalloonInformationIcon());
            buttonGroup.add((AbstractButton)this.myUseWrapperWithVerificationButton);
            content.add((Component)this.myUseWrapperWithVerificationButton, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
            content.add((Component)this.myUseWrapperVerificationLabel, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
        if (!this.dropUseLocalDistributionButton) {
            this.myUseLocalDistributionButton = new JBRadioButton(GradleBundle.message("gradle.settings.text.use.local.distribution", new Object[0]));
            this.myUseLocalDistributionButton.addActionListener(this.myActionListener);
            buttonGroup.add((AbstractButton)this.myUseLocalDistributionButton);
            content.add((Component)this.myUseLocalDistributionButton, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
        if (!this.dropUseBundledDistributionButton) {
            this.myUseBundledDistributionButton = new JBRadioButton(GradleBundle.message("gradle.settings.text.use.bundled.distribution", GradleVersion.current().getVersion()));
            this.myUseBundledDistributionButton.addActionListener(this.myActionListener);
            buttonGroup.add((AbstractButton)this.myUseBundledDistributionButton);
            content.add((Component)this.myUseBundledDistributionButton, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
        return this;
    }

    @Override
    public boolean validate(GradleProjectSettings settings) throws ConfigurationException {
        if (this.myGradleHomePathField == null) {
            return true;
        }
        String gradleHomePath = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
        if (this.myUseLocalDistributionButton != null && this.myUseLocalDistributionButton.isSelected()) {
            if (StringUtil.isEmpty((String)gradleHomePath)) {
                this.myGradleHomeSettingType = LocationSettingType.UNKNOWN;
                throw new ConfigurationException(GradleBundle.message("gradle.home.setting.type.explicit.empty", gradleHomePath));
            }
            if (!this.myInstallationManager.isGradleSdkHome(new File(gradleHomePath))) {
                this.myGradleHomeSettingType = LocationSettingType.EXPLICIT_INCORRECT;
                new DelayedBalloonInfo(MessageType.ERROR, this.myGradleHomeSettingType, 0L).run();
                throw new ConfigurationException(GradleBundle.message("gradle.home.setting.type.explicit.incorrect", gradleHomePath));
            }
        }
        return true;
    }

    @Override
    public void apply(GradleProjectSettings settings) {
        if (this.myGradleHomePathField != null) {
            String gradleHomePath = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
            if (StringUtil.isEmpty((String)gradleHomePath)) {
                settings.setGradleHome(null);
            } else {
                settings.setGradleHome(gradleHomePath);
                GradleUtil.storeLastUsedGradleHome(gradleHomePath);
            }
        }
        if (this.myGradleJdkComboBox != null) {
            String gradleJvm = FileUtil.toCanonicalPath((String)this.myGradleJdkComboBox.getSelectedValue());
            settings.setGradleJvm(StringUtil.isEmpty((String)gradleJvm) ? null : gradleJvm);
        }
        if (this.myResolveModulePerSourceSetCheckBox != null) {
            settings.setResolveModulePerSourceSet(this.myResolveModulePerSourceSetCheckBox.isSelected());
        }
        if (this.myUseLocalDistributionButton != null && this.myUseLocalDistributionButton.isSelected()) {
            settings.setDistributionType(DistributionType.LOCAL);
        } else if (this.myUseWrapperButton != null && this.myUseWrapperButton.isSelected()) {
            settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        } else if (this.myUseWrapperWithVerificationButton != null && this.myUseWrapperWithVerificationButton.isSelected() || this.myUseBundledDistributionButton != null && this.myUseBundledDistributionButton.isSelected()) {
            settings.setDistributionType(DistributionType.WRAPPED);
        }
    }

    @Override
    public boolean isModified() {
        DistributionType distributionType = this.myInitialSettings.getDistributionType();
        if (this.myUseBundledDistributionButton != null && this.myUseBundledDistributionButton.isSelected() && distributionType != DistributionType.BUNDLED) {
            return true;
        }
        if (this.myUseWrapperButton != null && this.myUseWrapperButton.isSelected() && distributionType != DistributionType.DEFAULT_WRAPPED) {
            return true;
        }
        if (this.myUseWrapperWithVerificationButton != null && this.myUseWrapperWithVerificationButton.isSelected() && distributionType != DistributionType.WRAPPED) {
            return true;
        }
        if (this.myUseLocalDistributionButton != null && this.myUseLocalDistributionButton.isSelected() && distributionType != DistributionType.LOCAL) {
            return true;
        }
        if (this.myResolveModulePerSourceSetCheckBox != null && this.myResolveModulePerSourceSetCheckBox.isSelected() != this.myInitialSettings.isResolveModulePerSourceSet()) {
            return true;
        }
        if (this.myGradleJdkComboBox != null && !StringUtil.equals((CharSequence)this.myGradleJdkComboBox.getSelectedValue(), (CharSequence)this.myInitialSettings.getGradleJvm())) {
            return true;
        }
        if (this.myGradleHomePathField == null) {
            return false;
        }
        String gradleHome = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
        if (StringUtil.isEmpty((String)gradleHome)) {
            return !StringUtil.isEmpty((String)this.myInitialSettings.getGradleHome());
        }
        return !gradleHome.equals(this.myInitialSettings.getGradleHome());
    }

    @Override
    public void reset(Project project, GradleProjectSettings settings, boolean isDefaultModuleCreation) {
        String gradleHome = settings.getGradleHome();
        if (this.myGradleHomePathField != null) {
            this.myGradleHomePathField.setText(gradleHome == null ? "" : gradleHome);
            this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
        }
        if (this.myResolveModulePerSourceSetCheckBox != null) {
            this.myResolveModulePerSourceSetCheckBox.setSelected(settings.isResolveModulePerSourceSet());
        }
        this.resetGradleJdkComboBox(project, settings);
        this.resetWrapperControls(settings.getExternalProjectPath(), settings, isDefaultModuleCreation);
        if (this.myUseLocalDistributionButton != null && !this.myUseLocalDistributionButton.isSelected()) {
            this.myGradleHomePathField.setEnabled(false);
            return;
        }
        if (StringUtil.isEmpty((String)gradleHome)) {
            this.myGradleHomeSettingType = LocationSettingType.UNKNOWN;
            this.deduceGradleHomeIfPossible();
        } else {
            this.myGradleHomeSettingType = this.myInstallationManager.isGradleSdkHome(new File(gradleHome)) ? LocationSettingType.EXPLICIT_CORRECT : LocationSettingType.EXPLICIT_INCORRECT;
            this.myAlarm.cancelAllRequests();
            if (this.myGradleHomeSettingType == LocationSettingType.EXPLICIT_INCORRECT && settings.getDistributionType() == DistributionType.LOCAL) {
                new DelayedBalloonInfo(MessageType.ERROR, this.myGradleHomeSettingType, 0L).run();
            }
        }
    }

    @Override
    public void update(String linkedProjectPath, GradleProjectSettings settings, boolean isDefaultModuleCreation) {
        this.resetWrapperControls(linkedProjectPath, settings, isDefaultModuleCreation);
        if (this.myResolveModulePerSourceSetCheckBox != null) {
            this.myResolveModulePerSourceSetCheckBox.setSelected(settings.isResolveModulePerSourceSet());
        }
    }

    @Override
    public IdeaGradleProjectSettingsControlBuilder addGradleHomeComponents(PaintAwarePanel content, int indentLevel) {
        if (this.dropGradleHomePathComponents) {
            return this;
        }
        this.myGradleHomeLabel = new JBLabel(GradleBundle.message("gradle.settings.text.home.path", new Object[0]));
        this.myGradleHomePathField = new TextFieldWithBrowseButton();
        this.myGradleHomePathField.addBrowseFolderListener("", GradleBundle.message("gradle.settings.text.home.path", new Object[0]), null, GradleUtil.getGradleHomeFileChooserDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT, false);
        this.myGradleHomePathField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        content.add((Component)this.myGradleHomeLabel, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
        content.add((Component)this.myGradleHomePathField, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)0));
        return this;
    }

    private void resetGradleJdkComboBox(@Nullable Project project, GradleProjectSettings settings) {
        if (this.myGradleJdkComboBox == null) {
            return;
        }
        String gradleJvm = settings.getGradleJvm();
        this.myGradleJdkComboBox.setProject(project);
        String sdkItem = (String)ObjectUtils.nullizeByCondition((Object)gradleJvm, s -> project == null && StringUtil.equals((CharSequence)"#USE_PROJECT_JDK", (CharSequence)s) || StringUtil.isEmpty((String)s));
        this.myGradleJdkComboBox.refreshData(sdkItem);
    }

    private void resetWrapperControls(String linkedProjectPath, @NotNull GradleProjectSettings settings, boolean isDefaultModuleCreation) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder", "resetWrapperControls"));
        }
        if (StringUtil.isEmpty((String)linkedProjectPath) && !isDefaultModuleCreation) {
            if (this.myUseLocalDistributionButton != null) {
                this.myUseLocalDistributionButton.setSelected(true);
            }
            if (this.myGradleHomePathField != null) {
                this.myGradleHomePathField.setEnabled(true);
            }
            return;
        }
        boolean isGradleDefaultWrapperFilesExist = GradleUtil.isGradleDefaultWrapperFilesExist(linkedProjectPath);
        if (this.myUseWrapperButton != null && (isGradleDefaultWrapperFilesExist || isDefaultModuleCreation)) {
            this.myUseWrapperButton.setEnabled(true);
            this.myUseWrapperButton.setSelected(true);
            if (this.myGradleHomePathField != null) {
                this.myGradleHomePathField.setEnabled(false);
            }
            this.myUseWrapperButton.setText(GradleBundle.message("gradle.settings.text.use.default_wrapper.configured", new Object[0]));
        } else {
            if (this.myUseWrapperButton != null) {
                this.myUseWrapperButton.setEnabled(false);
                this.myUseWrapperButton.setText(GradleBundle.message("gradle.settings.text.use.default_wrapper.not_configured", new Object[0]));
            }
            if (this.myUseLocalDistributionButton != null) {
                this.myUseLocalDistributionButton.setSelected(true);
            }
            if (this.myGradleHomePathField != null) {
                this.myGradleHomePathField.setEnabled(true);
            }
        }
        if (settings.getDistributionType() == null) {
            return;
        }
        switch (settings.getDistributionType()) {
            case LOCAL: {
                if (this.myGradleHomePathField != null) {
                    this.myGradleHomePathField.setEnabled(true);
                }
                if (this.myUseLocalDistributionButton == null) break;
                this.myUseLocalDistributionButton.setSelected(true);
                break;
            }
            case DEFAULT_WRAPPED: {
                if (!isGradleDefaultWrapperFilesExist) break;
                if (this.myGradleHomePathField != null) {
                    this.myGradleHomePathField.setEnabled(false);
                }
                if (this.myUseWrapperButton == null) break;
                this.myUseWrapperButton.setSelected(true);
                this.myUseWrapperButton.setEnabled(true);
                break;
            }
            case WRAPPED: {
                if (this.myGradleHomePathField != null) {
                    this.myGradleHomePathField.setEnabled(false);
                }
                if (this.myUseWrapperWithVerificationButton == null) break;
                this.myUseWrapperWithVerificationButton.setSelected(true);
                break;
            }
            case BUNDLED: {
                if (this.myGradleHomePathField != null) {
                    this.myGradleHomePathField.setEnabled(false);
                }
                if (this.myUseBundledDistributionButton == null) break;
                this.myUseBundledDistributionButton.setSelected(true);
            }
        }
    }

    void showBalloonIfNecessary() {
        if (!this.myShowBalloonIfNecessary || this.myGradleHomePathField != null && !this.myGradleHomePathField.isEnabled()) {
            return;
        }
        this.myShowBalloonIfNecessary = false;
        MessageType messageType = null;
        switch (this.myGradleHomeSettingType) {
            case DEDUCED: {
                messageType = MessageType.INFO;
                break;
            }
            case EXPLICIT_INCORRECT: 
            case UNKNOWN: {
                messageType = MessageType.ERROR;
                break;
            }
        }
        if (messageType != null) {
            new DelayedBalloonInfo(messageType, this.myGradleHomeSettingType, BALLOON_DELAY_MILLIS).run();
        }
    }

    private class DelayedBalloonInfo
    implements Runnable {
        private final MessageType myMessageType;
        private final String myText;
        private final long myTriggerTime;

        DelayedBalloonInfo(@NotNull MessageType messageType, LocationSettingType settingType, long delayMillis) {
            if (messageType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageType", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$DelayedBalloonInfo", "<init>"));
            }
            if (settingType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingType", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$DelayedBalloonInfo", "<init>"));
            }
            this.myMessageType = messageType;
            this.myText = settingType.getDescription(GradleConstants.SYSTEM_ID);
            this.myTriggerTime = System.currentTimeMillis() + delayMillis;
        }

        @Override
        public void run() {
            long diff = this.myTriggerTime - System.currentTimeMillis();
            if (diff > 0L) {
                IdeaGradleProjectSettingsControlBuilder.this.myAlarm.cancelAllRequests();
                IdeaGradleProjectSettingsControlBuilder.this.myAlarm.addRequest((Runnable)this, diff);
                return;
            }
            if (IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField == null || !IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.isShowing()) {
                return;
            }
            ExternalSystemUiUtil.showBalloon((JComponent)IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField, (MessageType)this.myMessageType, (String)this.myText);
        }
    }
}

