/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.model;

import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.events.StateChangedEvent;
import com.intellij.execution.junit2.events.TestEvent;
import com.intellij.execution.junit2.ui.TestProgress;
import com.intellij.execution.junit2.ui.TestProxyClient;
import com.intellij.execution.junit2.ui.model.JUnitAdapter;
import com.intellij.execution.junit2.ui.model.JUnitListener;
import com.intellij.execution.junit2.ui.model.JUnitListenersNotifier;
import com.intellij.execution.junit2.ui.model.StateEvent;
import com.intellij.execution.junit2.ui.model.TestTreeBuilder;
import com.intellij.execution.junit2.ui.model.TestTreeStructure;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilder;
import com.intellij.execution.testframework.ui.TestsProgressAnimator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JUnitRunningModel
implements TestFrameworkRunningModel {
    private final TestProgress myProgress;
    private final TestProxy myRoot;
    private final JUnitConsoleProperties myProperties;
    private final MyTreeSelectionListener myTreeListener = new MyTreeSelectionListener();
    private JTree myTreeView;
    private TestTreeBuilder myTreeBuilder;
    private final JUnitListenersNotifier myNotifier = new JUnitListenersNotifier();
    private TestsProgressAnimator myAnimator;

    public JUnitRunningModel(TestProxy root, JUnitConsoleProperties properties) {
        this.myRoot = root;
        this.myProperties = properties;
        this.myRoot.setEventsConsumer(this.myNotifier);
        this.myProgress = new TestProgress(this);
        Disposer.register((Disposable)this, (Disposable)this.myProgress);
        Disposer.register((Disposable)this, (Disposable)this.myTreeListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                JUnitRunningModel.this.myNotifier.fireDisposed(JUnitRunningModel.this);
            }
        });
    }

    public TestTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    public void attachToTree(TestTreeView treeView) {
        this.myTreeBuilder = new TestTreeBuilder(treeView, this, this.myProperties);
        Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
        this.myAnimator = new TestsProgressAnimator((AbstractTestTreeBuilder)this.myTreeBuilder);
        this.addListener(new JUnitAdapter(){

            @Override
            public void onTestChanged(TestEvent event) {
                TestProxy test;
                if (event instanceof StateChangedEvent && (test = event.getSource()).isLeaf() && test.getState().getMagnitude() == 3) {
                    JUnitRunningModel.this.myAnimator.setCurrentTestCase((AbstractTestProxy)test);
                }
            }

            @Override
            public void onRunnerStateChanged(StateEvent event) {
                if (!event.isRunning()) {
                    JUnitRunningModel.this.myAnimator.stopMovie();
                }
            }

            @Override
            public void doDispose() {
                JUnitRunningModel.this.dispose();
            }
        });
        this.myTreeView = treeView;
        this.selectTest(this.getRoot());
        this.myTreeListener.install();
    }

    public JTree getTree() {
        return this.myTreeView;
    }

    public void dispose() {
    }

    public TestTreeView getTreeView() {
        return (TestTreeView)this.myTreeBuilder.getTree();
    }

    public boolean hasTestSuites() {
        return this.myRoot.hasChildSuites();
    }

    public TestProgress getProgress() {
        return this.myProgress;
    }

    public TestProxy getRoot() {
        return this.myRoot;
    }

    public void selectAndNotify(AbstractTestProxy testProxy) {
        this.selectTest((TestProxy)testProxy);
        this.myNotifier.fireTestSelected((TestProxy)testProxy);
    }

    public Project getProject() {
        return this.myProperties.getProject();
    }

    public JUnitConsoleProperties getProperties() {
        return this.myProperties;
    }

    public void selectTest(TestProxy test) {
        if (test == null) {
            return;
        }
        this.myTreeBuilder.select((Object)test, null);
    }

    public void expandTest(TestProxy test) {
        if (test == null) {
            return;
        }
        this.myTreeBuilder.expand((Object)test, null);
    }

    public void collapse(TestProxy test) {
        if (test == this.getRoot()) {
            return;
        }
        TreePath path = this.pathToTest(test, false);
        if (path == null) {
            return;
        }
        this.myTreeView.collapsePath(path);
    }

    public JUnitListenersNotifier getNotifier() {
        return this.myNotifier;
    }

    public void setFilter(Filter filter) {
        TestTreeStructure treeStructure = this.getStructure();
        treeStructure.setFilter(filter);
        this.myTreeBuilder.updateFromRoot();
    }

    public boolean isRunning() {
        return this.myRoot.isInProgress();
    }

    private TestTreeStructure getStructure() {
        return (TestTreeStructure)this.myTreeBuilder.getTreeStructure();
    }

    public void addListener(JUnitListener listener) {
        this.myNotifier.addListener(listener);
    }

    public void removeListener(JUnitListener listener) {
        this.myNotifier.removeListener(listener);
    }

    public void onUIBuilt() {
    }

    private TreePath pathToTest(TestProxy test, boolean expandIfCollapsed) {
        TestTreeBuilder treeBuilder = this.getTreeBuilder();
        DefaultMutableTreeNode node = treeBuilder.getNodeForElement((Object)test);
        if (node == null && !expandIfCollapsed) {
            return null;
        }
        node = treeBuilder.ensureTestVisible(test);
        if (node == null) {
            return null;
        }
        return TreeUtil.getPath((TreeNode)((TreeNode)this.myTreeView.getModel().getRoot()), (TreeNode)node);
    }

    public JUnitConfiguration getConfiguration() {
        return (JUnitConfiguration)this.myProperties.getConfiguration();
    }

    private class MyTreeSelectionListener
    extends FocusAdapter
    implements TreeSelectionListener,
    Disposable {
        private MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TestProxy test = TestProxyClient.from(e.getPath());
            JUnitRunningModel.this.myNotifier.fireTestSelected(test);
        }

        @Override
        public void focusGained(FocusEvent e) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!JUnitRunningModel.this.myTreeBuilder.isDisposed()) {
                    JUnitRunningModel.this.myNotifier.fireTestSelected((TestProxy)JUnitRunningModel.this.getTreeView().getSelectedTest());
                }
            });
        }

        public void install() {
            JUnitRunningModel.this.myTreeView.addTreeSelectionListener(this);
            JUnitRunningModel.this.myTreeView.addFocusListener(this);
        }

        public void dispose() {
            if (JUnitRunningModel.this.myTreeView != null) {
                JUnitRunningModel.this.myTreeView.removeTreeSelectionListener(this);
                JUnitRunningModel.this.myTreeView.removeFocusListener(this);
            }
        }
    }
}

