/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.FilterDescendantVirtualFileConvertible;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.StartedActivated;
import com.intellij.openapi.vcs.TransactionProvider;
import com.intellij.openapi.vcs.TreeDiffProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsExceptionsHotFixer;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.VcsRootSettings;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.VcsCacheableAnnotationProvider;
import com.intellij.openapi.vcs.changes.ChangeListEditHandler;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsAnnotationCachedProxy;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.VcsSynchronousProgressWrapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcs<ComList extends CommittedChangeList>
extends StartedActivated {
    private static final String USE_ANNOTATION_CACHE = "vcs.use.annotation.cache";
    @NonNls
    protected static final String ourIntegerPattern = "\\d+";
    @NotNull
    protected final Project myProject;
    private final String myName;
    private final VcsKey myKey;
    private VcsShowSettingOption myUpdateOption;
    private VcsShowSettingOption myStatusOption;
    private CheckinEnvironment myCheckinEnvironment;
    private UpdateEnvironment myUpdateEnvironment;
    private RollbackEnvironment myRollbackEnvironment;
    private static boolean ourUseAnnotationCache;

    public AbstractVcs(@NotNull Project project, String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/AbstractVcs", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.myName = name;
        this.myKey = new VcsKey(this.myName);
    }

    protected AbstractVcs(@NotNull Project project, String name, VcsKey key) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/AbstractVcs", "<init>"));
        }
        this.myProject = project;
        this.myName = name;
        this.myKey = key;
    }

    @Override
    protected void start() throws VcsException {
    }

    @Override
    protected void shutdown() throws VcsException {
    }

    @Override
    protected void activate() {
    }

    @Override
    protected void deactivate() {
    }

    @NonNls
    public final String getName() {
        return this.myName;
    }

    @NonNls
    public abstract String getDisplayName();

    public abstract Configurable getConfigurable();

    @Nullable
    public TransactionProvider getTransactionProvider() {
        return null;
    }

    @Nullable
    public ChangeProvider getChangeProvider() {
        return null;
    }

    public final VcsConfiguration getConfiguration() {
        return VcsConfiguration.getInstance(this.myProject);
    }

    @Nullable
    public EditFileProvider getEditFileProvider() {
        return null;
    }

    public void directoryMappingChanged() {
    }

    public boolean markExternalChangesAsUpToDate() {
        return false;
    }

    @Nullable
    protected CheckinEnvironment createCheckinEnvironment() {
        return null;
    }

    @Nullable
    public CheckinEnvironment getCheckinEnvironment() {
        return this.myCheckinEnvironment;
    }

    @Nullable
    protected RollbackEnvironment createRollbackEnvironment() {
        return null;
    }

    @Nullable
    public RollbackEnvironment getRollbackEnvironment() {
        return this.myRollbackEnvironment;
    }

    @Nullable
    public VcsHistoryProvider getVcsHistoryProvider() {
        return null;
    }

    @Nullable
    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return null;
    }

    public String getMenuItemText() {
        return this.getDisplayName();
    }

    @Nullable
    protected UpdateEnvironment createUpdateEnvironment() {
        return null;
    }

    @Nullable
    public UpdateEnvironment getUpdateEnvironment() {
        return this.myUpdateEnvironment;
    }

    public boolean fileIsUnderVcs(FilePath filePath2) {
        return true;
    }

    public boolean fileExistsInVcs(FilePath path2) {
        VirtualFile virtualFile = path2.getVirtualFile();
        if (virtualFile != null) {
            FileStatus fileStatus = FileStatusManager.getInstance(this.myProject).getStatus(virtualFile);
            return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED;
        }
        return true;
    }

    public void enableIntegration() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(this.myProject);
        if (vcsManager != null) {
            vcsManager.setDirectoryMappings(Arrays.asList(new VcsDirectoryMapping("", this.getName())));
        }
    }

    @NotNull
    public ThreeState mayRemoveChangeList(@NotNull LocalChangeList list, boolean explicitly) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/AbstractVcs", "mayRemoveChangeList"));
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/AbstractVcs", "mayRemoveChangeList"));
        }
        return threeState;
    }

    public boolean isTrackingUnchangedContent() {
        return false;
    }

    public static boolean fileInVcsByFileStatus(@NotNull Project project, @NotNull FilePath path2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/AbstractVcs", "fileInVcsByFileStatus"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/AbstractVcs", "fileInVcsByFileStatus"));
        }
        VirtualFile file = path2.getVirtualFile();
        return file == null || AbstractVcs.fileInVcsByFileStatus(project, file);
    }

    public static boolean fileInVcsByFileStatus(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/AbstractVcs", "fileInVcsByFileStatus"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/AbstractVcs", "fileInVcsByFileStatus"));
        }
        FileStatus status = FileStatusManager.getInstance(project).getStatus(file);
        return status != FileStatus.UNKNOWN && status != FileStatus.ADDED && status != FileStatus.IGNORED;
    }

    @Nullable
    public UpdateEnvironment getStatusEnvironment() {
        return null;
    }

    @Nullable
    public AnnotationProvider getAnnotationProvider() {
        return null;
    }

    @Nullable
    public DiffProvider getDiffProvider() {
        return null;
    }

    public VcsShowSettingOption getUpdateOptions() {
        return this.myUpdateOption;
    }

    public VcsShowSettingOption getStatusOptions() {
        return this.myStatusOption;
    }

    public void loadSettings() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(this.myProject);
        if (this.getUpdateEnvironment() != null) {
            this.myUpdateOption = vcsManager.getStandardOption(VcsConfiguration.StandardOption.UPDATE, this);
        }
        if (this.getStatusEnvironment() != null) {
            this.myStatusOption = vcsManager.getStandardOption(VcsConfiguration.StandardOption.STATUS, this);
        }
    }

    public FileStatus[] getProvidedStatuses() {
        return null;
    }

    @Nullable
    public RevisionSelector getRevisionSelector() {
        return null;
    }

    @Nullable
    public UpdateEnvironment getIntegrateEnvironment() {
        return null;
    }

    @Nullable
    public CommittedChangesProvider getCommittedChangesProvider() {
        return null;
    }

    @Nullable
    public final CachingCommittedChangesProvider getCachingCommittedChangesProvider() {
        CommittedChangesProvider provider = this.getCommittedChangesProvider();
        if (provider instanceof CachingCommittedChangesProvider) {
            return (CachingCommittedChangesProvider)provider;
        }
        return null;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString, FilePath path2) throws VcsException {
        return this.parseRevisionNumber(revisionNumberString);
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) throws VcsException {
        return null;
    }

    @Nullable
    public String getRevisionPattern() {
        return null;
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return false;
    }

    public boolean supportsVersionedStateDetection() {
        return true;
    }

    @Nullable
    public UnnamedConfigurable getRootConfigurable(VcsDirectoryMapping mapping) {
        return null;
    }

    @Nullable
    public VcsRootSettings createEmptyVcsRootSettings() {
        return null;
    }

    @Nullable
    public RootsConvertor getCustomConvertor() {
        return null;
    }

    @Nullable
    public MergeProvider getMergeProvider() {
        return null;
    }

    @Nullable
    public ChangeListEditHandler getEditHandler() {
        return null;
    }

    public boolean allowsNestedRoots() {
        return false;
    }

    public <S> List<S> filterUniqueRoots(List<S> in, Convertor<S, VirtualFile> convertor) {
        new FilterDescendantVirtualFileConvertible<S>(convertor, FilePathComparator.getInstance()).doFilter(in);
        return in;
    }

    public static <S> List<S> filterUniqueRootsDefault(List<S> in, Convertor<S, VirtualFile> convertor) {
        new FilterDescendantVirtualFileConvertible<S>(convertor, FilePathComparator.getInstance()).doFilter(in);
        return in;
    }

    @Nullable
    public VcsExceptionsHotFixer getVcsExceptionsHotFixer() {
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/AbstractVcs", "getProject"));
        }
        return project;
    }

    protected static VcsKey createKey(String name) {
        return new VcsKey(name);
    }

    public final VcsKey getKeyInstanceMethod() {
        return this.myKey;
    }

    public VcsType getType() {
        return VcsType.centralized;
    }

    public boolean checkImmediateParentsBeforeCommit() {
        return false;
    }

    @Nullable
    protected VcsOutgoingChangesProvider<ComList> getOutgoingProviderImpl() {
        return null;
    }

    @Nullable
    public final VcsOutgoingChangesProvider<ComList> getOutgoingChangesProvider() {
        return VcsType.centralized.equals((Object)this.getType()) ? null : this.getOutgoingProviderImpl();
    }

    public RemoteDifferenceStrategy getRemoteDifferenceStrategy() {
        return RemoteDifferenceStrategy.ASK_LATEST_REVISION;
    }

    public boolean areDirectoriesVersionedItems() {
        return false;
    }

    @Nullable
    protected TreeDiffProvider getTreeDiffProviderImpl() {
        return null;
    }

    @Nullable
    public TreeDiffProvider getTreeDiffProvider() {
        RemoteDifferenceStrategy strategy = this.getRemoteDifferenceStrategy();
        return RemoteDifferenceStrategy.ASK_LATEST_REVISION.equals((Object)strategy) ? null : this.getTreeDiffProviderImpl();
    }

    public List<CommitExecutor> getCommitExecutors() {
        return Collections.emptyList();
    }

    public boolean isVcsBackgroundOperationsAllowed(VirtualFile root) {
        return true;
    }

    public boolean allowsRemoteCalls(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/AbstractVcs", "allowsRemoteCalls"));
        }
        return true;
    }

    public void setCheckinEnvironment(CheckinEnvironment checkinEnvironment) {
        if (this.myCheckinEnvironment != null) {
            throw new IllegalStateException("Attempt to redefine checkin environment");
        }
        this.myCheckinEnvironment = checkinEnvironment;
    }

    public void setUpdateEnvironment(UpdateEnvironment updateEnvironment) {
        if (this.myUpdateEnvironment != null) {
            throw new IllegalStateException("Attempt to redefine update environment");
        }
        this.myUpdateEnvironment = updateEnvironment;
    }

    public void setRollbackEnvironment(RollbackEnvironment rollbackEnvironment) {
        if (this.myRollbackEnvironment != null) {
            throw new IllegalStateException("Attempt to redefine rollback environment");
        }
        this.myRollbackEnvironment = rollbackEnvironment;
    }

    public void setupEnvironments() {
        this.setCheckinEnvironment(this.createCheckinEnvironment());
        this.setUpdateEnvironment(this.createUpdateEnvironment());
        this.setRollbackEnvironment(this.createRollbackEnvironment());
    }

    public boolean reportsIgnoredDirectories() {
        return true;
    }

    @Nullable
    public CommittedChangeList loadRevisions(final VirtualFile vf, final VcsRevisionNumber number) {
        final CommittedChangeList[] list = new CommittedChangeList[1];
        ThrowableRunnable<VcsException> runnable = new ThrowableRunnable<VcsException>(){

            public void run() throws VcsException {
                Pair pair = AbstractVcs.this.getCommittedChangesProvider().getOneList(vf, number);
                if (pair != null) {
                    list[0] = (CommittedChangeList)pair.getFirst();
                }
            }
        };
        return VcsSynchronousProgressWrapper.wrap(runnable, this.getProject(), "Load revision contents") ? list[0] : null;
    }

    @Nullable
    public AnnotationProvider getCachingAnnotationProvider() {
        AnnotationProvider ap = this.getAnnotationProvider();
        if (ourUseAnnotationCache && ap instanceof VcsCacheableAnnotationProvider) {
            return new VcsAnnotationCachedProxy(this, ProjectLevelVcsManager.getInstance(this.myProject).getVcsHistoryCache());
        }
        return ap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractVcs that = (AbstractVcs)o;
        return this.myKey.equals(that.myKey);
    }

    public int hashCode() {
        return this.myKey.hashCode();
    }

    public boolean fileListenerIsSynchronous() {
        return true;
    }

    public boolean revisionsSame(@NotNull VcsRevisionNumber number1, @NotNull VcsRevisionNumber number2) {
        if (number1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "number1", "com/intellij/openapi/vcs/AbstractVcs", "revisionsSame"));
        }
        if (number2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "number2", "com/intellij/openapi/vcs/AbstractVcs", "revisionsSame"));
        }
        return number1.equals(number2);
    }

    public CheckoutProvider getCheckoutProvider() {
        return null;
    }

    static {
        String property = System.getProperty(USE_ANNOTATION_CACHE);
        ourUseAnnotationCache = true;
        if (property != null) {
            ourUseAnnotationCache = Boolean.valueOf(property);
        }
    }

    public static interface RootsConvertor {
        @NotNull
        public List<VirtualFile> convertRoots(@NotNull List<VirtualFile> var1);
    }
}

