/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Project;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import com.android.tools.klint.detector.api.TextFormat;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.USimpleReferenceExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UType;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastErrorType;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class JavaPerformanceDetector
extends Detector
implements UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(JavaPerformanceDetector.class, Scope.SOURCE_FILE_SCOPE);
    public static final Issue PAINT_ALLOC = Issue.create("DrawAllocation", "Memory allocations within drawing code", "You should avoid allocating objects during a drawing or layout operation. These are called frequently, so a smooth UI can be interrupted by garbage collection pauses caused by the object allocations.\n\nThe way this is generally handled is to allocate the needed objects up front and to reuse them for each drawing operation.\n\nSome methods allocate memory on your behalf (such as `Bitmap.create`), and these should be handled in the same way.", Category.PERFORMANCE, 9, Severity.WARNING, IMPLEMENTATION);
    public static final Issue USE_SPARSE_ARRAY = Issue.create("UseSparseArrays", "HashMap can be replaced with SparseArray", "For maps where the keys are of type integer, it's typically more efficient to use the Android `SparseArray` API. This check identifies scenarios where you might want to consider using `SparseArray` instead of `HashMap` for better performance.\n\nThis is *particularly* useful when the value types are primitives like ints, where you can use `SparseIntArray` and avoid auto-boxing the values from `int` to `Integer`.\n\nIf you need to construct a `HashMap` because you need to call an API outside of your control which requires a `Map`, you can suppress this warning using for example the `@SuppressLint` annotation.", Category.PERFORMANCE, 4, Severity.WARNING, IMPLEMENTATION);
    public static final Issue USE_VALUE_OF = Issue.create("UseValueOf", "Should use `valueOf` instead of `new`", "You should not call the constructor for wrapper classes directly, such as`new Integer(42)`. Instead, call the `valueOf` factory method, such as `Integer.valueOf(42)`. This will typically use less memory because common integers such as 0 and 1 will share a single instance.", Category.PERFORMANCE, 4, Severity.WARNING, IMPLEMENTATION);
    static final String ON_MEASURE = "onMeasure";
    static final String ON_DRAW = "onDraw";
    static final String ON_LAYOUT = "onLayout";
    private static final String INTEGER = "Integer";
    private static final String BOOLEAN = "Boolean";
    private static final String BYTE = "Byte";
    private static final String LONG = "Long";
    private static final String CHARACTER = "Character";
    private static final String DOUBLE = "Double";
    private static final String FLOAT = "Float";
    private static final String HASH_MAP = "HashMap";
    private static final String SPARSE_ARRAY = "SparseArray";
    private static final String CANVAS = "Canvas";
    private static final String LAYOUT = "layout";

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public UastVisitor createUastVisitor(UastAndroidContext context) {
        return new PerformanceVisitor(context);
    }

    private static String getUseValueOfErrorMessage(String typeName, String argument) {
        return String.format("Use `%1$s.valueOf(%2$s)` instead", typeName, argument);
    }

    @Nullable
    public static String getReplacedType(@NonNull String message2, @NonNull TextFormat format) {
        int index = (message2 = format.toText(message2)).indexOf(46);
        if (index != -1 && message2.startsWith("Use ")) {
            return message2.substring(4, index);
        }
        return null;
    }

    private static class AssignmentTracker
    extends AbstractUastVisitor {
        private final Collection<String> mVariables;

        public AssignmentTracker(Collection<String> variables) {
            this.mVariables = variables;
        }

        @Override
        public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/JavaPerformanceDetector$AssignmentTracker", "visitBinaryExpression"));
            }
            UastBinaryOperator operator2 = node.getOperator();
            if (operator2 == UastBinaryOperator.ASSIGN || operator2 == UastBinaryOperator.OR_ASSIGN) {
                UExpression left = node.getLeftOperand();
                String variable2 = null;
                if (left instanceof UQualifiedExpression && ((UQualifiedExpression)left).getReceiver() instanceof UThisExpression) {
                    UExpression selector2 = ((UQualifiedExpression)left).getSelector();
                    if (selector2 instanceof USimpleReferenceExpression) {
                        variable2 = ((USimpleReferenceExpression)selector2).getIdentifier();
                    }
                } else if (left instanceof USimpleReferenceExpression) {
                    variable2 = ((USimpleReferenceExpression)left).getIdentifier();
                }
                if (variable2 != null) {
                    this.mVariables.add(variable2);
                }
            }
            return super.visitBinaryExpression(node);
        }
    }

    private static class PerformanceVisitor
    extends AbstractUastVisitor {
        private final UastAndroidContext mContext;
        private final boolean mCheckMaps;
        private final boolean mCheckAllocations;
        private final boolean mCheckValueOf;
        private boolean mFlagAllocations;

        public PerformanceVisitor(UastAndroidContext context) {
            this.mContext = context;
            JavaContext lintContext = context.getLintContext();
            this.mCheckAllocations = lintContext.isEnabled(PAINT_ALLOC);
            this.mCheckMaps = lintContext.isEnabled(USE_SPARSE_ARRAY);
            this.mCheckValueOf = lintContext.isEnabled(USE_VALUE_OF);
        }

        @Override
        public boolean visitFunction(@NotNull UFunction node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/JavaPerformanceDetector$PerformanceVisitor", "visitFunction"));
            }
            this.mFlagAllocations = PerformanceVisitor.isBlockedAllocationMethod(node);
            return super.visitFunction(node);
        }

        @Override
        public boolean visitCallExpression(@NotNull UCallExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/JavaPerformanceDetector$PerformanceVisitor", "visitCallExpression"));
            }
            UastCallKind kind2 = node.getKind();
            if (kind2 == UastCallKind.CONSTRUCTOR_CALL) {
                this.visitConstructorInvocation(node);
            } else if (kind2 == UastCallKind.FUNCTION_CALL) {
                this.visitFunctionInvocation(node);
            }
            return super.visitCallExpression(node);
        }

        private void visitConstructorInvocation(UCallExpression node) {
            UClass clazz;
            USimpleReferenceExpression classReference2 = node.getClassReference();
            if (classReference2 == null) {
                return;
            }
            String typeName = null;
            if (this.mCheckMaps && (clazz = classReference2.resolveClass(this.mContext)) != null) {
                typeName = clazz.getName();
                if (clazz.matchesName(JavaPerformanceDetector.HASH_MAP)) {
                    this.checkHashMap(node);
                } else if (clazz.matchesName(JavaPerformanceDetector.SPARSE_ARRAY)) {
                    this.checkSparseArray(node);
                }
            }
            if (this.mCheckValueOf) {
                UDeclaration resolvedDeclaration;
                UType type2 = UastErrorType.INSTANCE;
                if (typeName == null && (resolvedDeclaration = classReference2.resolve(this.mContext)) instanceof UClass) {
                    type2 = ((UClass)resolvedDeclaration).getDefaultType();
                    typeName = type2.getName();
                }
                if ((type2.isInt() || type2.isBoolean() || type2.isFloat() || type2.isChar() || type2.isLong() || type2.isDouble() || type2.isShort() || type2.isByte()) && node.getValueArgumentCount() == 1) {
                    String argument = node.getValueArguments().get(0).renderString();
                    this.mContext.report(USE_VALUE_OF, node, this.mContext.getLocation(node), JavaPerformanceDetector.getUseValueOfErrorMessage(typeName, argument));
                }
            }
            if (this.mFlagAllocations && !(node.getParent() instanceof UThrowExpression) && this.mCheckAllocations) {
                UElement method;
                for (method = node; method != null && !(method instanceof UFunction); method = method.getParent()) {
                }
                if (method != null && PerformanceVisitor.isBlockedAllocationMethod((UFunction)method) && !PerformanceVisitor.isLazilyInitialized(node)) {
                    this.reportAllocation(node);
                }
            }
        }

        private void reportAllocation(UElement node) {
            this.mContext.report(PAINT_ALLOC, node, this.mContext.getLocation(node), "Avoid object allocations during draw/layout operations (preallocate and reuse instead)");
        }

        private void visitFunctionInvocation(UCallExpression node) {
            UExpression operand2 = UastUtils.getReceiver(node);
            if (this.mFlagAllocations && operand2 != null) {
                String methodName = node.getFunctionName();
                if ("createBitmap".equals(methodName) || "createScaledBitmap".equals(methodName)) {
                    String operandText = operand2.renderString();
                    if ((operandText.equals("Bitmap") || operandText.equals("android.graphics.Bitmap")) && !PerformanceVisitor.isLazilyInitialized(node)) {
                        this.reportAllocation(node);
                    }
                } else if (methodName != null && methodName.startsWith("decode")) {
                    String operandText = operand2.renderString();
                    if ((operandText.equals("BitmapFactory") || operandText.equals("android.graphics.BitmapFactory")) && !PerformanceVisitor.isLazilyInitialized(node)) {
                        this.reportAllocation(node);
                    }
                } else if ("getClipBounds".equals(methodName) && node.getValueArgumentCount() == 0) {
                    this.mContext.report(PAINT_ALLOC, node, this.mContext.getLocation(node), "Avoid object allocations during draw operations: Use `Canvas.getClipBounds(Rect)` instead of `Canvas.getClipBounds()` which allocates a temporary `Rect`");
                }
            }
        }

        private static boolean isLazilyInitialized(UElement node) {
            for (UElement curr = node.getParent(); curr != null; curr = curr.getParent()) {
                if (curr instanceof UFunction) {
                    return false;
                }
                if (!(curr instanceof UIfExpression)) continue;
                UIfExpression ifNode = (UIfExpression)curr;
                ArrayList<String> assignments = new ArrayList<String>();
                UExpression thenBranch2 = ifNode.getThenBranch();
                if (thenBranch2 != null) {
                    AssignmentTracker visitor2 = new AssignmentTracker(assignments);
                    thenBranch2.accept(visitor2);
                }
                if (!assignments.isEmpty()) {
                    ArrayList<String> references = new ArrayList<String>();
                    PerformanceVisitor.addReferencedVariables(references, ifNode.getCondition());
                    if (!references.isEmpty()) {
                        Sets.SetView intersection = Sets.intersection(new HashSet<String>(assignments), new HashSet<String>(references));
                        return !intersection.isEmpty();
                    }
                }
                return false;
            }
            return false;
        }

        private static void addReferencedVariables(Collection<String> variables, UExpression expression2) {
            UQualifiedExpression select;
            if (expression2 instanceof UBinaryExpression) {
                UBinaryExpression binary = (UBinaryExpression)expression2;
                PerformanceVisitor.addReferencedVariables(variables, binary.getLeftOperand());
                PerformanceVisitor.addReferencedVariables(variables, binary.getRightOperand());
            } else if (expression2 instanceof UUnaryExpression) {
                UUnaryExpression unary = (UUnaryExpression)expression2;
                PerformanceVisitor.addReferencedVariables(variables, unary.getOperand());
            } else if (expression2 instanceof USimpleReferenceExpression) {
                USimpleReferenceExpression reference = (USimpleReferenceExpression)expression2;
                variables.add(reference.getIdentifier());
            } else if (expression2 instanceof UQualifiedExpression && (select = (UQualifiedExpression)expression2).getReceiver() instanceof UThisExpression && select.getSelector() instanceof USimpleReferenceExpression) {
                variables.add(((USimpleReferenceExpression)select.getSelector()).getIdentifier());
            }
        }

        private static boolean isBlockedAllocationMethod(UFunction node) {
            return PerformanceVisitor.isOnDrawMethod(node) || PerformanceVisitor.isOnMeasureMethod(node) || PerformanceVisitor.isOnLayoutMethod(node) || PerformanceVisitor.isLayoutMethod(node);
        }

        private static boolean isOnDrawMethod(UFunction node) {
            UVariable arg0;
            List<UVariable> parameters2;
            return JavaPerformanceDetector.ON_DRAW.equals(node.getName()) && (parameters2 = node.getValueParameters()).size() == 1 && (arg0 = parameters2.get(0)).getType().matchesName(JavaPerformanceDetector.CANVAS);
        }

        private static boolean isOnLayoutMethod(UFunction node) {
            List<UVariable> parameters2;
            if (JavaPerformanceDetector.ON_LAYOUT.equals(node.getName()) && (parameters2 = node.getValueParameters()).size() == 5) {
                Iterator<UVariable> iterator = parameters2.iterator();
                if (!iterator.hasNext()) {
                    return false;
                }
                UType type2 = iterator.next().getType();
                if (!type2.isBoolean() || !iterator.hasNext()) {
                    return false;
                }
                for (int i = 0; i < 4; ++i) {
                    type2 = iterator.next().getType();
                    if (!type2.isInt()) {
                        return false;
                    }
                    if (iterator.hasNext()) continue;
                    return i == 3;
                }
            }
            return false;
        }

        private static boolean isOnMeasureMethod(UFunction node) {
            List<UVariable> parameters2;
            if (JavaPerformanceDetector.ON_MEASURE.equals(node.getName()) && (parameters2 = node.getValueParameters()).size() == 2) {
                UVariable arg0 = parameters2.get(0);
                UVariable arg1 = parameters2.get(parameters2.size() - 1);
                return arg0.getType().isInt() && arg1.getType().isInt();
            }
            return false;
        }

        private static boolean isLayoutMethod(UFunction node) {
            List<UVariable> parameters2;
            if (JavaPerformanceDetector.LAYOUT.equals(node.getName()) && (parameters2 = node.getValueParameters()).size() == 4) {
                Iterator<UVariable> iterator = parameters2.iterator();
                for (int i = 0; i < 4; ++i) {
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    UVariable next = iterator.next();
                    if (next.getType().isInt()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void checkHashMap(UCallExpression node) {
            List<UType> types2 = node.getTypeArguments();
            if (types2.size() == 2) {
                UType first = types2.get(0);
                Project mainProject = this.mContext.getLintContext().getMainProject();
                int minSdk = mainProject.getMinSdk();
                if (first.isInt() || first.isByte()) {
                    UType valueType = types2.get(1);
                    String valueTypeText = valueType.getName();
                    if (valueType.isInt()) {
                        this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getLocation(node), "Use new `SparseIntArray(...)` instead for better performance");
                    } else if (valueType.isLong() && minSdk >= 18) {
                        this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getLocation(node), "Use `new SparseLongArray(...)` instead for better performance");
                    } else if (valueType.isBoolean()) {
                        this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getLocation(node), "Use `new SparseBooleanArray(...)` instead for better performance");
                    } else {
                        this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getLocation(node), String.format("Use `new SparseArray<%1$s>(...)` instead for better performance", valueTypeText));
                    }
                } else if (first.isLong() && (minSdk >= 16 || Boolean.TRUE == mainProject.dependsOn("com.android.support:support-v4"))) {
                    boolean useBuiltin = minSdk >= 16;
                    String message2 = useBuiltin ? "Use `new LongSparseArray(...)` instead for better performance" : "Use `new android.support.v4.util.LongSparseArray(...)` instead for better performance";
                    this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getLocation(node), message2);
                }
            }
        }

        private void checkSparseArray(UCallExpression node) {
            List<UType> types2 = node.getTypeArguments();
            if (types2.size() == 1) {
                UType first = types2.get(0);
                if (first.isInt()) {
                    this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getLocation(node), "Use `new SparseIntArray(...)` instead for better performance");
                } else if (first.isBoolean()) {
                    this.mContext.report(USE_SPARSE_ARRAY, node, this.mContext.getLocation(node), "Use `new SparseBooleanArray(...)` instead for better performance");
                }
            }
        }
    }
}

