/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0006\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0006\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0013"}, d2={"transitiveStaticRef", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "getTransitiveStaticRef", "(Lcom/google/dart/compiler/backend/js/ast/JsExpression;)Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "getCallerQualifier", "invocation", "Lcom/google/dart/compiler/backend/js/ast/JsInvocation;", "getCallerQualifierImpl", "getSimpleIdent", "", "call", "getSimpleName", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "getStaticRef", "Lcom/google/dart/compiler/backend/js/ast/JsNode;", "hasCallerQualifier", "", "isCallInvocation", "isFunctionCreatorInvocation", "kotlin-compiler"})
public final class InvocationUtilsKt {
    @Nullable
    public static final JsName getSimpleName(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        JsExpression qualifier = call.getQualifier();
        JsExpression jsExpression = qualifier;
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        return jsNameRef != null ? jsNameRef.getName() : null;
    }

    @Nullable
    public static final String getSimpleIdent(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        JsExpression qualifier = call.getQualifier();
        while (qualifier != null) {
            JsExpression jsExpression = qualifier;
            if (jsExpression instanceof JsInvocation) {
                JsExpression callableQualifier = qualifier;
                qualifier = ((JsInvocation)callableQualifier).getQualifier();
                if (!InvocationUtilsKt.isCallInvocation((JsInvocation)callableQualifier)) continue;
                JsExpression jsExpression2 = qualifier;
                if (!(jsExpression2 instanceof JsNameRef)) {
                    jsExpression2 = null;
                }
                JsNameRef jsNameRef = (JsNameRef)jsExpression2;
                qualifier = jsNameRef != null ? jsNameRef.getQualifier() : null;
                continue;
            }
            if (!(jsExpression instanceof HasName)) break;
            JsName jsName = ((HasName)((Object)qualifier)).getName();
            return jsName != null ? jsName.getIdent() : null;
        }
        return null;
    }

    public static final boolean isFunctionCreatorInvocation(@NotNull JsInvocation invocation) {
        JsNode staticRef;
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsNode jsNode = staticRef = InvocationUtilsKt.getStaticRef(invocation);
        return jsNode instanceof JsFunction ? FunctionUtilsKt.isFunctionCreator((JsFunction)staticRef) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCallInvocation(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsExpression jsExpression = invocation.getQualifier();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef qualifier = (JsNameRef)jsExpression;
        List<JsExpression> arguments2 = invocation.getArguments();
        JsNameRef jsNameRef = qualifier;
        if (!Intrinsics.areEqual(jsNameRef != null ? jsNameRef.getIdent() : null, "call")) return false;
        Collection collection = arguments2;
        if (collection.isEmpty()) return false;
        return true;
    }

    public static final boolean hasCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        return InvocationUtilsKt.getCallerQualifierImpl(invocation) != null;
    }

    @NotNull
    public static final JsExpression getCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsExpression jsExpression = InvocationUtilsKt.getCallerQualifierImpl(invocation);
        if (jsExpression == null) {
            throw (Throwable)((Object)new AssertionError((Object)"must check hasQualifier() before calling getQualifier"));
        }
        return jsExpression;
    }

    private static final JsExpression getCallerQualifierImpl(JsInvocation invocation) {
        JsExpression jsExpression = invocation.getQualifier();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        return jsNameRef != null ? jsNameRef.getQualifier() : null;
    }

    private static final JsNode getStaticRef(JsInvocation invocation) {
        JsName qualifierName;
        JsExpression qualifier = invocation.getQualifier();
        JsExpression jsExpression = qualifier;
        if (!(jsExpression instanceof HasName)) {
            jsExpression = null;
        }
        HasName hasName = (HasName)((Object)jsExpression);
        JsName jsName = qualifierName = hasName != null ? hasName.getName() : null;
        return jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
    }

    @NotNull
    public static final JsExpression getTransitiveStaticRef(@NotNull JsExpression $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsExpression qualifier = $receiver;
        while (qualifier instanceof JsNameRef) {
            JsName jsName = ((JsNameRef)qualifier).getName();
            JsNode jsNode = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
            if (!(jsNode instanceof JsExpression)) {
                jsNode = null;
            }
            if ((JsExpression)jsNode != null) continue;
            break;
        }
        return qualifier;
    }
}

