/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.declarations;

import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNullable;
import org.jetbrains.kotlin.storage.StorageManager;

public abstract class AbstractDeclarationProviderFactory
implements DeclarationProviderFactory {
    private final MemoizedFunctionToNullable<FqName, PackageMemberDeclarationProvider> packageDeclarationProviders;

    public AbstractDeclarationProviderFactory(@NotNull StorageManager storageManager) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/resolve/lazy/declarations/AbstractDeclarationProviderFactory", "<init>"));
        }
        this.packageDeclarationProviders = storageManager.createMemoizedFunctionWithNullableValues(new Function1<FqName, PackageMemberDeclarationProvider>(){

            @Override
            public PackageMemberDeclarationProvider invoke(FqName fqName2) {
                return AbstractDeclarationProviderFactory.this.createPackageMemberDeclarationProvider(fqName2);
            }
        });
    }

    @Nullable
    protected abstract PackageMemberDeclarationProvider createPackageMemberDeclarationProvider(@NotNull FqName var1);

    @Override
    public PackageMemberDeclarationProvider getPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/resolve/lazy/declarations/AbstractDeclarationProviderFactory", "getPackageMemberDeclarationProvider"));
        }
        return (PackageMemberDeclarationProvider)this.packageDeclarationProviders.invoke(packageFqName);
    }

    @Override
    public void diagnoseMissingPackageFragment(KtFile file) {
        throw new IllegalStateException("Cannot find package fragment for file " + file.getName() + " with package " + file.getPackageFqName());
    }
}

