/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.yaml.YAMLTokenTypes;

public class _YAMLLexer
implements FlexLexer,
YAMLTokenTypes {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int BRACES = 2;
    public static final int VALUE = 4;
    public static final int VALUE_OR_KEY = 6;
    public static final int VALUE_BRACE = 8;
    public static final int INDENT_VALUE = 10;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
    static final char[] ZZ_CMAP_Z = _YAMLLexer.zzUnpackCMap("\u0001\u0000\u0001\u0001\b\u0002\u0001\u0003\u0004\u0002\u0001\u0004\u0001\u0005\u0001\u0006\u0004\u0002\u0001\u0007\u0006\u0002\u0001\b\u00f2\u0002");
    static final char[] ZZ_CMAP_Y = _YAMLLexer.zzUnpackCMap("\u0001\u0000\u0001\u0001\u0017\u0002\u0001\u0003\u0001\u0002\u0001\u0004\u0003\u0002\u0001\u0005\u0005\u0002\u0001\u0006\u0001\u0002\u0001\u0006\u0001\u0002\u0001\u0006\u0001\u0002\u0001\u0006\u0001\u0002\u0001\u0006\u0001\u0002\u0001\u0006\u0001\u0002\u0001\u0006\u0001\u0002\u0001\u0006\u0001\u0002\u0001\u0006\u0001\u0002\u0001\u0006\u0001\u0002\u0001\u0007\u0001\u0002\u0001\u0007\u0001\u0003\u0004\u0002\u0001\u0005\u0001\u0007\u001c\u0002\u0001\u0003\u0001\u0007\u0004\u0002\u0001\b\u0001\u0002\u0001\u0007\u0002\u0002\u0001\t\u0002\u0002\u0001\u0007\u0001\u0004\u0002\u0002\u0001\tf\u0002\u0001\u0003\n\u0002\u0001\u0007\u0001\u0005\u0002\u0002\u0001\n\u0001\u0002\u0001\u0007\u0005\u0002\u0001\u0004L\u0002\u0001\u0007\u0015\u0002\u0001\u0003.\u0002\u0001\u0006\u0001\u0002\u0001\u0004\u0001\u000b\u0002\u0002\u0001\u0007\u0003\u0002\u0001\u0004\u0007\u0002\u0001\u0007\u0005\u0002\u0001\u0007\u0001\u0002\u0001\u0005\u0001\u0004\u0006\u0002\u0001\u0003E\u0002\u0001\u0003\u0003\u0002\u0001\u00071\u0002\u0001\f \u0002");
    static final char[] ZZ_CMAP_A = _YAMLLexer.zzUnpackCMap("\t\u0000\u0001\b\u0001\u0007\u0002\u0000\u0001\u0001\u0012\u0000\u0001\u000b\u0001\u0017\u0001\u0011\u0001\u0005\u0001\u0015\u0001\u000f\u0001\u0016\u0001\u0012\u0002\u0015\u0001\u0016\u0001\u001a\u0001\u0003\u0001\n\u0002\u0015\n\u0013\u0001\u0006\u0001\u0015\u0001\u0018\u0001\u0015\u0001\f\u0001\u0004\u0001\u0016\u0006\u0013\u0014\u0014\u0001\u0019\u0001\u0010\u0001\t\u0001\u0000\u0001\u0015\u0001\u0002\u0006\u0013\u0014\u0014\u0001\r\u0001\u001b\u0001\u000e\u0001\u0015a\u0000\n\u0013F\u0000\n\u0013\u0006\u0000\n\u0013\\\u0000\n\u0013 \u0000\n\u0013,\u0000\n\u00130\u0000\n\u0013\u0006\u0000\n\u00136\u0000\n\u0013\u0016\u0000\n\u0013<\u0000\n\u0013\u000e\u00002\u0013");
    private static final int[] ZZ_ACTION = _YAMLLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u000e\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0002\u0001\u0006\u0001\u0007\u0001\b\u0002\u0002\u0001\t\u0001\n\u0004\u0002\u0001\u000b\u0001\u0002\u0001\u0001\u0001\u0004\u0002\u0002\u0001\t\u0001\u0002\u0001\u0001\u0001\u0004\u0005\u0002\u0001\u0001\u0001\u0004\u0002\u0002\u0001\f\u0001\r\u0001\u000e\b\u0000\u0001\u0001\u0001\u0000\u0001\u000f\u0001\u0000\u0002\u0010\u0002\u0011\u0002\u0012\u0006\u0000\u0001\u0013\u0002\u0000\u0001\u0014\u0001\u0000\u0002\u0015\u0004\u0000\u0002\u0016\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u000f\u0003\u0000\u0001\u0001\u0004\u0000\u0001\u0013\u0001\u0014\u0001\u0001\u0003\u0000\u0001\u0017\f\u0000\u0001\u0018\u0001\u0000\u0001\u0001\u0002\u0000\u0001\u0019\u0003\u0000\u0001\u001a\u0001\u0000\u0001\u0001\u0005\u0000\u0001\u0001\u0002\u0000\u0002\u0001\u0002\u0000\u0002\u0001\u0002\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0003\u0000\u0002\u0001\u0001\u0000\u0004\u0001\u0001\u0000\u0001\u0001\u0002\u0000\u0001\u0001";
    private static final int[] ZZ_ROWMAP = _YAMLLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u001c\u00008\u0000T\u0000p\u0000\u008c\u0000\u00a8\u0000\u00c4\u0000\u00e0\u0000\u00fc\u0000\u0118\u0000\u0134\u0000\u0150\u0000\u016c\u0000\u0188\u0000\u01a4\u0000\u01a4\u0000\u01c0\u0000\u01dc\u0000\u01f8\u0000\u01a4\u0000\u0214\u0000\u01a4\u0000\u0230\u0000\u024c\u0000\u0268\u0000\u01a4\u0000\u0284\u0000\u02a0\u0000\u02bc\u0000\u02d8\u0000\u01a4\u0000\u02f4\u0000\u0310\u0000\u032c\u0000\u0348\u0000\u0364\u0000\u0380\u0000\u039c\u0000\u03b8\u0000\u03d4\u0000\u03f0\u0000\u03d4\u0000\u040c\u0000\u0428\u0000\u01c0\u0000\u0444\u0000\u0460\u0000\u047c\u0000\u0460\u0000\u0498\u0000\u01a4\u0000\u04b4\u0000\u04d0\u0000\u01a4\u0000\u04ec\u0000\u0508\u0000\u0524\u0000\u0540\u0000\u055c\u0000\u0578\u0000\u0594\u0000\u05b0\u0000\u05cc\u0000\u0188\u0000\u01a4\u0000\u05e8\u0000\u01a4\u0000\u0604\u0000\u01a4\u0000\u0620\u0000\u063c\u0000\u0658\u0000\u0674\u0000\u02a0\u0000\u040c\u0000\u0690\u0000\u06ac\u0000\u02bc\u0000\u0428\u0000\u06c8\u0000\u06e4\u0000\u01a4\u0000\u0700\u0000\u071c\u0000\u0738\u0000\u0754\u0000\u0770\u0000\u01a4\u0000\u078c\u0000\u07a8\u0000\u07c4\u0000\u07e0\u0000\u07fc\u0000\u0310\u0000\u0818\u0000\u0834\u0000\u0850\u0000\u086c\u0000\u03d4\u0000\u03b8\u0000\u0888\u0000\u01a4\u0000\u08a4\u0000\u08c0\u0000\u08dc\u0000\u0460\u0000\u0444\u0000\u01a4\u0000\u08f8\u0000\u0914\u0000\u0930\u0000\u08f8\u0000\u094c\u0000\u0968\u0000\u0984\u0000\u0524\u0000\u09a0\u0000\u09bc\u0000\u055c\u0000\u01a4\u0000\u01a4\u0000\u09d8\u0000\u09f4\u0000\u0a10\u0000\u0a2c\u0000\u01a4\u0000\u0a48\u0000\u0a64\u0000\u0a80\u0000\u01a4\u0000\u0a9c\u0000\u0ab8\u0000\u0ad4\u0000\u0af0\u0000\u0b0c\u0000\u0b28\u0000\u0b44\u0000\u0b60\u0000\u0b7c\u0000\u0b98\u0000\u0bb4\u0000\u0bd0\u0000\u0bec\u0000\u09f4\u0000\u0c08\u0000\u0c24\u0000\u0c40\u0000\u0c5c\u0000\u0c78\u0000\u0c94\u0000\u0cb0\u0000\u0ccc\u0000\u0ce8\u0000\u0d04\u0000\u0ab8\u0000\u0d20\u0000\u0d3c\u0000\u0d58\u0000\u0d74\u0000\u0b60\u0000\u0d90\u0000\u0dac\u0000\u0dc8\u0000\u0de4\u0000\u0e00\u0000\u0e1c\u0000\u0c78\u0000\u0e38\u0000\u0e54";
    private static final int[] ZZ_TRANS = _YAMLLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u000f\u0002\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0016\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u000f\u0001\u001d\u0001\u001e\u0003\u000f\u0001\u0010\u0001\u001f\u0001\u000f\u0001 \u0001\u000f\u0001!\u0001\"\u0002\u0010\u0001\u0011\u0001#\u0001\u0013\u0001$\u0001\u0015\u0001\u0016\u0001\u0017\u0001%\u0001\u0016\u0001\u0010\u0001&\u0001\u001b\u0001'\u0001\"\u0001\u001d\u0001\u001e\u0003\"\u0001\u0010\u0001\u001f\u0001\"\u0001 \u0001\"\u0001\u0010\u0001(\u0002\u0010\u0001\u0011\u0001)\u0001\u0013\u0001*\u0001\u0015\u0001\u0016\u0001\u0017\u0001+\u0001\u0016\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001(\u0001,\u0001-\u0003(\u0001\u0010\u0001\u001f\u0001(\u0001 \u0001(\u0001!\u0001\u000f\u0002\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001.\u0001\u0016\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u000f\u0001\u001d\u0001\u001e\u0003\u000f\u0001\u0010\u0001\u001f\u0001\u000f\u0001 \u0001\u000f\u0001!\u0001/\u0002\u0010\u0001\u0011\u00010\u0001\u0013\u00011\u0001\u0015\u0001\u0016\u0001\u0017\u00012\u0001\u0016\u0001\u0019\u0001&\u0001\u001b\u0001'\u0001/\u0001,\u0001-\u0003/\u0001\u0010\u0001\u001f\u0001/\u0001 \u0001/\u0001!\u00073\u00014\u00015\u00023\u00015\u00103\u0017\u0000\u00016\u000b\u0000\u00017\u00018\u0002\u0000\u00018\u0010\u0000\u00019\u0003\u0000\u0001:\u0001\u0000\u0001:\u0003\u0000\u0001:\u0005\u0000\u00019\u0002\u0000\u00039\u0002\u0000\u00019\u0001\u0000\u00019\u0002\u0000\u00017\u0001\u0000\u00017\u0003\u0000\u00037\u0001\u0000\u00017\u0001\u0000\u00027\n\u0000\u00017\u0002\u0000\u0001;\u0003\u0000\u0001<\u0001\u0000\u0001<\u0003\u0000\u0001<\u0005\u0000\u0001;\u0002\u0000\u0003;\u0002\u0000\u0001;\u0001\u0000\u0001;\u0002\u0000\u00017\u0005\u0000\u00027\u0002\u0000\u00017\u001c\u0000\u0001=*\u0000\u0001=\u0001>\u0001\u0000\u0003>\u0001?\u0001@\u0001\u0000\u0001A\u0002>\u0001A\u0010>\u001c\u0000\u0001\u000f\u0001\u0000\u0005\u000f\u0002\u0000\u0002\u000f\u0001\u0000\u0010\u000f\u0007\u0013\u0001\u0000\u0014\u0013\u0001\u000f\u0001\u0000\u0005\u000f\u0001B\u0001C\u0002\u000f\u0001C\u0010\u000f\b\u0000\u0001\u0016\u0002\u0000\u0001\u0016\u0010\u0000\u0001\u000f\u0001\u0000\u0005\u000f\u0001D\u0001E\u0002\u000f\u0001E\u0010\u000f\u0007\u0000\u0001F\u0001G\u0001\u0000\u0001H\u0001G\u000e\u0000\u0001H\u000e\u0000\u0001I\u001b\u0000\u0001J\u000e\u0000\u0007K\u0001L\bK\u0001M\u0001N\nK\u0007O\u0001P\nO\u0001Q\tO\u0004\u0000\u0003R\u0001S\u0001T\u0001\u0000\u0001U\u0001T\u0003\u0000\u0001V\u0002\u0000\u0001R\u0002U\u0002R\u0001W\u0001X\u0001\u0000\u0001R\b\u0000\u0001Y\u0001Z\u0001\u0000\u0001[\u0001Z\u000e\u0000\u0001[\u0001\u0000\u0001\\\u0001\u0000\u0001\\\u0001]\u0001\\\u0001]\u0001^\u0001\u0000\u0001_\u0001]\u0001\\\u0001_\u0001\\\u0002]\n\\\u0001]\u0002\\\u0001\"\u0001\u0000\u0001\"\u0001\u0000\u0003\"\u0003\u0000\u0001\"\u0001\u0000\u0001\"\u0002\u0000\n\"\u0001\u0000\u0003\"\u0001\u0000\u0001\"\u0001\u0000\u0003\"\u0001B\u0001C\u0001\u0000\u0001\"\u0001C\u0001\"\u0002\u0000\n\"\u0001\u0000\u0003\"\u0001\u0000\u0001\"\u0001\u0000\u0003\"\u0001D\u0001E\u0001\u0000\u0001\"\u0001E\u0001\"\u0002\u0000\n\"\u0001\u0000\u0002\"\r\u0000\u0001`\u001b\u0000\u0001a\u000e\u0000\u0001b\u0001\u0000\u0003b\u0001c\u0001d\u0001\u0000\u0001e\u0002b\u0001e\u0010b\u0001(\u0001\u0000\u0005(\u0002\u0000\u0002(\u0001\u0000\u0011(\u0001\u0000\u0005(\u0001B\u0001C\u0002(\u0001C\u0010(\u0010L\u0001f\u0001g\nL\u0012P\u0001h\tP\u0001i\u0001\u0000\u0001i\u0001j\u0001i\u0001j\u0001k\u0001\u0000\u0001l\u0001j\u0001i\u0001l\u0001i\u0002j\ni\u0001j\u0002i\u0001/\u0001\u0000\u0001/\u0001\u0000\u0003/\u0003\u0000\u0001/\u0001\u0000\u0001/\u0002\u0000\n/\u0001\u0000\u0003/\u0001\u0000\u0001/\u0001\u0000\u0003/\u0001B\u0001C\u0001\u0000\u0001/\u0001C\u0001/\u0002\u0000\n/\u0001\u0000\u0002/\u00073\u0001\u0000\u00143\u0007\u0000\u0001m\u00015\u0002\u0000\u00015\u0014\u0000\u0003n\u0003\u0000\u0001o\u0004\u0000\u0001p\u0002\u0000\u0001n\u0002o\u0002n\u0001q\u0001r\u0001\u0000\u0001n\t\u0000\u00018\u0002\u0000\u00018\u0010\u0000\u0001s\u0001\u0000\u0001s\u0001t\u0001s\u0001t\u0001u\u0001\u0000\u00019\u0001t\u0001s\u00019\u0001s\u0002t\ns\u0001t\u0002s\u00019\u0001\u0000\u00019\u0001\u0000\u00039\u0003\u0000\u00019\u0001\u0000\u00019\u0002\u0000\n9\u0001\u0000\u00029\u0001v\u0001\u0000\u0003v\u0001w\u0001x\u0001\u0000\u0001;\u0002v\u0001;\u0010v\u0001;\u0001\u0000\u0005;\u0002\u0000\u0002;\u0001\u0000\u0010;\n\u0000\u0001y\u000f\u0000\u0001y\u0001\u0000\u0001>\u0001\u0000\u0004>\u0001@\u0001\u0000\u0001A\u0002>\u0001A\u0010>\u0005\u0000\u0001\u000f\u0016\u0000\u0001\u000f\u0001z\u0005\u000f\u0002z\u0002\u000f\u0001z\u0010\u000f\b\u0000\u0001C\u0002\u0000\u0001C\u0018\u0000\u0001E\u0002\u0000\u0001E\u0018\u0000\u0001G\u0002\u0000\u0001G\u0017\u0000\u0001F\u0001G\u0002\u0000\u0001G\u0010\u0000\u0005{\u0001\u0000\u0001{\u0001\u0000\u0001{\u0003\u0000\u0001{\u0002\u0000\n{\u0001\u0000\u0002{\u0001|\u0003J\u0001}\u0001J\u0001}\u0001\u0000\u0002J\u0001}\u0003J\u0001~\u0001J\u0001|\u0002J\u0003|\u0002J\u0001|\u0001J\u0001|\u0001J\u0007K\u0001L\u0014K\u0006\u0000\u0001\u007f\u001b\u0000\u0001\u007f\u000b\u0000\u0001O\r\u0000\u0003R\u0001S\u0001T\u0001\u0000\u0001R\u0001T\u0003\u0000\u0001V\u0002\u0000\u0005R\u0003\u0000\u0001R\t\u0000\u0001T\u0002\u0000\u0001T\u0014\u0000\u0003R\u0001S\u0001T\u0001\u0000\u0001U\u0001T\u0003\u0000\u0001V\u0002\u0000\u0001R\u0002U\u0002R\u0001W\u0002\u0000\u0001R\u0014\u0000\u0001\u0080\f\u0000\u0003R\u0003\u0000\u0001R\u0004\u0000\u0001V\u0002\u0000\u0005R\u0003\u0000\u0001R\u0004\u0000\u0004\u0081\u0002\u0000\u0002\u0081\u0004\u0000\u0001\u0082\u0002\u0000\u0006\u0081\u0001\u0000\u0002\u0081\t\u0000\u0001Z\u0002\u0000\u0001Z\u0017\u0000\u0001Y\u0001Z\u0002\u0000\u0001Z\u0010\u0000\u0001\\\u0001\u0000\u0001\\\u0001]\u0002\\\u0001^\u0001\u0000\u0001_\u0001]\u0001\\\u0001_\u0001\\\u0002]\n\\\u0001]\u0002\\\u0005\u0000\u0001\"\u0016\u0000\u0001\"\u0001\u0083\u0001\"\u0001\u0083\u0003\"\u0003\u0083\u0001\"\u0001\u0083\u0001\"\u0002\u0083\n\"\u0001\u0083\u0002\"\u0005\u0084\u0001\u0000\u0001\u0084\u0001\u0000\u0001\u0084\u0003\u0000\u0001\u0084\u0002\u0000\n\u0084\u0001\u0000\u0002\u0084\u0001\u0085\u0003a\u0001\u0086\u0001a\u0001\u0086\u0001\u0000\u0002a\u0001\u0086\u0003a\u0001\u0087\u0001a\u0001\u0085\u0002a\u0003\u0085\u0002a\u0001\u0085\u0001a\u0001\u0085\u0001a\u0001b\u0001\u0000\u0004b\u0001d\u0001\u0000\u0001e\u0002b\u0001e\u0010b\u0005\u0000\u0001(\u0016\u0000\u001cL\u0012\u0000\u0001P\t\u0000\u0001i\u0001\u0000\u0001i\u0001j\u0002i\u0001k\u0001\u0000\u0001l\u0001j\u0001i\u0001l\u0001i\u0002j\ni\u0001j\u0002i\u0005\u0000\u0001/\u001a\u0000\u0003n\u0003\u0000\u0001n\u0004\u0000\u0001p\u0002\u0000\u0005n\u0003\u0000\u0001n\u0005\u0000\u0003n\u0003\u0000\u0001o\u0004\u0000\u0001p\u0002\u0000\u0001n\u0002o\u0002n\u0001q\u0002\u0000\u0001n\u0014\u0000\u0001\u0088\u000b\u0000\u0004\u0089\u0002\u0000\u0002\u0089\u0004\u0000\u0001\u008a\u0002\u0000\u0006\u0089\u0001\u0000\u0002\u0089\u0001\u0000\u0001s\u0001\u0000\u0001s\u0001t\u0002s\u0001u\u0001\u0000\u00019\u0001t\u0001s\u00019\u0001s\u0002t\ns\u0001t\u0002s\u0005\u0000\u00019\u0016\u0000\u0001v\u0001\u0000\u0004v\u0001x\u0001\u0000\u0001;\u0002v\u0001;\u0010v\u0005\u0000\u0001;\u0016\u0000\u0001\u008b\u0003{\u0001\u008c\u0001\u0000\u0001d\u0001\u0000\u0001{\u0001\u0000\u0001\u008c\u0001{\u0002\u0000\u0001\u008d\u0001{\u0001\u008b\u0002{\u0003\u008b\u0002{\u0001\u008b\u0001\u0000\u0001\u008b\u0001{\u0001\u008e\u0001J\u0002\u008e\u0001\u008f\u0001\u0090\u0001}\u0001\u0000\u0001\u0091\u0001\u008e\u0001\u008f\u0001\u0091\u0002\u008e\u0001\u0092\r\u008e\u0001|\u0001J\u0002|\u0001\u008f\u0001|\u0001\u008f\u0001\u0000\u0001J\u0001|\u0001\u008f\u0001J\u0002|\u0001\u0093\r|\u0001(\u0003\u0000\u0001d\u0001\u0000\u0001d\u0003\u0000\u0001d\u0005\u0000\u0001(\u0002\u0000\u0003(\u0002\u0000\u0001(\u0001\u0000\u0001(\u0014\u0000\u0001R\u000b\u0000\u0004\u0081\u0002\u0000\u0002\u0081\u0001\u0000\u0001\u0094\u0002\u0000\u0001\u0082\u0002\u0000\u0006\u0081\u0001\u0000\u0002\u0081\u0014\u0000\u0001\u0095\b\u0000\u0001\u0096\u0003\u0084\u0001\u0097\u0001\u0000\u0001k\u0001\u0000\u0001\u0084\u0001\u0000\u0001\u0097\u0001\u0084\u0002\u0000\u0001\u0098\u0001\u0084\u0001\u0096\u0002\u0084\u0003\u0096\u0002\u0084\u0001\u0096\u0001\u0000\u0001\u0096\u0001\u0084\u0001\u0099\u0001a\u0001\u0099\u0001\u009a\u0001\u009b\u0001\u009a\u0001\u0086\u0001\u0000\u0001\u009c\u0001\u009a\u0001\u009b\u0001\u009c\u0001\u0099\u0001\u009a\u0001\u009d\n\u0099\u0001\u009a\u0002\u0099\u0001\u0085\u0001a\u0001\u0085\u0001a\u0001\u009b\u0001\u0085\u0001\u009b\u0001\u0000\u0002a\u0001\u009b\u0001a\u0001\u0085\u0001a\u0001\u0087\n\u0085\u0001a\u0002\u0085\u0001/\u0003\u0000\u0001k\u0001\u0000\u0001k\u0003\u0000\u0001k\u0005\u0000\u0001/\u0002\u0000\u0003/\u0002\u0000\u0001/\u0001\u0000\u0001/\u0014\u0000\u0001n\u000b\u0000\u0004\u0089\u0002\u0000\u0002\u0089\u0001\u0000\u0001y\u0002\u0000\u0001\u008a\u0002\u0000\u0006\u0089\u0001\u0000\u0002\u0089\u0014\u0000\u0001\u009e\b\u0000\u0001\u009f\u0001{\u0002\u009f\u0001\u00a0\u0001c\u0001d\u0001\u0000\u0001\u00a1\u0001b\u0001\u00a0\u0001\u00a1\u0002b\u0001\u00a2\n\u009f\u0001b\u0002\u009f\u0001\u008b\u0001{\u0002\u008b\u0001\u00a0\u0001(\u0001\u00a3\u0001\u0000\u0001{\u0001(\u0001\u00a0\u0001{\u0002(\u0001\u00a4\n\u008b\u0001(\u0002\u008b\u0001(\u0003\u0000\u0001d\u0001\u0000\u0001d\u0003\u0000\u0001d\u0003\u0000\u0001~\u0001\u0000\u0001(\u0002\u0000\u0003(\u0002\u0000\u0001(\u0001\u0000\u0001(\u0001\u0000\u0001\u008e\u0001J\u0002\u008e\u0001\u008f\u0001\u008e\u0001}\u0001\u0000\u0001\u0091\u0001\u008e\u0001\u008f\u0001\u0091\u0002\u008e\u0001\u0092\u000e\u008e\u0001J\u0002\u008e\u0001\u008f\u0001\u008e\u0001\u008f\u0001\u0000\u0001\u0091\u0001\u008e\u0001\u008f\u0001\u0091\u0002\u008e\u0001\u0092\r\u008e\u0001|\u0003J\u0001}\u0001|\u0001}\u0001\u0000\u0002J\u0001}\u0003J\u0001~\u0001J\u0001|\u0002J\u0003|\u0002J\u0001|\u0001J\u0001|\u0001J\u0001b\u0001\u0000\u0002b\u0001\u00a3\u0001b\u0001d\u0001\u0000\u0001e\u0001b\u0001\u00a3\u0001e\u0011b\u0001\u0000\u0002b\u0001\u00a3\u0001c\u0001d\u0001\u0000\u0001e\u0001b\u0001\u00a3\u0001e\u0010b\u0007\u0000\u0001S\u0001T\u0002\u0000\u0001T#\u0000\u0001\u0081\b\u0000\u0001\u00a5\u0001\u0084\u0001\u00a5\u0001\u00a6\u0001\u00a7\u0001j\u0001k\u0001\u0000\u0001\u00a8\u0001j\u0001\u00a7\u0001\u00a8\u0001i\u0001j\u0001\u00a9\n\u00a5\u0001j\u0002\u00a5\u0001\u0096\u0001\u0084\u0001\u0096\u0001\u0084\u0001\u00a7\u0001/\u0001\u00aa\u0001\u0000\u0001\u0084\u0001\u0000\u0001\u00a7\u0001\u0084\u0001/\u0001\u0000\u0001\u0098\n\u0096\u0001\u0000\u0002\u0096\u0001/\u0003\u0000\u0001k\u0001\u0000\u0001k\u0003\u0000\u0001k\u0003\u0000\u0001\u0087\u0001\u0000\u0001/\u0002\u0000\u0003/\u0002\u0000\u0001/\u0001\u0000\u0001/\u0001\u0000\u0001\u0099\u0001a\u0001\u0099\u0001\u009a\u0001\u009b\u0001\u0099\u0001\u0086\u0001\u0000\u0001\u009c\u0001\u009a\u0001\u009b\u0001\u009c\u0001\u0099\u0001\u009a\u0001\u009d\n\u0099\u0001\u009a\u0002\u0099\u0001\u0085\u0003a\u0001\u0086\u0001\u0085\u0001\u0086\u0001\u0000\u0002a\u0001\u0086\u0003a\u0001\u0087\u0001a\u0001\u0085\u0002a\u0003\u0085\u0002a\u0001\u0085\u0001a\u0001\u0085\u0001a\u0001\u0099\u0001a\u0001\u0099\u0001\u009a\u0001\u009b\u0001\u0099\u0001\u009b\u0001\u0000\u0001\u009c\u0001\u009a\u0001\u009b\u0001\u009c\u0001\u0099\u0001\u009a\u0001\u009d\n\u0099\u0001\u009a\u0002\u0099\u0001/\u0003\u0000\u0001k\u0001/\u0001k\u0003\u0000\u0001k\u0005\u0000\u0001/\u0002\u0000\u0003/\u0002\u0000\u0001/\u0001\u0000\u0001/\u0014\u0000\u0001\u0089\b\u0000\u0001\u009f\u0001{\u0002\u009f\u0001\u00a0\u0001b\u0001d\u0001\u0000\u0001\u00a1\u0001b\u0001\u00a0\u0001\u00a1\u0002b\u0001\u00a2\n\u009f\u0001b\u0003\u009f\u0001{\u0002\u009f\u0001\u00a0\u0001b\u0001\u00a3\u0001\u0000\u0001\u00a1\u0001b\u0001\u00a0\u0001\u00a1\u0002b\u0001\u00a2\n\u009f\u0001b\u0002\u009f\u0001b\u0001\u0000\u0002b\u0001\u00a3\u0001b\u0001d\u0001\u0000\u0001e\u0001b\u0001\u00a3\u0001e\u0002b\u0001\u0092\u000eb\u0001\u0000\u0004b\u0001\u00a3\u0001\u0000\u0001e\u0002b\u0001e\u0011b\u0001\u0000\u0002b\u0001\u00a3\u0001c\u0001d\u0001\u0000\u0001e\u0001b\u0001\u00a3\u0001e\u0002b\u0001\u0092\rb\u0001\u00a5\u0001\u0084\u0001\u00a5\u0001\u00a6\u0001\u00a7\u0001i\u0001k\u0001\u0000\u0001\u00a8\u0001j\u0001\u00a7\u0001\u00a8\u0001i\u0001j\u0001\u00a9\n\u00a5\u0001j\u0002\u00a5\u0001\u0096\u0003\u0084\u0001\u0097\u0001/\u0001k\u0001\u0000\u0001\u0084\u0001\u0000\u0001\u0097\u0001\u0084\u0002\u0000\u0001\u0098\u0001\u0084\u0001\u0096\u0002\u0084\u0003\u0096\u0002\u0084\u0001\u0096\u0001\u0000\u0001\u0096\u0001\u0084\u0001\u00a5\u0001\u0084\u0001\u00a5\u0001\u00a6\u0001\u00a7\u0001i\u0001\u00aa\u0001\u0000\u0001\u00a8\u0001j\u0001\u00a7\u0001\u00a8\u0001i\u0001j\u0001\u00a9\n\u00a5\u0001j\u0002\u00a5\u0001/\u0003\u0000\u0001k\u0001/\u0001k\u0003\u0000\u0001k\u0003\u0000\u0001\u0087\u0001\u0000\u0001/\u0002\u0000\u0003/\u0002\u0000\u0001/\u0001\u0000\u0001/\u0001\u0000\u0001i\u0001\u0000\u0001i\u0001j\u0002i\u0001\u00aa\u0001\u0000\u0001l\u0001j\u0001i\u0001l\u0001i\u0002j\ni\u0001j\u0002i";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _YAMLLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u000e\u0000\u0001\u0001\u0002\t\u0003\u0001\u0001\t\u0001\u0001\u0001\t\u0003\u0001\u0001\t\u0004\u0001\u0001\t\u0013\u0001\u0001\t\u0002\u0001\u0001\t\u0001\u0001\u0004\u0000\u0002\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0006\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0001\t\u0001\u0001\u0004\u0000\u0001\t\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0003\u0000\u0001\u0001\u0004\u0000\u0001\t\u0002\u0001\u0003\u0000\u0001\t\u0002\u0001\u0005\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0002\t\u0001\u0000\u0001\u0001\u0002\u0000\u0001\t\u0003\u0000\u0001\t\u0001\u0000\u0001\u0001\u0005\u0000\u0001\u0001\u0002\u0000\u0002\u0001\u0002\u0000\u0002\u0001\u0002\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0003\u0000\u0002\u0001\u0001\u0000\u0004\u0001\u0001\u0000\u0001\u0001\u0002\u0000\u0001\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private boolean[] zzFin = new boolean[16385];
    private int currentLineIndent = 0;
    private int valueIndent = -1;
    private int braceCount = 0;
    private IElementType valueTokenType = null;
    private int previousState = 0;

    public static int ZZ_CMAP(int ch) {
        return ZZ_CMAP_A[ZZ_CMAP_Y[ZZ_CMAP_Z[ch >> 12] << 6 | ch >> 6 & 0x3F] << 6 | ch & 0x3F];
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[170];
        int offset = 0;
        offset = _YAMLLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[170];
        int offset = 0;
        offset = _YAMLLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[3696];
        int offset = 0;
        offset = _YAMLLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[170];
        int offset = 0;
        offset = _YAMLLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public boolean isCleanState() {
        return this.yystate() == 0 && this.currentLineIndent == 0 && this.braceCount == 0;
    }

    public void cleanMyState() {
        this.currentLineIndent = 0;
        this.braceCount = 0;
    }

    private char previousChar() {
        return this.getChar(-1);
    }

    private char getChar(int offset) {
        int loc = this.getTokenStart() + offset;
        return 0 <= loc && loc < this.zzBuffer.length() ? this.zzBuffer.charAt(loc) : (char)'\uffff';
    }

    private char getCharAfter(int offset) {
        int loc = this.getTokenEnd() + offset;
        return 0 <= loc && loc < this.zzBuffer.length() ? this.zzBuffer.charAt(loc) : (char)'\uffff';
    }

    private IElementType getWhitespaceTypeAndUpdateIndent() {
        if (this.isAfterEol()) {
            this.currentLineIndent = this.yylength();
            return INDENT;
        }
        return WHITESPACE;
    }

    private boolean isAfterEol() {
        char prev = this.previousChar();
        return prev == '\uffff' || prev == '\n';
    }

    private boolean isAfterSpace() {
        char prev = this.previousChar();
        return prev == '\uffff' || prev == '\t' || prev == ' ';
    }

    private void yyBegin(int newState) {
        this.yybegin(newState);
    }

    private boolean startsWith(CharSequence haystack, CharSequence needle) {
        for (int i = Math.min(haystack.length(), needle.length()) - 1; i >= 0; --i) {
            if (haystack.charAt(i) == needle.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private IElementType tokenOrForbidden(IElementType tokenType) {
        if (!this.isAfterEol() || this.yylength() < 3) {
            return tokenType;
        }
        if (this.startsWith(this.yytext(), "---")) {
            this.braceCount = 0;
            this.yyBegin(0);
            this.yypushback(this.yylength() - 3);
            return DOCUMENT_MARKER;
        }
        if (this.startsWith(this.yytext(), "...")) {
            this.braceCount = 0;
            this.yyBegin(0);
            this.yypushback(this.yylength() - 3);
            return DOCUMENT_END;
        }
        return tokenType;
    }

    public _YAMLLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        int size = 0;
        int length = packed.length();
        for (int i = 0; i < length; i += 2) {
            size += packed.charAt(i);
        }
        char[] map = new char[size];
        int i = 0;
        int j = 0;
        while (i < packed.length()) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block54: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + _YAMLLexer.ZZ_CMAP(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return this.tokenOrForbidden(TEXT);
                }
                case 27: {
                    continue block54;
                }
                case 2: {
                    return TEXT;
                }
                case 28: {
                    continue block54;
                }
                case 3: {
                    if (this.braceCount > 0) {
                        this.yyBegin(2);
                        return COMMA;
                    }
                    this.yyBegin(4);
                    return TEXT;
                }
                case 29: {
                    continue block54;
                }
                case 4: {
                    return QUESTION;
                }
                case 30: {
                    continue block54;
                }
                case 5: {
                    return this.isAfterEol() || this.isAfterSpace() ? COMMENT : TEXT;
                }
                case 31: {
                    continue block54;
                }
                case 6: {
                    if (this.braceCount == 0) {
                        this.yyBegin(0);
                    }
                    this.currentLineIndent = 0;
                    return EOL;
                }
                case 32: {
                    continue block54;
                }
                case 7: {
                    return this.getWhitespaceTypeAndUpdateIndent();
                }
                case 33: {
                    continue block54;
                }
                case 8: {
                    if (this.braceCount == 0) {
                        this.yyBegin(4);
                        return TEXT;
                    }
                    --this.braceCount;
                    if (this.yystate() == 2 && this.braceCount == 0) {
                        this.yyBegin(this.previousState);
                    }
                    return RBRACKET;
                }
                case 34: {
                    continue block54;
                }
                case 9: {
                    ++this.braceCount;
                    if (this.braceCount != 0 && this.yystate() != 2) {
                        this.previousState = this.yystate();
                    }
                    this.yyBegin(this.braceCount == 0 ? this.previousState : 2);
                    return LBRACE;
                }
                case 35: {
                    continue block54;
                }
                case 10: {
                    if (this.braceCount == 0) {
                        this.yyBegin(4);
                        return TEXT;
                    }
                    --this.braceCount;
                    if (this.yystate() == 2 && this.braceCount == 0) {
                        this.yyBegin(this.previousState);
                    }
                    return RBRACE;
                }
                case 36: {
                    continue block54;
                }
                case 11: {
                    ++this.braceCount;
                    if (this.braceCount != 0 && this.yystate() != 2) {
                        this.previousState = this.yystate();
                    }
                    this.yyBegin(this.braceCount == 0 ? this.previousState : 2);
                    return LBRACKET;
                }
                case 37: {
                    continue block54;
                }
                case 12: {
                    if (this.currentLineIndent <= this.valueIndent) {
                        this.yypushback(this.yylength());
                        this.yyBegin(0);
                        continue block54;
                    }
                    return this.valueTokenType;
                }
                case 38: {
                    continue block54;
                }
                case 13: {
                    this.currentLineIndent = 0;
                    return EOL;
                }
                case 39: {
                    continue block54;
                }
                case 14: {
                    IElementType type = this.getWhitespaceTypeAndUpdateIndent();
                    if (this.currentLineIndent <= this.valueIndent) {
                        this.yyBegin(0);
                    }
                    return type;
                }
                case 40: {
                    continue block54;
                }
                case 15: {
                    if (this.zzMarkedPos == this.zzEndRead) {
                        return SCALAR_KEY;
                    }
                    this.yyBegin(4);
                    return this.tokenOrForbidden(TEXT);
                }
                case 41: {
                    continue block54;
                }
                case 16: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    return COLON;
                }
                case 42: {
                    continue block54;
                }
                case 17: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    this.yyBegin(6);
                    return SEQUENCE_MARKER;
                }
                case 43: {
                    continue block54;
                }
                case 18: {
                    int zzFState = 12;
                    int zzFPos = this.zzStartRead;
                    if (this.zzFin.length <= zzBufferL.length()) {
                        this.zzFin = new boolean[zzBufferL.length() + 1];
                    }
                    boolean[] zzFinL = this.zzFin;
                    while (zzFState != -1 && zzFPos < this.zzMarkedPos) {
                        zzFinL[zzFPos] = (zzAttrL[zzFState] & 1) == 1;
                        zzInput = Character.codePointAt(zzBufferL, zzFPos);
                        zzFPos += Character.charCount(zzInput);
                        zzFState = zzTransL[zzRowMapL[zzFState] + _YAMLLexer.ZZ_CMAP(zzInput)];
                    }
                    if (zzFState != -1) {
                        boolean bl = zzFinL[zzFPos++] = (zzAttrL[zzFState] & 1) == 1;
                    }
                    while (zzFPos <= this.zzMarkedPos) {
                        zzFinL[zzFPos++] = false;
                    }
                    zzFState = 7;
                    zzFPos = this.zzMarkedPos;
                    while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                        zzInput = Character.codePointBefore(zzBufferL, zzFPos);
                        zzFPos -= Character.charCount(zzInput);
                        zzFState = zzTransL[zzRowMapL[zzFState] + _YAMLLexer.ZZ_CMAP(zzInput)];
                    }
                    this.zzMarkedPos = zzFPos;
                    this.yyBegin(10);
                    this.valueIndent = this.currentLineIndent;
                    this.valueTokenType = SCALAR_TEXT;
                    return this.valueTokenType;
                }
                case 44: {
                    continue block54;
                }
                case 19: {
                    return SCALAR_DSTRING;
                }
                case 45: {
                    continue block54;
                }
                case 20: {
                    return SCALAR_STRING;
                }
                case 46: {
                    continue block54;
                }
                case 21: {
                    int zzFState = 6;
                    int zzFPos = this.zzStartRead;
                    if (this.zzFin.length <= zzBufferL.length()) {
                        this.zzFin = new boolean[zzBufferL.length() + 1];
                    }
                    boolean[] zzFinL = this.zzFin;
                    while (zzFState != -1 && zzFPos < this.zzMarkedPos) {
                        zzFinL[zzFPos] = (zzAttrL[zzFState] & 1) == 1;
                        zzInput = Character.codePointAt(zzBufferL, zzFPos);
                        zzFPos += Character.charCount(zzInput);
                        zzFState = zzTransL[zzRowMapL[zzFState] + _YAMLLexer.ZZ_CMAP(zzInput)];
                    }
                    if (zzFState != -1) {
                        boolean bl = zzFinL[zzFPos++] = (zzAttrL[zzFState] & 1) == 1;
                    }
                    while (zzFPos <= this.zzMarkedPos) {
                        zzFinL[zzFPos++] = false;
                    }
                    zzFState = 7;
                    zzFPos = this.zzMarkedPos;
                    while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                        zzInput = Character.codePointBefore(zzBufferL, zzFPos);
                        zzFPos -= Character.charCount(zzInput);
                        zzFState = zzTransL[zzRowMapL[zzFState] + _YAMLLexer.ZZ_CMAP(zzInput)];
                    }
                    this.zzMarkedPos = zzFPos;
                    return TAG;
                }
                case 47: {
                    continue block54;
                }
                case 22: {
                    int zzFState = 13;
                    int zzFPos = this.zzStartRead;
                    if (this.zzFin.length <= zzBufferL.length()) {
                        this.zzFin = new boolean[zzBufferL.length() + 1];
                    }
                    boolean[] zzFinL = this.zzFin;
                    while (zzFState != -1 && zzFPos < this.zzMarkedPos) {
                        zzFinL[zzFPos] = (zzAttrL[zzFState] & 1) == 1;
                        zzInput = Character.codePointAt(zzBufferL, zzFPos);
                        zzFPos += Character.charCount(zzInput);
                        zzFState = zzTransL[zzRowMapL[zzFState] + _YAMLLexer.ZZ_CMAP(zzInput)];
                    }
                    if (zzFState != -1) {
                        boolean bl = zzFinL[zzFPos++] = (zzAttrL[zzFState] & 1) == 1;
                    }
                    while (zzFPos <= this.zzMarkedPos) {
                        zzFinL[zzFPos++] = false;
                    }
                    zzFState = 7;
                    zzFPos = this.zzMarkedPos;
                    while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                        zzInput = Character.codePointBefore(zzBufferL, zzFPos);
                        zzFPos -= Character.charCount(zzInput);
                        zzFState = zzTransL[zzRowMapL[zzFState] + _YAMLLexer.ZZ_CMAP(zzInput)];
                    }
                    this.zzMarkedPos = zzFPos;
                    this.yyBegin(10);
                    this.valueIndent = this.currentLineIndent;
                    this.valueTokenType = SCALAR_LIST;
                    return this.valueTokenType;
                }
                case 48: {
                    continue block54;
                }
                case 23: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzMarkedPos, -1);
                    return this.getWhitespaceTypeAndUpdateIndent();
                }
                case 49: {
                    continue block54;
                }
                case 24: {
                    int zzFState = 10;
                    int zzFPos = this.zzStartRead;
                    if (this.zzFin.length <= zzBufferL.length()) {
                        this.zzFin = new boolean[zzBufferL.length() + 1];
                    }
                    boolean[] zzFinL = this.zzFin;
                    while (zzFState != -1 && zzFPos < this.zzMarkedPos) {
                        zzFinL[zzFPos] = (zzAttrL[zzFState] & 1) == 1;
                        zzInput = Character.codePointAt(zzBufferL, zzFPos);
                        zzFPos += Character.charCount(zzInput);
                        zzFState = zzTransL[zzRowMapL[zzFState] + _YAMLLexer.ZZ_CMAP(zzInput)];
                    }
                    if (zzFState != -1) {
                        boolean bl = zzFinL[zzFPos++] = (zzAttrL[zzFState] & 1) == 1;
                    }
                    while (zzFPos <= this.zzMarkedPos) {
                        zzFinL[zzFPos++] = false;
                    }
                    zzFState = 11;
                    zzFPos = this.zzMarkedPos;
                    while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                        zzInput = Character.codePointBefore(zzBufferL, zzFPos);
                        zzFPos -= Character.charCount(zzInput);
                        zzFState = zzTransL[zzRowMapL[zzFState] + _YAMLLexer.ZZ_CMAP(zzInput)];
                    }
                    this.zzMarkedPos = zzFPos;
                    this.yyBegin(4);
                    return SCALAR_KEY;
                }
                case 50: {
                    continue block54;
                }
                case 25: {
                    return SCALAR_KEY;
                }
                case 51: {
                    continue block54;
                }
                case 26: {
                    int zzFState = 8;
                    int zzFPos = this.zzStartRead;
                    if (this.zzFin.length <= zzBufferL.length()) {
                        this.zzFin = new boolean[zzBufferL.length() + 1];
                    }
                    boolean[] zzFinL = this.zzFin;
                    while (zzFState != -1 && zzFPos < this.zzMarkedPos) {
                        zzFinL[zzFPos] = (zzAttrL[zzFState] & 1) == 1;
                        zzInput = Character.codePointAt(zzBufferL, zzFPos);
                        zzFPos += Character.charCount(zzInput);
                        zzFState = zzTransL[zzRowMapL[zzFState] + _YAMLLexer.ZZ_CMAP(zzInput)];
                    }
                    if (zzFState != -1) {
                        boolean bl = zzFinL[zzFPos++] = (zzAttrL[zzFState] & 1) == 1;
                    }
                    while (zzFPos <= this.zzMarkedPos) {
                        zzFinL[zzFPos++] = false;
                    }
                    zzFState = 9;
                    zzFPos = this.zzMarkedPos;
                    while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                        zzInput = Character.codePointBefore(zzBufferL, zzFPos);
                        zzFPos -= Character.charCount(zzInput);
                        zzFState = zzTransL[zzRowMapL[zzFState] + _YAMLLexer.ZZ_CMAP(zzInput)];
                    }
                    this.zzMarkedPos = zzFPos;
                    this.yyBegin(8);
                    return SCALAR_KEY;
                }
                case 52: {
                    continue block54;
                }
            }
            this.zzScanError(1);
        }
    }
}

