/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.atomic;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.Objects;

public class ModifyFxControllerJob
extends Job {
    private final FXOMObject fxomObject;
    private final String newValue;
    private final String oldValue;

    public ModifyFxControllerJob(FXOMObject fxomObject, String newValue, EditorController editorController) {
        super(editorController);
        assert (fxomObject != null);
        this.fxomObject = fxomObject;
        this.newValue = newValue;
        this.oldValue = fxomObject.getFxController();
    }

    @Override
    public boolean isExecutable() {
        return !Objects.equals(this.oldValue, this.newValue);
    }

    @Override
    public void execute() {
        this.redo();
    }

    @Override
    public void undo() {
        this.getEditorController().getFxomDocument().beginUpdate();
        this.fxomObject.setFxController(this.oldValue);
        this.getEditorController().getFxomDocument().endUpdate();
        assert (Objects.equals(this.fxomObject.getFxController(), this.oldValue));
    }

    @Override
    public void redo() {
        this.getEditorController().getFxomDocument().beginUpdate();
        this.fxomObject.setFxController(this.newValue);
        this.getEditorController().getFxomDocument().endUpdate();
        assert (Objects.equals(this.fxomObject.getFxController(), this.newValue));
    }

    @Override
    public String getDescription() {
        StringBuilder result = new StringBuilder();
        result.append("Set controller class on ");
        result.append(this.fxomObject.getGlueElement().getTagName());
        return result.toString();
    }
}

