/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.reference;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemoveNodeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemoveObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.reference.CombineReferenceJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import java.util.LinkedList;
import java.util.List;

public class ObjectDeleter {
    private final EditorController editorController;
    private final FXOMDocument fxomDocument;
    private final List<Job> executedJobs = new LinkedList<Job>();

    public ObjectDeleter(EditorController editorController) {
        assert (editorController != null);
        assert (editorController.getFxomDocument() != null);
        this.editorController = editorController;
        this.fxomDocument = editorController.getFxomDocument();
    }

    public void delete(FXOMObject target) {
        FXOMNode node = this.prepareDeleteObject(target, target);
        if (node == target) {
            RemoveObjectJob removeJob = new RemoveObjectJob(target, this.editorController);
            removeJob.execute();
            this.executedJobs.add(removeJob);
        }
    }

    public void prepareDelete(FXOMObject target) {
        assert (target != null);
        assert (target.getFxomDocument() == this.fxomDocument);
        assert (this.fxomDocument.getFxomRoot() != null);
        this.prepareDeleteObject(target, target);
    }

    public List<Job> getExecutedJobs() {
        return new LinkedList<Job>(this.executedJobs);
    }

    private FXOMNode prepareDeleteObject(FXOMObject node, FXOMObject target) {
        FXOMObject result;
        block11: {
            block12: {
                String nodeFxId = node.getFxId();
                if (nodeFxId == null) {
                    result = node;
                } else {
                    FXOMObject fxomRoot = this.fxomDocument.getFxomRoot();
                    List<FXOMNode> references = fxomRoot.collectReferences(nodeFxId, target);
                    if (references.isEmpty()) {
                        result = node;
                    } else {
                        FXOMNode firstReference = null;
                        for (FXOMNode r : references) {
                            if (FXOMNodes.isWeakReference(r)) {
                                RemoveNodeJob clearJob = new RemoveNodeJob(r, this.editorController);
                                ((Job)clearJob).execute();
                                this.executedJobs.add(clearJob);
                                continue;
                            }
                            firstReference = r;
                            break;
                        }
                        if (firstReference == null) {
                            result = node;
                        } else {
                            CombineReferenceJob combineJob = new CombineReferenceJob(firstReference, this.editorController);
                            ((Job)combineJob).execute();
                            this.executedJobs.add(combineJob);
                            result = null;
                        }
                    }
                }
                if (result != node) break block11;
                if (!(node instanceof FXOMInstance)) break block12;
                FXOMInstance fxomInstance = (FXOMInstance)node;
                for (FXOMProperty p : new LinkedList<FXOMProperty>(fxomInstance.getProperties().values())) {
                    if (!(p instanceof FXOMPropertyC)) continue;
                    FXOMPropertyC cp = (FXOMPropertyC)p;
                    for (FXOMObject value : new LinkedList<FXOMObject>(cp.getValues())) {
                        this.prepareDeleteObject(value, target);
                    }
                }
                break block11;
            }
            if (!(result instanceof FXOMCollection)) break block11;
            FXOMCollection fxomCollection = (FXOMCollection)result;
            for (FXOMObject i : new LinkedList<FXOMObject>(fxomCollection.getItems())) {
                this.prepareDeleteObject(i, target);
            }
        }
        return result;
    }
}

