/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.util.JavaLanguage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class EventHandlerEditor
extends AutoSuggestEditor {
    private static final String HASH_STR = "#";
    private final MenuItem controllerMethodMenuItem = new MenuItem(I18N.getString("inspector.event.menu.methodmode"));
    private final MenuItem scriptMenuItem = new MenuItem(I18N.getString("inspector.event.menu.scriptmode"));
    private boolean methodNameMode;
    private StackPane root = new StackPane();
    private HBox hbox = null;
    private List<String> suggestedMethods;

    public EventHandlerEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, List<String> suggestedMethods) {
        super(propMeta, selectedClasses, suggestedMethods);
        this.initialize(suggestedMethods);
    }

    private void initialize(List<String> suggestedMethods) {
        this.suggestedMethods = suggestedMethods;
        EventHandler onActionListener = event -> {
            String tfValue = this.getTextField().getText();
            if (tfValue == null || tfValue.isEmpty()) {
                this.userUpdateValueProperty(null);
                return;
            }
            if (this.methodNameMode && !JavaLanguage.isIdentifier(tfValue)) {
                System.err.println(I18N.getString("inspector.event.invalid.method", tfValue));
                this.handleInvalidValue(tfValue);
                return;
            }
            Object value = this.getValue();
            assert (value instanceof String);
            this.userUpdateValueProperty((String)value);
            this.getTextField().selectAll();
        };
        this.setTextEditorBehavior(this, (Control)this.getTextField(), (EventHandler<ActionEvent>)onActionListener);
        this.scriptMenuItem.setOnAction(e -> {
            this.getTextField().setText(null);
            this.userUpdateValueProperty(null);
            this.switchToScriptMode();
        });
        this.controllerMethodMenuItem.setOnAction(e -> {
            this.getTextField().setText(null);
            this.userUpdateValueProperty(null);
            this.switchToMethodNameMode();
        });
        this.getMenu().getItems().add((Object)this.controllerMethodMenuItem);
        this.switchToMethodNameMode();
    }

    @Override
    public Object getValue() {
        String valueTf = this.getTextField().getText();
        if (valueTf == null || valueTf.isEmpty()) {
            return null;
        }
        String value = this.methodNameMode ? HASH_STR + this.getTextField().getText() : this.getTextField().getText();
        return value;
    }

    @Override
    public void setValue(Object value) {
        String valueStr;
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value == null) {
            if (!this.methodNameMode) {
                this.switchToMethodNameMode();
            }
            valueStr = null;
        } else {
            assert (value instanceof String);
            valueStr = (String)value;
            if (valueStr.startsWith(HASH_STR)) {
                if (!this.methodNameMode) {
                    this.switchToMethodNameMode();
                }
                valueStr = valueStr.substring(1);
            } else if (!valueStr.startsWith(HASH_STR) && this.methodNameMode) {
                this.switchToScriptMode();
            }
        }
        this.getTextField().setText(valueStr);
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.root);
    }

    @Override
    public void reset(String name, String defaultValue, List<String> suggestedList) {
        super.reset(name, defaultValue, suggestedList);
        this.switchToMethodNameMode();
    }

    private void wrapInHBox() {
        this.hbox = new HBox();
        this.hbox.setAlignment(Pos.CENTER);
        Label hashLabel = new Label(HASH_STR);
        hashLabel.getStyleClass().add((Object)"symbol-prefix");
        this.hbox.getChildren().addAll((Object[])new Node[]{hashLabel, this.getRoot()});
        HBox.setHgrow((Node)hashLabel, (Priority)Priority.NEVER);
        this.root.getChildren().clear();
        this.root.getChildren().add((Object)this.hbox);
    }

    private void unwrapHBox() {
        this.root.getChildren().clear();
        this.root.getChildren().add((Object)this.getRoot());
    }

    private void switchToMethodNameMode() {
        this.methodNameMode = true;
        this.resetSuggestedList(this.suggestedMethods);
        this.replaceMenuItem(this.controllerMethodMenuItem, this.scriptMenuItem);
        this.wrapInHBox();
    }

    private void switchToScriptMode() {
        this.methodNameMode = false;
        this.resetSuggestedList(new ArrayList<String>());
        this.replaceMenuItem(this.scriptMenuItem, this.controllerMethodMenuItem);
        this.unwrapHBox();
    }
}

