/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.glossary;

import com.oracle.javafx.scenebuilder.kit.glossary.ControllerClass;
import com.oracle.javafx.scenebuilder.kit.glossary.Glossary;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BuiltinGlossary
extends Glossary {
    @Override
    public List<String> queryControllerClasses(URL fxmlLocation) {
        if (fxmlLocation == null) {
            return Collections.emptyList();
        }
        File fxmlFile = this.getFileFromURL(fxmlLocation);
        if (!fxmlFile.exists()) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (ControllerClass cc : ControllerClass.discoverFXMLControllerClasses(fxmlFile)) {
            if (res.contains(cc.getClassName())) continue;
            res.add(cc.getClassName());
        }
        Collections.sort(res);
        return res;
    }

    @Override
    public List<String> queryFxIds(URL fxmlLocation, String controllerClass, Class<?> targetType) {
        assert (controllerClass != null);
        if (fxmlLocation == null) {
            return Collections.emptyList();
        }
        File fxmlFile = this.getFileFromURL(fxmlLocation);
        if (!fxmlFile.exists()) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (ControllerClass cc : ControllerClass.discoverFXMLControllerClasses(fxmlFile)) {
            if (!controllerClass.equals(cc.getClassName())) continue;
            res.addAll(cc.getFxIds());
            break;
        }
        Collections.sort(res);
        return res;
    }

    @Override
    public List<String> queryEventHandlers(URL fxmlLocation, String controllerClass) {
        assert (controllerClass != null);
        if (fxmlLocation == null) {
            return Collections.emptyList();
        }
        File fxmlFile = this.getFileFromURL(fxmlLocation);
        if (!fxmlFile.exists()) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (ControllerClass cc : ControllerClass.discoverFXMLControllerClasses(fxmlFile)) {
            if (!controllerClass.equals(cc.getClassName())) continue;
            res.addAll(cc.getEventHandlers());
            break;
        }
        Collections.sort(res);
        return res;
    }

    private File getFileFromURL(URL location) {
        File res;
        try {
            res = new File(location.toURI());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Bug", ex);
        }
        return res;
    }
}

