/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class JavaLanguage {
    private static Set<String> keywords;

    public static boolean isIdentifier(String value) {
        return JavaLanguage.isIdentifierChars(value) && !JavaLanguage.isKeyword(value) && !JavaLanguage.isBooleanLiteral(value) && !JavaLanguage.isNullLiteral(value);
    }

    public static boolean isClassName(String value) {
        boolean result;
        if (value == null) {
            result = false;
        } else {
            result = true;
            for (String item : value.split("\\.")) {
                if (JavaLanguage.isIdentifier(item)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private static boolean isIdentifierChars(String value) {
        int codePoint;
        if (value == null || value.isEmpty() || !Character.isJavaIdentifierStart(value.codePointAt(0))) {
            return false;
        }
        for (int i = 0; i < value.length(); i += Character.charCount(codePoint)) {
            codePoint = value.codePointAt(i);
            if (Character.isJavaIdentifierPart(codePoint)) continue;
            return false;
        }
        return true;
    }

    private static synchronized boolean isKeyword(String value) {
        if (keywords == null) {
            keywords = new HashSet<String>();
            Collections.addAll(keywords, "abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");
        }
        return keywords.contains(value);
    }

    private static boolean isBooleanLiteral(String value) {
        return value.equals("true") || value.equals("false");
    }

    private static boolean isNullLiteral(String value) {
        return value.equals("null");
    }
}

