/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HgRepositoryFiles {
    private static final String BRANCHHEADS = "cache/branch";
    private static final String BRANCHEADSDIR = "cache";
    private static final String MERGE = "merge";
    private static final String REBASE = "rebase";
    private static final String BRANCH = "branch";
    private static final String DIRSTATE = "dirstate";
    private static final String BOOKMARKS = "bookmarks";
    private static final String LOCAL_TAGS = "localtags";
    private static final String TAGS = ".hgtags";
    private static final String CURRENT_BOOKMARK = "bookmarks.current";
    private static final String MQDIR = "patches";
    private static final String CONFIG_HGRC = "hgrc";
    @NotNull
    private final String myBranchHeadsPath;
    @NotNull
    private final String myBranchHeadsDirPath;
    @NotNull
    private final String myMergePath;
    @NotNull
    private final String myRebasePath;
    @NotNull
    private final String myBranchPath;
    @NotNull
    private final String myDirstatePath;
    @NotNull
    private final String myBookmarksPath;
    @NotNull
    private final String myTagsPath;
    @NotNull
    private final String myLocalTagsPath;
    @NotNull
    private final String myCurrentBookmarkPath;
    @NotNull
    private final String myMQDirPath;
    @NotNull
    private final String myConfigHgrcPath;

    @NotNull
    public static HgRepositoryFiles getInstance(@NotNull VirtualFile hgDir) {
        if (hgDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgDir", "org/zmlx/hg4idea/repo/HgRepositoryFiles", "getInstance"));
        }
        HgRepositoryFiles hgRepositoryFiles = new HgRepositoryFiles(hgDir);
        if (hgRepositoryFiles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryFiles", "getInstance"));
        }
        return hgRepositoryFiles;
    }

    private HgRepositoryFiles(@NotNull VirtualFile hgDir) {
        if (hgDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgDir", "org/zmlx/hg4idea/repo/HgRepositoryFiles", "<init>"));
        }
        this.myBranchHeadsPath = hgDir.getPath() + HgRepositoryFiles.slash(BRANCHHEADS);
        this.myBranchHeadsDirPath = hgDir.getPath() + HgRepositoryFiles.slash(BRANCHEADSDIR);
        this.myBranchPath = hgDir.getPath() + HgRepositoryFiles.slash(BRANCH);
        this.myDirstatePath = hgDir.getPath() + HgRepositoryFiles.slash(DIRSTATE);
        this.myMergePath = hgDir.getPath() + HgRepositoryFiles.slash(MERGE);
        this.myRebasePath = hgDir.getPath() + HgRepositoryFiles.slash(REBASE);
        this.myBookmarksPath = hgDir.getPath() + HgRepositoryFiles.slash(BOOKMARKS);
        this.myTagsPath = hgDir.getParent().getPath() + HgRepositoryFiles.slash(TAGS);
        this.myLocalTagsPath = hgDir.getPath() + HgRepositoryFiles.slash(LOCAL_TAGS);
        this.myCurrentBookmarkPath = hgDir.getPath() + HgRepositoryFiles.slash(CURRENT_BOOKMARK);
        this.myMQDirPath = hgDir.getPath() + HgRepositoryFiles.slash(MQDIR);
        this.myConfigHgrcPath = hgDir.getPath() + HgRepositoryFiles.slash(CONFIG_HGRC);
    }

    @NotNull
    private static String slash(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/zmlx/hg4idea/repo/HgRepositoryFiles", "slash"));
        }
        String string = "/" + s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryFiles", "slash"));
        }
        return string;
    }

    @NotNull
    static Collection<String> getSubDirRelativePaths() {
        List<String> list = Arrays.asList(HgRepositoryFiles.slash(BRANCHHEADS), HgRepositoryFiles.slash(MERGE));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryFiles", "getSubDirRelativePaths"));
        }
        return list;
    }

    @NotNull
    public String getBranchHeadsDirPath() {
        String string = this.myBranchHeadsDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryFiles", "getBranchHeadsDirPath"));
        }
        return string;
    }

    @NotNull
    public String getMQDirPath() {
        String string = this.myMQDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryFiles", "getMQDirPath"));
        }
        return string;
    }

    public boolean isbranchHeadsFile(String filePath) {
        return filePath.startsWith(this.myBranchHeadsPath);
    }

    public boolean isBranchFile(String filePath) {
        return filePath.equals(this.myBranchPath);
    }

    public boolean isDirstateFile(String filePath) {
        return filePath.equals(this.myDirstatePath);
    }

    public boolean isMergeFile(String filePath) {
        return filePath.startsWith(this.myMergePath);
    }

    public boolean isRebaseFile(String filePath) {
        return filePath.startsWith(this.myRebasePath);
    }

    public boolean isBookmarksFile(String filePath) {
        return filePath.equals(this.myBookmarksPath);
    }

    public boolean isCurrentBookmarksFile(String filePath) {
        return filePath.equals(this.myCurrentBookmarkPath);
    }

    public boolean isConfigHgrcFile(String filePath) {
        return filePath.equals(this.myConfigHgrcPath);
    }

    public boolean isTagsFile(String filePath) {
        return filePath.equals(this.myTagsPath);
    }

    public boolean isLocalTagsFile(String filePath) {
        return filePath.equals(this.myLocalTagsPath);
    }

    public boolean isMqFile(String filePath) {
        return filePath.startsWith(this.myMQDirPath);
    }
}

