/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.Binding;
import android.databinding.tool.BindingTarget;
import android.databinding.tool.InverseBinding;
import android.databinding.tool.expr.ComparisonExpr;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.expr.TwoWayListenerExpr;
import android.databinding.tool.expr.ViewFieldExpr;
import android.databinding.tool.ext.ExtKt;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.reflection.Callable;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.solver.ExecutionPath;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.BrNameUtil;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.KCode;
import java.util.ArrayList;
import java.util.List;

public class FieldAccessExpr
extends Expr {
    String mName;
    String mBrName;
    Callable mGetter;
    final boolean mIsObservableField;
    boolean mIsListener;
    boolean mIsViewAttributeAccess;

    FieldAccessExpr(Expr parent, String name) {
        super(parent);
        this.mName = name;
        this.mIsObservableField = false;
    }

    FieldAccessExpr(Expr parent, String name, boolean isObservableField) {
        super(parent);
        this.mName = name;
        this.mIsObservableField = isObservableField;
    }

    public Expr getChild() {
        return this.getChildren().get(0);
    }

    public Callable getGetter() {
        if (this.mGetter == null) {
            this.getResolvedType();
        }
        return this.mGetter;
    }

    @Override
    public List<ExecutionPath> toExecutionPath(List<ExecutionPath> paths) {
        List<ExecutionPath> targetPaths = this.getChild().toExecutionPath(paths);
        ArrayList<ExecutionPath> result = new ArrayList<ExecutionPath>();
        if (this.getChild() instanceof StaticIdentifierExpr) {
            result.addAll(this.toExecutionPathInOrder(paths, this.getChild()));
        } else {
            for (ExecutionPath path : targetPaths) {
                ComparisonExpr cmp = this.getModel().comparison("!=", this.getChild(), this.getModel().symbol("null", Object.class));
                path.addPath(cmp);
                ExecutionPath subPath = path.addBranch(cmp, true);
                if (subPath == null) continue;
                subPath.addPath(this);
                result.add(subPath);
            }
        }
        return result;
    }

    @Override
    public String getInvertibleError() {
        if (this.getGetter().setterName == null) {
            return "Two-way binding cannot resolve a setter for " + this.getResolvedType().toJavaCode() + " property '" + this.mName + "'";
        }
        if (!this.mGetter.isDynamic()) {
            return "Cannot change a final field in " + this.getResolvedType().toJavaCode() + " property " + this.mName;
        }
        return null;
    }

    public int getMinApi() {
        return this.mGetter.getMinApi();
    }

    @Override
    public boolean isDynamic() {
        if (this.mGetter == null) {
            this.getResolvedType();
        }
        if (this.mGetter == null || this.mGetter.type == Callable.Type.METHOD) {
            return true;
        }
        if (this.getChild().isDynamic()) {
            return !this.mGetter.isStatic() || this.mGetter.isDynamic();
        }
        if (this.mIsViewAttributeAccess) {
            return true;
        }
        return this.mGetter.isDynamic();
    }

    public boolean hasBindableAnnotations() {
        return this.mGetter.canBeInvalidated();
    }

    @Override
    public Expr resolveListeners(ModelClass listener, Expr parent) {
        int numberOfAbstractMethods;
        if (this.mName == null || this.mName.isEmpty()) {
            return this;
        }
        ModelClass childType = this.getChild().getResolvedType();
        if (this.getGetter() == null) {
            if (listener == null || !this.mIsListener) {
                L.e("Could not resolve %s.%s as an accessor or listener on the attribute.", childType.getCanonicalName(), this.mName);
                return this;
            }
            this.getChild().getParents().remove(this);
        } else if (listener == null) {
            return this;
        }
        List<ModelMethod> abstractMethods = listener.getAbstractMethods();
        int n = numberOfAbstractMethods = abstractMethods == null ? 0 : abstractMethods.size();
        if (numberOfAbstractMethods != 1) {
            if (this.mGetter == null) {
                L.e("Could not find accessor %s.%s and %s has %d abstract methods, so is not resolved as a listener", childType.getCanonicalName(), this.mName, listener.getCanonicalName(), numberOfAbstractMethods);
            }
            return this;
        }
        ModelMethod listenerMethod = abstractMethods.get(0);
        ModelClass[] listenerParameters = listenerMethod.getParameterTypes();
        boolean isStatic = this.getChild() instanceof StaticIdentifierExpr;
        List<ModelMethod> methods = childType.findMethods(this.mName, isStatic);
        for (ModelMethod method : methods) {
            if (!this.acceptsParameters(method, listenerParameters) || !method.getReturnType(null).equals(listenerMethod.getReturnType(null))) continue;
            this.resetResolvedType();
            Expr listenerExpr = this.getModel().listenerExpr(this.getChild(), this.mName, listener, listenerMethod);
            if (parent != null) {
                int index;
                while ((index = parent.getChildren().indexOf(this)) != -1) {
                    parent.getChildren().set(index, listenerExpr);
                }
            }
            if (this.getModel().mBindingExpressions.contains(this)) {
                this.getModel().bindingExpr(listenerExpr);
            }
            this.getParents().remove(parent);
            if (this.getParents().isEmpty()) {
                this.getModel().removeExpr(this);
            }
            return listenerExpr;
        }
        if (this.mGetter == null) {
            L.e("Listener class %s with method %s did not match signature of any method %s.%s", listener.getCanonicalName(), listenerMethod.getName(), childType.getCanonicalName(), this.mName);
        }
        return this;
    }

    private boolean acceptsParameters(ModelMethod method, ModelClass[] listenerParameters) {
        ModelClass[] parameters = method.getParameterTypes();
        if (parameters.length != listenerParameters.length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].isAssignableFrom(listenerParameters[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List<Dependency> constructDependencies() {
        List<Dependency> dependencies = this.constructDynamicChildrenDependencies();
        for (Dependency dependency : dependencies) {
            if (dependency.getOther() != this.getChild()) continue;
            dependency.setMandatory(true);
        }
        return dependencies;
    }

    @Override
    protected String computeUniqueKey() {
        if (this.mIsObservableField) {
            return this.addTwoWay(FieldAccessExpr.join(this.mName, "..", super.computeUniqueKey()));
        }
        return this.addTwoWay(FieldAccessExpr.join(this.mName, ".", super.computeUniqueKey()));
    }

    public String getName() {
        return this.mName;
    }

    public String getBrName() {
        if (this.mIsListener) {
            return null;
        }
        try {
            Scope.enter(this);
            Preconditions.checkNotNull(this.mGetter, "cannot get br name before resolving the getter", new Object[0]);
            String string = this.mBrName;
            return string;
        }
        finally {
            Scope.exit();
        }
    }

    @Override
    public void updateExpr(ModelAnalyzer modelAnalyzer) {
        try {
            Scope.enter(this);
            this.resolveType(modelAnalyzer);
            super.updateExpr(modelAnalyzer);
        }
        finally {
            Scope.exit();
        }
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        if (this.mIsListener) {
            return modelAnalyzer.findClass(Object.class);
        }
        if (this.mGetter == null) {
            Expr child = this.getChild();
            child.getResolvedType();
            boolean isStatic = child instanceof StaticIdentifierExpr;
            ModelClass resolvedType = child.getResolvedType();
            L.d("resolving %s. Resolved class type: %s", this, resolvedType);
            this.mGetter = resolvedType.findGetterOrField(this.mName, isStatic);
            if (this.mGetter == null) {
                boolean bl = this.mIsListener = !resolvedType.findMethods(this.mName, isStatic).isEmpty();
                if (!this.mIsListener) {
                    L.e("Could not find accessor %s.%s", resolvedType.getCanonicalName(), this.mName);
                }
                return modelAnalyzer.findClass(Object.class);
            }
            if (this.mGetter.isStatic() && !isStatic) {
                child.getParents().remove(this);
                this.getChildren().remove(child);
                StaticIdentifierExpr staticId = this.getModel().staticIdentifierFor(resolvedType);
                this.getChildren().add(staticId);
                staticId.getParents().add(this);
                child = this.getChild();
            }
            if (this.mGetter.resolvedType.isObservableField()) {
                child.getParents().remove(this);
                this.getChildren().remove(child);
                FieldAccessExpr observableField = this.getModel().observableField(child, this.mName);
                observableField.mGetter = this.mGetter;
                if (this.hasBindableAnnotations()) {
                    observableField.mBrName = ExtKt.br(BrNameUtil.brKey(this.mGetter));
                }
                this.getChildren().add(observableField);
                observableField.getParents().add(this);
                this.mGetter = this.mGetter.resolvedType.findGetterOrField("", false);
                this.mName = "";
                this.mBrName = ExtKt.br(this.mName);
            } else if (this.hasBindableAnnotations()) {
                this.mBrName = ExtKt.br(BrNameUtil.brKey(this.mGetter));
            }
        }
        return this.mGetter.resolvedType;
    }

    @Override
    public Expr resolveTwoWayExpressions(Expr parent) {
        ModelClass targetClass;
        Expr child = this.getChild();
        if (!(child instanceof ViewFieldExpr)) {
            return this;
        }
        ViewFieldExpr expr = (ViewFieldExpr)child;
        BindingTarget bindingTarget = expr.getBindingTarget();
        for (Binding binding : bindingTarget.getBindings()) {
            if (!FieldAccessExpr.attributeMatchesName(binding.getName(), this.mName)) continue;
            Expr replacement = binding.getExpr();
            this.replaceExpression(parent, replacement);
            return replacement;
        }
        SetterStore setterStore = SetterStore.get(ModelAnalyzer.getInstance());
        SetterStore.BindingGetterCall getter = setterStore.getGetterCall(this.mName, targetClass = expr.getResolvedType(), null, null);
        if (getter == null && (getter = setterStore.getGetterCall("android:" + this.mName, targetClass, null, null)) == null) {
            L.e("Could not resolve the two-way binding attribute '%s' on type '%s'", this.mName, targetClass);
        }
        InverseBinding inverseBinding = null;
        for (Binding binding : bindingTarget.getBindings()) {
            Expr testExpr = binding.getExpr();
            if (!(testExpr instanceof TwoWayListenerExpr) || !getter.getEventAttribute().equals(binding.getName())) continue;
            inverseBinding = ((TwoWayListenerExpr)testExpr).mInverseBinding;
            break;
        }
        if (inverseBinding == null) {
            inverseBinding = bindingTarget.addInverseBinding(this.mName, getter);
        }
        inverseBinding.addChainedExpression(this);
        this.mIsViewAttributeAccess = true;
        this.enableDirectInvalidation();
        return this;
    }

    private static boolean attributeMatchesName(String attribute, String field) {
        int colonIndex = attribute.indexOf(58);
        return attribute.substring(colonIndex + 1).equals(field);
    }

    private void replaceExpression(Expr parent, Expr replacement) {
        if (parent != null) {
            int index;
            List<Expr> children = parent.getChildren();
            while ((index = children.indexOf(this)) >= 0) {
                children.set(index, replacement);
                replacement.getParents().add(parent);
            }
            while (this.getParents().remove(parent)) {
            }
        }
        if (this.getParents().isEmpty()) {
            this.getModel().removeExpr(this);
        }
    }

    @Override
    protected String asPackage() {
        String parentPackage = this.getChild().asPackage();
        return parentPackage == null ? null : parentPackage + "." + this.mName;
    }

    @Override
    protected KCode generateCode(boolean expand) {
        Preconditions.checkNotNull(this.getGetter(), "Cannot resolve type for %s", this);
        KCode code = new KCode();
        if (expand) {
            String defaultValue = ModelAnalyzer.getInstance().getDefaultValue(this.getResolvedType().toJavaCode());
            code.app("(", this.getChild().toCode(true)).app(" == null) ? ").app(defaultValue).app(" : ");
        }
        code.app("", this.getChild().toCode(expand)).app(".");
        if (this.getGetter().type == Callable.Type.FIELD) {
            return code.app(this.getGetter().name);
        }
        return code.app(this.getGetter().name).app("()");
    }

    @Override
    public KCode toInverseCode(KCode value) {
        if (this.mGetter.setterName == null) {
            throw new IllegalStateException("There is no inverse for " + this.toCode().generate());
        }
        KCode castValue = new KCode("(").app(this.getResolvedType().toJavaCode() + ")(", value).app(")");
        String type = this.getChild().getResolvedType().toJavaCode();
        KCode code = new KCode("targetObj_.");
        if (this.getGetter().type == Callable.Type.FIELD) {
            code.app(this.getGetter().setterName).app(" = ", castValue).app(";");
        } else {
            code.app(this.getGetter().setterName).app("(", castValue).app(")").app(";");
        }
        return new KCode().app("final ").app(type).app(" targetObj_ = ", this.getChild().toCode(true)).app(";").nl(new KCode("if (targetObj_ != null) {")).tab(code).nl(new KCode("}"));
    }
}

