/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.KCode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceExpr
extends Expr {
    private static final Map<String, String> RESOURCE_TYPE_TO_R_OBJECT = new HashMap<String, String>();
    private Map<String, ModelClass> mResourceToTypeMapping;
    protected final String mPackage;
    protected final String mResourceType;
    protected final String mResourceId;

    public ResourceExpr(String packageName, String resourceType, String resourceName, List<Expr> args) {
        super(args);
        this.mPackage = "android".equals(packageName) ? "android." : "";
        this.mResourceType = resourceType;
        this.mResourceId = resourceName;
    }

    private Map<String, ModelClass> getResourceToTypeMapping(ModelAnalyzer modelAnalyzer) {
        if (this.mResourceToTypeMapping == null) {
            Map<String, String> imports = this.getModel().getImports();
            this.mResourceToTypeMapping = new HashMap<String, ModelClass>();
            this.mResourceToTypeMapping.put("anim", modelAnalyzer.findClass("android.view.animation.Animation", imports));
            this.mResourceToTypeMapping.put("animator", modelAnalyzer.findClass("android.animation.Animator", imports));
            this.mResourceToTypeMapping.put("colorStateList", modelAnalyzer.findClass("android.content.res.ColorStateList", imports));
            this.mResourceToTypeMapping.put("drawable", modelAnalyzer.findClass("android.graphics.drawable.Drawable", imports));
            this.mResourceToTypeMapping.put("stateListAnimator", modelAnalyzer.findClass("android.animation.StateListAnimator", imports));
            this.mResourceToTypeMapping.put("transition", modelAnalyzer.findClass("android.transition.Transition", imports));
            this.mResourceToTypeMapping.put("typedArray", modelAnalyzer.findClass("android.content.res.TypedArray", imports));
            this.mResourceToTypeMapping.put("interpolator", modelAnalyzer.findClass("android.view.animation.Interpolator", imports));
            this.mResourceToTypeMapping.put("bool", modelAnalyzer.findClass(Boolean.TYPE));
            this.mResourceToTypeMapping.put("color", modelAnalyzer.findClass(Integer.TYPE));
            this.mResourceToTypeMapping.put("dimenOffset", modelAnalyzer.findClass(Integer.TYPE));
            this.mResourceToTypeMapping.put("dimenSize", modelAnalyzer.findClass(Integer.TYPE));
            this.mResourceToTypeMapping.put("id", modelAnalyzer.findClass(Integer.TYPE));
            this.mResourceToTypeMapping.put("integer", modelAnalyzer.findClass(Integer.TYPE));
            this.mResourceToTypeMapping.put("layout", modelAnalyzer.findClass(Integer.TYPE));
            this.mResourceToTypeMapping.put("dimen", modelAnalyzer.findClass(Float.TYPE));
            this.mResourceToTypeMapping.put("fraction", modelAnalyzer.findClass(Float.TYPE));
            this.mResourceToTypeMapping.put("intArray", modelAnalyzer.findClass(int[].class));
            this.mResourceToTypeMapping.put("string", modelAnalyzer.findClass(String.class));
            this.mResourceToTypeMapping.put("stringArray", modelAnalyzer.findClass(String[].class));
        }
        return this.mResourceToTypeMapping;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        Map<String, ModelClass> mapping = this.getResourceToTypeMapping(modelAnalyzer);
        ModelClass modelClass = mapping.get(this.mResourceType);
        if (modelClass != null) {
            return modelClass;
        }
        if ("plurals".equals(this.mResourceType)) {
            if (this.getChildren().isEmpty()) {
                return modelAnalyzer.findClass(Integer.TYPE);
            }
            return modelAnalyzer.findClass(String.class);
        }
        return modelAnalyzer.findClass(this.mResourceType, this.getModel().getImports());
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    @Override
    protected String computeUniqueKey() {
        String base = this.mPackage == null ? "@" + this.mResourceType + "/" + this.mResourceId : "@android:" + this.mResourceType + "/" + this.mResourceId;
        return ResourceExpr.join(base, this.computeChildrenKey());
    }

    @Override
    protected KCode generateCode(boolean expand) {
        return new KCode(this.toJava());
    }

    public String getResourceId() {
        return this.mPackage + "R." + this.getResourceObject() + "." + this.mResourceId;
    }

    @Override
    public String getInvertibleError() {
        return "Resources may not be the target of a two-way binding expression: " + this.computeUniqueKey();
    }

    public String toJava() {
        String context = "getRoot().getContext()";
        String resources = "getRoot().getResources()";
        String resourceName = this.mPackage + "R." + this.getResourceObject() + "." + this.mResourceId;
        if ("anim".equals(this.mResourceType)) {
            return "android.view.animation.AnimationUtils.loadAnimation(getRoot().getContext(), " + resourceName + ")";
        }
        if ("animator".equals(this.mResourceType)) {
            return "android.animation.AnimatorInflater.loadAnimator(getRoot().getContext(), " + resourceName + ")";
        }
        if ("bool".equals(this.mResourceType)) {
            return "getRoot().getResources().getBoolean(" + resourceName + ")";
        }
        if ("color".equals(this.mResourceType)) {
            return "android.databinding.DynamicUtil.getColorFromResource(getRoot(), " + resourceName + ")";
        }
        if ("colorStateList".equals(this.mResourceType)) {
            return "getColorStateListFromResource(" + resourceName + ")";
        }
        if ("dimen".equals(this.mResourceType)) {
            return "getRoot().getResources().getDimension(" + resourceName + ")";
        }
        if ("dimenOffset".equals(this.mResourceType)) {
            return "getRoot().getResources().getDimensionPixelOffset(" + resourceName + ")";
        }
        if ("dimenSize".equals(this.mResourceType)) {
            return "getRoot().getResources().getDimensionPixelSize(" + resourceName + ")";
        }
        if ("drawable".equals(this.mResourceType)) {
            return "getDrawableFromResource(" + resourceName + ")";
        }
        if ("fraction".equals(this.mResourceType)) {
            String base = this.getChildCode(0, "1");
            String pbase = this.getChildCode(1, "1");
            return "getRoot().getResources().getFraction(" + resourceName + ", " + base + ", " + pbase + ")";
        }
        if ("id".equals(this.mResourceType)) {
            return resourceName;
        }
        if ("intArray".equals(this.mResourceType)) {
            return "getRoot().getResources().getIntArray(" + resourceName + ")";
        }
        if ("integer".equals(this.mResourceType)) {
            return "getRoot().getResources().getInteger(" + resourceName + ")";
        }
        if ("interpolator".equals(this.mResourceType)) {
            return "android.view.animation.AnimationUtils.loadInterpolator(getRoot().getContext(), " + resourceName + ")";
        }
        if ("layout".equals(this.mResourceType)) {
            return resourceName;
        }
        if ("plurals".equals(this.mResourceType)) {
            if (this.getChildren().isEmpty()) {
                return resourceName;
            }
            return this.makeParameterCall(resourceName, "getQuantityString");
        }
        if ("stateListAnimator".equals(this.mResourceType)) {
            return "android.animation.AnimatorInflater.loadStateListAnimator(getRoot().getContext(), " + resourceName + ")";
        }
        if ("string".equals(this.mResourceType)) {
            return this.makeParameterCall(resourceName, "getString");
        }
        if ("stringArray".equals(this.mResourceType)) {
            return "getRoot().getResources().getStringArray(" + resourceName + ")";
        }
        if ("transition".equals(this.mResourceType)) {
            return "android.transition.TransitionInflater.from(getRoot().getContext()).inflateTransition(" + resourceName + ")";
        }
        if ("typedArray".equals(this.mResourceType)) {
            return "getRoot().getResources().obtainTypedArray(" + resourceName + ")";
        }
        String property = Character.toUpperCase(this.mResourceType.charAt(0)) + this.mResourceType.substring(1);
        return "getRoot().getResources().get" + property + "(" + resourceName + ")";
    }

    private String getChildCode(int childIndex, String defaultValue) {
        if (this.getChildren().size() <= childIndex) {
            return defaultValue;
        }
        return this.getChildren().get(childIndex).toCode().generate();
    }

    private String makeParameterCall(String resourceName, String methodCall) {
        StringBuilder sb = new StringBuilder("getRoot().getResources().");
        sb.append(methodCall).append("(").append(resourceName);
        for (Expr expr : this.getChildren()) {
            sb.append(", ").append(expr.toCode().generate());
        }
        sb.append(")");
        return sb.toString();
    }

    private String getResourceObject() {
        String rFileObject = RESOURCE_TYPE_TO_R_OBJECT.get(this.mResourceType);
        if (rFileObject == null) {
            rFileObject = this.mResourceType;
        }
        return rFileObject;
    }

    static {
        RESOURCE_TYPE_TO_R_OBJECT.put("colorStateList", "color  ");
        RESOURCE_TYPE_TO_R_OBJECT.put("dimenOffset", "dimen  ");
        RESOURCE_TYPE_TO_R_OBJECT.put("dimenSize", "dimen  ");
        RESOURCE_TYPE_TO_R_OBJECT.put("intArray", "array  ");
        RESOURCE_TYPE_TO_R_OBJECT.put("stateListAnimator", "animator  ");
        RESOURCE_TYPE_TO_R_OBJECT.put("stringArray", "array  ");
        RESOURCE_TYPE_TO_R_OBJECT.put("typedArray", "array");
    }
}

