/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse;

import com.intellij.openapi.util.Comparing;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseProjectFinder;

public class EPathCommonUtil {
    @NotNull
    public static String getRelativeModuleName(String path) {
        int secondSlIdx = path.indexOf(47, 1);
        String string = secondSlIdx > 1 ? path.substring(1, secondSlIdx) : path.substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/EPathCommonUtil", "getRelativeModuleName"));
        }
        return string;
    }

    @Nullable
    public static String getRelativeToModulePath(String path) {
        int secondSlIdx = path.indexOf(47, 1);
        return secondSlIdx != -1 && secondSlIdx + 1 < path.length() ? path.substring(secondSlIdx + 1) : null;
    }

    @Nullable
    public static String expandEclipseRelative2ContentRoots(@NotNull List<String> currentRoots, @NotNull String rootPath, @Nullable String relativeToRootPath) {
        if (currentRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRoots", "org/jetbrains/idea/eclipse/EPathCommonUtil", "expandEclipseRelative2ContentRoots"));
        }
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "org/jetbrains/idea/eclipse/EPathCommonUtil", "expandEclipseRelative2ContentRoots"));
        }
        for (String currentRoot : currentRoots) {
            if (!currentRoot.endsWith(rootPath) && !Comparing.strEqual((String)rootPath, (String)EclipseProjectFinder.findProjectName(currentRoot))) continue;
            if (relativeToRootPath == null) {
                return EPathCommonUtil.pathToUrl(currentRoot);
            }
            File relativeToOtherModuleFile = new File(currentRoot, relativeToRootPath);
            if (!relativeToOtherModuleFile.exists()) continue;
            return EPathCommonUtil.pathToUrl(relativeToOtherModuleFile.getPath());
        }
        return null;
    }

    public static String pathToUrl(String path) {
        return "file://" + path;
    }
}

