/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.QName;

public class QNameDV
extends TypeValidator {
    private static final String EMPTY_STRING = "";

    public short getAllowedFacets() {
        return 63;
    }

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        String string2;
        String string3;
        int n = string.indexOf(":");
        if (n > 0) {
            string3 = validationContext.getSymbol(string.substring(0, n));
            string2 = string.substring(n + 1);
        } else {
            string3 = validationContext.getSymbol(EMPTY_STRING);
            string2 = string;
        }
        if (string3.length() > 0 && !XMLChar.isValidNCName(string3)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "QName"});
        }
        if (!XMLChar.isValidNCName(string2)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "QName"});
        }
        String string4 = validationContext.getURI(string3);
        if (string3.length() > 0 && string4 == null) {
            throw new InvalidDatatypeValueException("UndeclaredPrefix", new Object[]{string, string3});
        }
        return new QName(string3, validationContext.getSymbol(string2), validationContext.getSymbol(string), string4);
    }

    public int getDataLength(Object object) {
        return ((QName)object).rawname.length();
    }
}

