/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class ParserStream {
    protected static final Charset STRING_CHARSET_UTF16 = Charset.forName("UTF-16LE");
    protected static final Charset STRING_CHARSET_UTF8 = Charset.forName("UTF-8");
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final InputStream input;
    private long readPos = 0L;

    public ParserStream(@NotNull InputStream inputStream) {
        this.input = inputStream;
    }

    public long getPos() {
        return this.readPos;
    }

    public int readInt8() throws IOException {
        ++this.readPos;
        return this.input.read();
    }

    public int readInt16() throws IOException {
        this.readPos += 2L;
        int b1 = this.input.read();
        int b2 = this.input.read();
        return (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public int readInt32() throws IOException {
        this.readPos += 4L;
        InputStream in = this.input;
        int b1 = in.read();
        int b2 = in.read();
        int b3 = in.read();
        int b4 = in.read();
        return b4 << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public long readUInt32() throws IOException {
        return (long)this.readInt32() & 0xFFFFFFFFL;
    }

    public String readString16Fixed(int len) throws IOException {
        String str = new String(this.readInt8Array(len * 2), STRING_CHARSET_UTF16);
        return str.trim();
    }

    public int[] readInt32Array(int count) throws IOException {
        if (count == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] arr = new int[count];
        for (int i = 0; i < count; ++i) {
            arr[i] = this.readInt32();
        }
        return arr;
    }

    public byte[] readInt8Array(int count) throws IOException {
        int read;
        if (count == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        this.readPos += (long)count;
        byte[] arr = new byte[count];
        for (int pos = this.input.read(arr, 0, count); pos < count; pos += read) {
            read = this.input.read(arr, pos, count - pos);
            if (read != -1) continue;
            throw new IOException("No data, can't read " + count + " bytes");
        }
        return arr;
    }

    public void skip(long count) throws IOException {
        long skipped;
        this.readPos += count;
        for (long pos = this.input.skip(count); pos < count; pos += skipped) {
            skipped = this.input.skip(count - pos);
            if (skipped != -1L) continue;
            throw new IOException("No data, can't skip " + count + " bytes");
        }
    }

    public void checkInt8(int expected, String error) throws IOException {
        int v = this.readInt8();
        if (v != expected) {
            this.throwException(error, expected, v);
        }
    }

    public void checkInt16(int expected, String error) throws IOException {
        int v = this.readInt16();
        if (v != expected) {
            this.throwException(error, expected, v);
        }
    }

    private void throwException(String error, int expected, int actual) throws IOException {
        throw new IOException(error + ", expected: 0x" + Integer.toHexString(expected) + ", actual: 0x" + Integer.toHexString(actual) + ", offset: 0x" + Long.toHexString(this.getPos()));
    }

    public void checkPos(long expectedOffset, String error) throws IOException {
        if (this.getPos() != expectedOffset) {
            throw new IOException(error + ", expected offset: 0x" + Long.toHexString(expectedOffset) + ", actual: 0x" + Long.toHexString(this.getPos()));
        }
    }

    public void skipToPos(long expectedOffset, String error) throws IOException {
        long pos = this.getPos();
        if (pos < expectedOffset) {
            this.skip(expectedOffset - pos);
        }
        this.checkPos(expectedOffset, error);
    }

    public String toString() {
        return "pos: 0x" + Long.toHexString(this.readPos);
    }
}

