/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.data.validation.util.MultipleNameVisitor;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class TestError
implements Comparable<TestError>,
DataSetListener {
    private boolean ignored;
    private Severity severity;
    private String message;
    private final String description;
    private final String descriptionEn;
    private Collection<? extends OsmPrimitive> primitives;
    private final Collection<?> highlighted;
    private Test tester;
    private final int code;
    private boolean selected;
    private final Supplier<Command> fixingCommand;

    public static Builder builder(Test test, Severity severity, int n) {
        return new Builder(test, severity, n);
    }

    TestError(Builder builder) {
        this.tester = builder.tester;
        this.severity = builder.severity;
        this.message = builder.message;
        this.description = builder.description;
        this.descriptionEn = builder.descriptionEn;
        this.primitives = builder.primitives;
        this.highlighted = builder.highlighted;
        this.code = builder.code;
        this.fixingCommand = builder.fixingCommand;
    }

    @Deprecated
    public TestError(Test test, Severity severity, String string, String string2, String string3, int n, Collection<? extends OsmPrimitive> collection, Collection<?> collection2) {
        this.tester = test;
        this.severity = severity;
        this.message = string;
        this.description = string2;
        this.descriptionEn = string3;
        this.primitives = collection;
        this.highlighted = collection2;
        this.code = n;
        this.fixingCommand = null;
    }

    @Deprecated
    public TestError(Test test, Severity severity, String string, int n, Collection<? extends OsmPrimitive> collection, Collection<?> collection2) {
        this(test, severity, string, null, null, n, collection, collection2);
    }

    @Deprecated
    public TestError(Test test, Severity severity, String string, String string2, String string3, int n, Collection<? extends OsmPrimitive> collection) {
        this(test, severity, string, string2, string3, n, collection, collection);
    }

    @Deprecated
    public TestError(Test test, Severity severity, String string, int n, Collection<? extends OsmPrimitive> collection) {
        this(test, severity, string, null, null, n, collection, collection);
    }

    @Deprecated
    public TestError(Test test, Severity severity, String string, int n, OsmPrimitive osmPrimitive) {
        this(test, severity, string, null, null, n, Collections.singletonList(osmPrimitive), Collections.singletonList(osmPrimitive));
    }

    @Deprecated
    public TestError(Test test, Severity severity, String string, String string2, String string3, int n, OsmPrimitive osmPrimitive) {
        this(test, severity, string, string2, string3, n, Collections.singletonList(osmPrimitive));
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public void setMessage(String string) {
        this.message = string;
    }

    public Collection<? extends OsmPrimitive> getPrimitives() {
        return this.primitives;
    }

    public Collection<? extends OsmPrimitive> getSelectablePrimitives() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(this.primitives.size());
        for (OsmPrimitive osmPrimitive : this.primitives) {
            if (!osmPrimitive.isSelectable()) continue;
            arrayList.add(osmPrimitive);
        }
        return arrayList;
    }

    @Deprecated
    public void setPrimitives(List<? extends OsmPrimitive> list) {
        this.primitives = list;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    @Deprecated
    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public String getIgnoreState() {
        TreeSet<String> treeSet = new TreeSet<String>();
        StringBuilder stringBuilder = new StringBuilder(this.getIgnoreSubGroup());
        for (OsmPrimitive object : this.primitives) {
            if (object.isNew()) {
                return null;
            }
            String string = "u";
            if (object instanceof Way) {
                string = "w";
            } else if (object instanceof Relation) {
                string = "r";
            } else if (object instanceof Node) {
                string = "n";
            }
            treeSet.add(string + '_' + object.getId());
        }
        for (String string : treeSet) {
            stringBuilder.append(':').append(string);
        }
        return stringBuilder.toString();
    }

    public String getIgnoreSubGroup() {
        String string = this.getIgnoreGroup();
        if (this.descriptionEn != null) {
            string = string + '_' + this.descriptionEn;
        }
        return string;
    }

    public String getIgnoreGroup() {
        return Integer.toString(this.code);
    }

    public void setIgnored(boolean bl) {
        this.ignored = bl;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public Test getTester() {
        return this.tester;
    }

    @Deprecated
    public void setTester(Test test) {
        this.tester = test;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isFixable() {
        return this.fixingCommand != null || this.tester != null && this.tester.isFixable(this);
    }

    public Command getFix() {
        Command command;
        Command command2 = command = this.fixingCommand != null ? this.fixingCommand.get() : null;
        if (command != null) {
            return command;
        }
        if (this.tester == null || !this.tester.isFixable(this) || this.primitives.isEmpty()) {
            return null;
        }
        return this.tester.fixError(this);
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void visitHighlighted(ValidatorVisitor validatorVisitor) {
        for (Object obj : this.highlighted) {
            if (obj instanceof OsmPrimitive) {
                validatorVisitor.visit((OsmPrimitive)obj);
                continue;
            }
            if (obj instanceof WaySegment) {
                validatorVisitor.visit((WaySegment)obj);
                continue;
            }
            if (!(obj instanceof List)) continue;
            validatorVisitor.visit((List)obj);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Collection<?> getHighlighted() {
        return this.highlighted;
    }

    @Override
    public int compareTo(TestError testError) {
        if (this.equals(testError)) {
            return 0;
        }
        MultipleNameVisitor multipleNameVisitor = new MultipleNameVisitor();
        MultipleNameVisitor multipleNameVisitor2 = new MultipleNameVisitor();
        multipleNameVisitor.visit(this.getPrimitives());
        multipleNameVisitor2.visit(testError.getPrimitives());
        return AlphanumComparator.getInstance().compare(multipleNameVisitor.toString(), multipleNameVisitor2.toString());
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        try {
            this.primitives.removeAll(primitivesRemovedEvent.getPrimitives());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (primitivesRemovedEvent.getPrimitives().containsAll(this.primitives)) {
                this.primitives = Collections.emptyList();
            }
            Main.warn((Throwable)unsupportedOperationException, "Unable to remove primitives from " + this + '.');
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
    }

    public String toString() {
        return "TestError [tester=" + this.tester + ", code=" + this.code + ", message=" + this.message + ']';
    }

    public static final class Builder {
        private final Test tester;
        private final Severity severity;
        private final int code;
        private String message;
        private String description;
        private String descriptionEn;
        private Collection<? extends OsmPrimitive> primitives;
        private Collection<?> highlighted;
        private Supplier<Command> fixingCommand;

        Builder(Test test, Severity severity, int n) {
            this.tester = test;
            this.severity = severity;
            this.code = n;
        }

        public Builder message(String string) {
            this.message = string;
            return this;
        }

        public Builder messageWithManuallyTranslatedDescription(String string, String string2, String string3) {
            this.message = string;
            this.description = string2;
            this.descriptionEn = string3;
            return this;
        }

        public Builder message(String string, String string2, Object ... objectArray) {
            this.message = string;
            this.description = I18n.tr(string2, objectArray);
            this.descriptionEn = new MessageFormat(string2, Locale.ENGLISH).format(objectArray);
            return this;
        }

        public Builder primitives(OsmPrimitive ... osmPrimitiveArray) {
            return this.primitives(Arrays.asList(osmPrimitiveArray));
        }

        public Builder primitives(Collection<? extends OsmPrimitive> collection) {
            CheckParameterUtil.ensureThat(this.primitives == null, "primitives already set");
            CheckParameterUtil.ensureParameterNotNull(collection, "primitives");
            this.primitives = collection;
            if (this.highlighted == null) {
                this.highlighted = collection;
            }
            return this;
        }

        public Builder highlight(OsmPrimitive ... osmPrimitiveArray) {
            return this.highlight(Arrays.asList(osmPrimitiveArray));
        }

        public Builder highlight(Collection<? extends OsmPrimitive> collection) {
            CheckParameterUtil.ensureParameterNotNull(collection, "highlighted");
            this.highlighted = collection;
            return this;
        }

        public Builder highlightWaySegments(Collection<WaySegment> collection) {
            CheckParameterUtil.ensureParameterNotNull(collection, "highlighted");
            this.highlighted = collection;
            return this;
        }

        public Builder highlightNodePairs(Collection<List<Node>> collection) {
            CheckParameterUtil.ensureParameterNotNull(collection, "highlighted");
            this.highlighted = collection;
            return this;
        }

        public Builder fix(Supplier<Command> supplier) {
            CheckParameterUtil.ensureThat(this.fixingCommand == null, "fixingCommand already set");
            this.fixingCommand = supplier;
            return this;
        }

        public TestError build() {
            CheckParameterUtil.ensureParameterNotNull(this.message, "message not set");
            CheckParameterUtil.ensureParameterNotNull(this.primitives, "primitives not set");
            CheckParameterUtil.ensureThat(!this.primitives.isEmpty(), "primitives is empty");
            if (this.highlighted == null) {
                this.highlighted = Collections.emptySet();
            }
            return new TestError(this);
        }
    }
}

