/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Side;
import javafx.scene.control.Control;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;

@DefaultProperty(value="tabs")
public class TabPane
extends Control {
    private static final double DEFAULT_TAB_MIN_WIDTH = 0.0;
    private static final double DEFAULT_TAB_MAX_WIDTH = Double.MAX_VALUE;
    private static final double DEFAULT_TAB_MIN_HEIGHT = 0.0;
    private static final double DEFAULT_TAB_MAX_HEIGHT = Double.MAX_VALUE;
    public static final String STYLE_CLASS_FLOATING = "floating";
    private ObservableList<Tab> tabs = FXCollections.observableArrayList();
    private ObjectProperty<SingleSelectionModel<Tab>> selectionModel = new SimpleObjectProperty<SingleSelectionModel<Tab>>(this, "selectionModel");
    private ObjectProperty<Side> side;
    private ObjectProperty<TabClosingPolicy> tabClosingPolicy;
    private BooleanProperty rotateGraphic;
    private DoubleProperty tabMinWidth;
    private DoubleProperty tabMaxWidth;
    private DoubleProperty tabMinHeight;
    private DoubleProperty tabMaxHeight;
    private Side cachedSide;
    private String cachedSideString;
    private static final long TOP_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("top");
    private static final long BOTTOM_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("bottom");
    private static final long LEFT_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("left");
    private static final long RIGHT_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("right");

    public TabPane() {
        this.getStyleClass().setAll((String[])new String[]{"tab-pane"});
        this.setSelectionModel(new TabPaneSelectionModel(this));
        this.tabs.addListener(new ListChangeListener<Tab>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Tab> change) {
                while (change.next()) {
                    for (Tab tab : change.getRemoved()) {
                        if (tab == null || TabPane.this.getTabs().contains(tab)) continue;
                        tab.setTabPane(null);
                    }
                    for (Tab tab : change.getAddedSubList()) {
                        if (tab == null) continue;
                        tab.setTabPane(TabPane.this);
                    }
                }
            }
        });
    }

    public final ObservableList<Tab> getTabs() {
        return this.tabs;
    }

    public final void setSelectionModel(SingleSelectionModel<Tab> singleSelectionModel) {
        this.selectionModel.set(singleSelectionModel);
    }

    public final SingleSelectionModel<Tab> getSelectionModel() {
        return (SingleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<SingleSelectionModel<Tab>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final void setSide(Side side) {
        this.sideProperty().set(side);
    }

    public final Side getSide() {
        return this.side == null ? Side.TOP : (Side)((Object)this.side.get());
    }

    public final ObjectProperty<Side> sideProperty() {
        if (this.side == null) {
            this.side = new ObjectPropertyBase<Side>(Side.TOP){
                private Side oldSide;

                @Override
                protected void invalidated() {
                    if (this.oldSide != null) {
                        TabPane.this.impl_pseudoClassStateChanged(this.oldSide.name().toLowerCase());
                    }
                    this.oldSide = (Side)((Object)this.get());
                    if (this.get() != null) {
                        TabPane.this.impl_pseudoClassStateChanged(((Side)((Object)this.get())).name().toLowerCase());
                    }
                }

                @Override
                public Object getBean() {
                    return TabPane.this;
                }

                @Override
                public String getName() {
                    return "side";
                }
            };
        }
        return this.side;
    }

    public final void setTabClosingPolicy(TabClosingPolicy tabClosingPolicy) {
        this.tabClosingPolicyProperty().set(tabClosingPolicy);
    }

    public final TabClosingPolicy getTabClosingPolicy() {
        return this.tabClosingPolicy == null ? TabClosingPolicy.SELECTED_TAB : (TabClosingPolicy)((Object)this.tabClosingPolicy.get());
    }

    public final ObjectProperty<TabClosingPolicy> tabClosingPolicyProperty() {
        if (this.tabClosingPolicy == null) {
            this.tabClosingPolicy = new SimpleObjectProperty<TabClosingPolicy>(this, "tabClosingPolicy", TabClosingPolicy.SELECTED_TAB);
        }
        return this.tabClosingPolicy;
    }

    public final void setRotateGraphic(boolean bl) {
        this.rotateGraphicProperty().set(bl);
    }

    public final boolean isRotateGraphic() {
        return this.rotateGraphic == null ? false : this.rotateGraphic.get();
    }

    public final BooleanProperty rotateGraphicProperty() {
        if (this.rotateGraphic == null) {
            this.rotateGraphic = new SimpleBooleanProperty(this, "rotateGraphic", false);
        }
        return this.rotateGraphic;
    }

    public final void setTabMinWidth(double d) {
        this.tabMinWidthProperty().setValue(d);
    }

    public final double getTabMinWidth() {
        return this.tabMinWidth == null ? 0.0 : this.tabMinWidth.getValue();
    }

    public final DoubleProperty tabMinWidthProperty() {
        if (this.tabMinWidth == null) {
            this.tabMinWidth = new StyleableDoubleProperty(0.0){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.TAB_MIN_WIDTH;
                }

                @Override
                public Object getBean() {
                    return TabPane.this;
                }

                @Override
                public String getName() {
                    return "tabMinWidth";
                }
            };
        }
        return this.tabMinWidth;
    }

    public final void setTabMaxWidth(double d) {
        this.tabMaxWidthProperty().setValue(d);
    }

    public final double getTabMaxWidth() {
        return this.tabMaxWidth == null ? Double.MAX_VALUE : this.tabMaxWidth.getValue();
    }

    public final DoubleProperty tabMaxWidthProperty() {
        if (this.tabMaxWidth == null) {
            this.tabMaxWidth = new StyleableDoubleProperty(Double.MAX_VALUE){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.TAB_MAX_WIDTH;
                }

                @Override
                public Object getBean() {
                    return TabPane.this;
                }

                @Override
                public String getName() {
                    return "tabMaxWidth";
                }
            };
        }
        return this.tabMaxWidth;
    }

    public final void setTabMinHeight(double d) {
        this.tabMinHeightProperty().setValue(d);
    }

    public final double getTabMinHeight() {
        return this.tabMinHeight == null ? 0.0 : this.tabMinHeight.getValue();
    }

    public final DoubleProperty tabMinHeightProperty() {
        if (this.tabMinHeight == null) {
            this.tabMinHeight = new StyleableDoubleProperty(0.0){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.TAB_MIN_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return TabPane.this;
                }

                @Override
                public String getName() {
                    return "tabMinHeight";
                }
            };
        }
        return this.tabMinHeight;
    }

    public final void setTabMaxHeight(double d) {
        this.tabMaxHeightProperty().setValue(d);
    }

    public final double getTabMaxHeight() {
        return this.tabMaxHeight == null ? Double.MAX_VALUE : this.tabMaxHeight.getValue();
    }

    public final DoubleProperty tabMaxHeightProperty() {
        if (this.tabMaxHeight == null) {
            this.tabMaxHeight = new StyleableDoubleProperty(Double.MAX_VALUE){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.TAB_MAX_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return TabPane.this;
                }

                @Override
                public String getName() {
                    return "tabMaxHeight";
                }
            };
        }
        return this.tabMaxHeight;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return TabPane.impl_CSS_STYLEABLES();
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        switch (this.getSide()) {
            case TOP: {
                l |= TOP_PSEUDOCLASS_STATE;
                break;
            }
            case RIGHT: {
                l |= RIGHT_PSEUDOCLASS_STATE;
                break;
            }
            case BOTTOM: {
                l |= BOTTOM_PSEUDOCLASS_STATE;
                break;
            }
            case LEFT: {
                l |= LEFT_PSEUDOCLASS_STATE;
            }
        }
        return l;
    }

    private static class StyleableProperties {
        private static final StyleableProperty<TabPane, Number> TAB_MIN_WIDTH = new StyleableProperty<TabPane, Number>("-fx-tab-min-width", (StyleConverter)SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(TabPane tabPane) {
                return tabPane.tabMinWidth == null || !tabPane.tabMinWidth.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(TabPane tabPane) {
                return tabPane.tabMinWidthProperty();
            }
        };
        private static final StyleableProperty<TabPane, Number> TAB_MAX_WIDTH = new StyleableProperty<TabPane, Number>("-fx-tab-max-width", (StyleConverter)SizeConverter.getInstance(), (Number)Double.MAX_VALUE){

            @Override
            public boolean isSettable(TabPane tabPane) {
                return tabPane.tabMaxWidth == null || !tabPane.tabMaxWidth.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(TabPane tabPane) {
                return tabPane.tabMaxWidthProperty();
            }
        };
        private static final StyleableProperty<TabPane, Number> TAB_MIN_HEIGHT = new StyleableProperty<TabPane, Number>("-fx-tab-min-height", (StyleConverter)SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(TabPane tabPane) {
                return tabPane.tabMinHeight == null || !tabPane.tabMinHeight.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(TabPane tabPane) {
                return tabPane.tabMinHeightProperty();
            }
        };
        private static final StyleableProperty<TabPane, Number> TAB_MAX_HEIGHT = new StyleableProperty<TabPane, Number>("-fx-tab-max-height", (StyleConverter)SizeConverter.getInstance(), (Number)Double.MAX_VALUE){

            @Override
            public boolean isSettable(TabPane tabPane) {
                return tabPane.tabMaxHeight == null || !tabPane.tabMaxHeight.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(TabPane tabPane) {
                return tabPane.tabMaxHeightProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, TAB_MIN_WIDTH, TAB_MAX_WIDTH, TAB_MIN_HEIGHT, TAB_MAX_HEIGHT);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    public static enum TabClosingPolicy {
        SELECTED_TAB,
        ALL_TABS,
        UNAVAILABLE;

    }

    static class TabPaneSelectionModel
    extends SingleSelectionModel<Tab> {
        private final TabPane tabPane;

        public TabPaneSelectionModel(TabPane tabPane) {
            if (tabPane == null) {
                throw new NullPointerException("TabPane can not be null");
            }
            this.tabPane = tabPane;
            ListChangeListener<Tab> listChangeListener = new ListChangeListener<Tab>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends Tab> change) {
                    while (change.next()) {
                        for (Tab tab : change.getRemoved()) {
                            if (tab == null || TabPaneSelectionModel.this.tabPane.getTabs().contains(tab)) continue;
                            if (TabPaneSelectionModel.this.getSelectedIndex() == 0 && TabPaneSelectionModel.this.tabPane.getTabs().size() > 0) {
                                TabPaneSelectionModel.this.clearAndSelect(0);
                                tab.setSelected(false);
                            }
                            if (!tab.isSelected()) continue;
                            tab.setSelected(false);
                            if (change.getFrom() == 0) {
                                if (TabPaneSelectionModel.this.tabPane.getTabs().size() <= 1) continue;
                                TabPaneSelectionModel.this.clearSelection();
                                continue;
                            }
                            TabPaneSelectionModel.this.selectPrevious();
                        }
                        if (!change.wasAdded() && !change.wasRemoved() || TabPaneSelectionModel.this.getSelectedIndex() == TabPaneSelectionModel.this.tabPane.getTabs().indexOf(TabPaneSelectionModel.this.getSelectedItem())) continue;
                        TabPaneSelectionModel.this.clearAndSelect(TabPaneSelectionModel.this.tabPane.getTabs().indexOf(TabPaneSelectionModel.this.getSelectedItem()));
                    }
                    if (TabPaneSelectionModel.this.getSelectedIndex() == -1 && TabPaneSelectionModel.this.getSelectedItem() == null && TabPaneSelectionModel.this.tabPane.getTabs().size() > 0) {
                        TabPaneSelectionModel.this.selectFirst();
                    } else if (TabPaneSelectionModel.this.tabPane.getTabs().isEmpty()) {
                        TabPaneSelectionModel.this.clearSelection();
                    }
                }
            };
            if (this.tabPane.getTabs() != null) {
                this.tabPane.getTabs().addListener(listChangeListener);
            }
        }

        @Override
        public void select(int n) {
            if (n < 0 || this.getItemCount() > 0 && n >= this.getItemCount() || n == this.getSelectedIndex() && this.getModelItem(n).isSelected()) {
                return;
            }
            if (this.getSelectedIndex() >= 0 && this.getSelectedIndex() < this.tabPane.getTabs().size()) {
                ((Tab)this.tabPane.getTabs().get(this.getSelectedIndex())).setSelected(false);
            }
            this.setSelectedIndex(n);
            Tab tab = this.getModelItem(n);
            if (tab != null) {
                this.setSelectedItem(tab);
            }
            if (this.getSelectedIndex() >= 0 && this.getSelectedIndex() < this.tabPane.getTabs().size()) {
                ((Tab)this.tabPane.getTabs().get(this.getSelectedIndex())).setSelected(true);
            }
        }

        @Override
        public void select(Tab tab) {
            int n = this.getItemCount();
            for (int i = 0; i < n; ++i) {
                Tab tab2 = this.getModelItem(i);
                if (tab2 == null || !tab2.equals(tab)) continue;
                this.select(i);
                return;
            }
            if (tab != null) {
                this.setSelectedItem(tab);
            }
        }

        @Override
        protected Tab getModelItem(int n) {
            ObservableList<Tab> observableList = this.tabPane.getTabs();
            if (observableList == null) {
                return null;
            }
            if (n < 0 || n >= observableList.size()) {
                return null;
            }
            return (Tab)observableList.get(n);
        }

        @Override
        protected int getItemCount() {
            ObservableList<Tab> observableList = this.tabPane.getTabs();
            return observableList == null ? 0 : observableList.size();
        }
    }
}

