/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CellUtils;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class CheckBoxTreeCell<T>
extends TreeCell<T> {
    private final CheckBox checkBox;
    private ObservableValue<Boolean> booleanProperty;
    private BooleanProperty indeterminateProperty;
    private ObjectProperty<StringConverter<TreeItem<T>>> converter = new SimpleObjectProperty<StringConverter<TreeItem<T>>>(this, "converter");
    private ObjectProperty<Callback<TreeItem<T>, ObservableValue<Boolean>>> selectedStateCallback = new SimpleObjectProperty<Callback<TreeItem<T>, ObservableValue<Boolean>>>(this, "selectedStateCallback");

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView() {
        Callback callback = new Callback<TreeItem<T>, ObservableValue<Boolean>>(){

            @Override
            public ObservableValue<Boolean> call(TreeItem<T> treeItem) {
                if (treeItem instanceof CheckBoxTreeItem) {
                    return ((CheckBoxTreeItem)treeItem).selectedProperty();
                }
                return null;
            }
        };
        Callback callback2 = new Callback<TreeItem<T>, ObservableValue<Boolean>>(){

            @Override
            public ObservableValue<Boolean> call(TreeItem<T> treeItem) {
                if (treeItem instanceof CheckBoxTreeItem) {
                    return ((CheckBoxTreeItem)treeItem).indeterminateProperty();
                }
                return null;
            }
        };
        return CheckBoxTreeCell.forTreeView(callback, CellUtils.defaultTreeItemStringConverter(), callback2);
    }

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(Callback<TreeItem<T>, ObservableValue<Boolean>> callback) {
        return CheckBoxTreeCell.forTreeView(callback, CellUtils.defaultTreeItemStringConverter());
    }

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(Callback<TreeItem<T>, ObservableValue<Boolean>> callback, StringConverter<TreeItem<T>> stringConverter) {
        return CheckBoxTreeCell.forTreeView(callback, stringConverter, null);
    }

    private static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(final Callback<TreeItem<T>, ObservableValue<Boolean>> callback, final StringConverter<TreeItem<T>> stringConverter, Callback<TreeItem<T>, ObservableValue<Boolean>> callback2) {
        return new Callback<TreeView<T>, TreeCell<T>>(){

            @Override
            public TreeCell<T> call(TreeView<T> treeView) {
                return new CheckBoxTreeCell(callback, stringConverter);
            }
        };
    }

    public CheckBoxTreeCell() {
        this(new Callback<TreeItem<T>, ObservableValue<Boolean>>(){

            @Override
            public ObservableValue<Boolean> call(TreeItem<T> treeItem) {
                if (treeItem instanceof CheckBoxTreeItem) {
                    return ((CheckBoxTreeItem)treeItem).selectedProperty();
                }
                return null;
            }
        });
    }

    public CheckBoxTreeCell(Callback<TreeItem<T>, ObservableValue<Boolean>> callback) {
        this(callback, CellUtils.defaultTreeItemStringConverter(), null);
    }

    public CheckBoxTreeCell(Callback<TreeItem<T>, ObservableValue<Boolean>> callback, StringConverter<TreeItem<T>> stringConverter) {
        this(callback, stringConverter, null);
    }

    private CheckBoxTreeCell(Callback<TreeItem<T>, ObservableValue<Boolean>> callback, StringConverter<TreeItem<T>> stringConverter, Callback<TreeItem<T>, ObservableValue<Boolean>> callback2) {
        if (callback == null) {
            throw new NullPointerException("getSelectedProperty can not be null");
        }
        this.getStyleClass().add("choice-box-tree-cell");
        this.setSelectedStateCallback(callback);
        this.setConverter(stringConverter);
        this.checkBox = new CheckBox();
        this.checkBox.setAllowIndeterminate(false);
        this.setGraphic(this.checkBox);
    }

    public final ObjectProperty<StringConverter<TreeItem<T>>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<TreeItem<T>> stringConverter) {
        this.converterProperty().set(stringConverter);
    }

    public final StringConverter<TreeItem<T>> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public final ObjectProperty<Callback<TreeItem<T>, ObservableValue<Boolean>>> selectedStateCallbackProperty() {
        return this.selectedStateCallback;
    }

    public final void setSelectedStateCallback(Callback<TreeItem<T>, ObservableValue<Boolean>> callback) {
        this.selectedStateCallbackProperty().set(callback);
    }

    public final Callback<TreeItem<T>, ObservableValue<Boolean>> getSelectedStateCallback() {
        return (Callback)this.selectedStateCallbackProperty().get();
    }

    @Override
    public void updateItem(T t, boolean bl) {
        super.updateItem(t, bl);
        if (bl) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            StringConverter stringConverter = this.getConverter();
            Callback<TreeItem<T>, ObservableValue<Boolean>> callback = this.getSelectedStateCallback();
            this.setText(stringConverter.toString(this.getTreeItem()));
            this.setGraphic(this.checkBox);
            if (this.booleanProperty != null) {
                this.checkBox.selectedProperty().unbindBidirectional((BooleanProperty)this.booleanProperty);
            }
            if (this.indeterminateProperty != null) {
                this.checkBox.indeterminateProperty().unbindBidirectional(this.indeterminateProperty);
            }
            if (this.getTreeItem() instanceof CheckBoxTreeItem) {
                CheckBoxTreeItem checkBoxTreeItem = (CheckBoxTreeItem)this.getTreeItem();
                this.booleanProperty = checkBoxTreeItem.selectedProperty();
                this.checkBox.selectedProperty().bindBidirectional((BooleanProperty)this.booleanProperty);
                this.indeterminateProperty = checkBoxTreeItem.indeterminateProperty();
                this.checkBox.indeterminateProperty().bindBidirectional(this.indeterminateProperty);
            } else {
                this.booleanProperty = callback.call(this.getTreeItem());
                if (this.booleanProperty != null) {
                    this.checkBox.selectedProperty().bindBidirectional((BooleanProperty)this.booleanProperty);
                }
            }
        }
    }
}

