/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordSession;
import org.parosproxy.paros.db.TableSession;
import org.parosproxy.paros.db.paros.ParosAbstractTable;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class ParosTableSession
extends ParosAbstractTable
implements TableSession {
    private static final String SESSIONID = "SESSIONID";
    private static final String SESSIONNAME = "SESSIONNAME";
    private static final String LASTACCESS = "LASTACCESS";
    private PreparedStatement psReadDate = null;
    private PreparedStatement psReadAll = null;
    private PreparedStatement psInsert = null;
    private PreparedStatement psUpdate = null;

    @Override
    protected void reconnect(Connection connection) throws DatabaseException {
        try {
            this.psReadDate = connection.prepareStatement("SELECT * FROM SESSION WHERE LASTACCESS < ?");
            this.psReadAll = connection.prepareStatement("SELECT * FROM SESSION");
            this.psInsert = connection.prepareStatement("INSERT INTO SESSION (SESSIONID,SESSIONNAME) VALUES (?, ?)");
            this.psUpdate = connection.prepareStatement("UPDATE SESSION SET SESSIONNAME = ?,LASTACCESS = NOW WHERE SESSIONID = ?");
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void insert(long l, String string) throws DatabaseException {
        try {
            this.psInsert.setLong(1, l);
            this.psInsert.setString(2, string);
            this.psInsert.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void update(long l, String string) throws DatabaseException {
        try {
            this.psUpdate.setLong(2, l);
            this.psUpdate.setString(1, string);
            this.psUpdate.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public List<RecordSession> listSessions() throws DatabaseException {
        return null;
    }

    private RecordSession build(ResultSet resultSet) throws HttpMalformedHeaderException, SQLException {
        RecordSession recordSession = null;
        if (resultSet.next()) {
            recordSession = new RecordSession(resultSet.getLong(SESSIONID), resultSet.getString(SESSIONNAME), resultSet.getDate(LASTACCESS));
        }
        return recordSession;
    }
}

