/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.text;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.apache.log4j.Logger;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.view.HighlightSearchEntry;
import org.zaproxy.zap.view.HighlighterManager;

public abstract class HttpPanelTextArea
extends ZapTextArea
implements Observer {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(HttpPanelTextArea.class);
    private Message message = null;

    public HttpPanelTextArea() {
        this.initHighlighter();
    }

    private void initHighlighter() {
        HighlighterManager highlighterManager = HighlighterManager.getInstance();
        highlighterManager.addObserver(this);
        if (this.message != null) {
            this.highlightAll();
        }
    }

    private void highlightAll() {
        HighlighterManager highlighterManager = HighlighterManager.getInstance();
        LinkedList<HighlightSearchEntry> linkedList = highlighterManager.getHighlights();
        for (HighlightSearchEntry highlightSearchEntry : linkedList) {
            this.highlightEntryParser(highlightSearchEntry);
        }
    }

    private void highlightEntryParser(HighlightSearchEntry highlightSearchEntry) {
        int n = 0;
        String string = this.getText();
        Highlighter highlighter = this.getHighlighter();
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(highlightSearchEntry.getColor());
        while ((n = string.indexOf(highlightSearchEntry.getToken(), n)) > -1) {
            try {
                highlighter.addHighlight(n, n + highlightSearchEntry.getToken().length(), defaultHighlightPainter);
                n += highlightSearchEntry.getToken().length();
            }
            catch (BadLocationException badLocationException) {
                log.warn((Object)"Could not highlight entry", (Throwable)badLocationException);
            }
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.highlightAll();
    }

    protected void highlight(int n, int n2) {
        Highlighter highlighter = this.getHighlighter();
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.LIGHT_GRAY);
        try {
            this.removeAllHighlights();
            highlighter.addHighlight(n, n2, defaultHighlightPainter);
            this.setCaretPosition(n);
        }
        catch (BadLocationException badLocationException) {
            log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
        }
    }

    private void removeAllHighlights() {
        Highlighter highlighter = this.getHighlighter();
        highlighter.removeAllHighlights();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object == null) {
            this.removeAllHighlights();
            this.highlightAll();
        } else {
            HighlightSearchEntry highlightSearchEntry = (HighlightSearchEntry)object;
            this.highlightEntryParser(highlightSearchEntry);
        }
        this.invalidate();
    }

    public abstract void search(Pattern var1, List<SearchMatch> var2);

    public abstract void highlight(SearchMatch var1);

    public void setMessage(Message message) {
        this.message = message;
    }

    public Message getMessage() {
        return this.message;
    }
}

