/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zaproxy.zap.utils.Statistics;
import org.zaproxy.zap.utils.StatsListener;

public class InMemoryStats
implements StatsListener {
    private Statistics stats = new Statistics();
    private Map<String, Statistics> siteStats = new HashMap<String, Statistics>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statistics getStatistics(String string) {
        if (string == null) {
            return this.stats;
        }
        if (!this.siteStats.containsKey(string)) {
            Map<String, Statistics> map = this.siteStats;
            synchronized (map) {
                if (!this.siteStats.containsKey(string)) {
                    this.siteStats.put(string, new Statistics());
                }
            }
        }
        return this.siteStats.get(string);
    }

    @Override
    public void counterInc(String string) {
        this.counterInc(null, string);
    }

    @Override
    public void counterInc(String string, String string2) {
        this.getStatistics(string).incCounter(string2);
    }

    @Override
    public void counterInc(String string, long l) {
        this.counterInc(null, string, l);
    }

    @Override
    public void counterInc(String string, String string2, long l) {
        this.getStatistics(string).incCounter(string2, l);
    }

    @Override
    public void counterDec(String string) {
        this.counterDec(null, string);
    }

    @Override
    public void counterDec(String string, String string2) {
        this.getStatistics(string).decCounter(string2);
    }

    @Override
    public void counterDec(String string, long l) {
        this.counterDec(null, string, l);
    }

    @Override
    public void counterDec(String string, String string2, long l) {
        this.getStatistics(string).decCounter(string2, l);
    }

    @Override
    public void highwaterMarkSet(String string, long l) {
        this.highwaterMarkSet(null, string, l);
    }

    @Override
    public void highwaterMarkSet(String string, String string2, long l) {
        this.getStatistics(string).setHighwaterMark(string2, l);
    }

    @Override
    public void lowwaterMarkSet(String string, long l) {
        this.lowwaterMarkSet(null, string, l);
    }

    @Override
    public void lowwaterMarkSet(String string, String string2, long l) {
        this.getStatistics(string).setLowwaterMark(string2, l);
    }

    @Override
    public void allCleared() {
        this.stats.clearAll();
        for (Statistics statistics : this.siteStats.values()) {
            statistics.clearAll();
        }
        this.siteStats.clear();
    }

    @Override
    public void allCleared(String string) {
        this.getStatistics(string).clearAll();
    }

    @Override
    public void cleared(String string) {
        this.stats.clear(string);
        for (Statistics statistics : this.siteStats.values()) {
            statistics.clear(string);
        }
    }

    @Override
    public void cleared(String string, String string2) {
        this.getStatistics(string).clear(string2);
    }

    public Long getStat(String string) {
        return this.stats.getStat(string);
    }

    public Long getStat(String string, String string2) {
        if (string == null || this.siteStats.containsKey(string)) {
            return this.getStatistics(string).getStat(string2);
        }
        return null;
    }

    public Map<String, Long> getStats(String string) {
        return this.stats.getStats(string);
    }

    public Map<String, Map<String, Long>> getAllSiteStats(String string) {
        HashMap<String, Map<String, Long>> hashMap = new HashMap<String, Map<String, Long>>();
        for (Map.Entry<String, Statistics> entry : this.siteStats.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().getStats(string));
        }
        return hashMap;
    }

    public Map<String, Long> getSiteStats(String string, String string2) {
        if (this.siteStats.containsKey(string)) {
            return this.getStatistics(string).getStats(string2);
        }
        return new HashMap<String, Long>();
    }

    public List<String> getSites() {
        ArrayList<String> arrayList = new ArrayList<String>(this.siteStats.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }
}

