/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public class Logger {
    private static final Handler[] emptyHandlers = new Handler[0];
    private static final int offValue = Level.OFF.intValue();
    static final String SYSTEM_LOGGER_RB_NAME = "sun.util.logging.resources.logging";
    private static final LoggerBundle SYSTEM_BUNDLE = new LoggerBundle("sun.util.logging.resources.logging", null);
    private static final LoggerBundle NO_RESOURCE_BUNDLE = new LoggerBundle(null, null);
    private volatile LogManager manager;
    private String name;
    private final CopyOnWriteArrayList<Handler> handlers = new CopyOnWriteArrayList();
    private volatile LoggerBundle loggerBundle = NO_RESOURCE_BUNDLE;
    private volatile boolean useParentHandlers = true;
    private volatile Filter filter;
    private boolean anonymous;
    private ResourceBundle catalog;
    private String catalogName;
    private Locale catalogLocale;
    private static final Object treeLock = new Object();
    private volatile Logger parent;
    private ArrayList<LogManager.LoggerWeakRef> kids;
    private volatile Level levelObject;
    private volatile int levelValue;
    private WeakReference<ClassLoader> callersClassLoaderRef;
    private final boolean isSystemLogger;
    public static final String GLOBAL_LOGGER_NAME = "global";
    @Deprecated
    public static final Logger global = new Logger("global");

    public static final Logger getGlobal() {
        LogManager.getLogManager();
        return global;
    }

    protected Logger(String string, String string2) {
        this(string, string2, null, LogManager.getLogManager(), false);
    }

    Logger(String string, String string2, Class<?> clazz, LogManager logManager, boolean bl) {
        this.manager = logManager;
        this.isSystemLogger = bl;
        this.setupResourceInfo(string2, clazz);
        this.name = string;
        this.levelValue = Level.INFO.intValue();
    }

    private void setCallersClassLoaderRef(Class<?> clazz) {
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = clazz != null ? clazz.getClassLoader() : null;
        if (classLoader != null) {
            this.callersClassLoaderRef = new WeakReference<ClassLoader>(classLoader);
        }
    }

    private ClassLoader getCallersClassLoader() {
        return this.callersClassLoaderRef != null ? (ClassLoader)this.callersClassLoaderRef.get() : null;
    }

    private Logger(String string) {
        this.name = string;
        this.isSystemLogger = true;
        this.levelValue = Level.INFO.intValue();
    }

    void setLogManager(LogManager logManager) {
        this.manager = logManager;
    }

    private void checkPermission() throws SecurityException {
        if (!this.anonymous) {
            if (this.manager == null) {
                this.manager = LogManager.getLogManager();
            }
            this.manager.checkPermission();
        }
    }

    private static Logger demandLogger(String string, String string2, Class<?> clazz) {
        LogManager logManager = LogManager.getLogManager();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && !SystemLoggerHelper.disableCallerCheck && clazz.getClassLoader() == null) {
            return logManager.demandSystemLogger(string, string2);
        }
        return logManager.demandLogger(string, string2, clazz);
    }

    @CallerSensitive
    public static Logger getLogger(String string) {
        return Logger.demandLogger(string, null, Reflection.getCallerClass());
    }

    @CallerSensitive
    public static Logger getLogger(String string, String string2) {
        Class<?> clazz = Reflection.getCallerClass();
        Logger logger = Logger.demandLogger(string, string2, clazz);
        logger.setupResourceInfo(string2, clazz);
        return logger;
    }

    static Logger getPlatformLogger(String string) {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.demandSystemLogger(string, SYSTEM_LOGGER_RB_NAME);
        return logger;
    }

    public static Logger getAnonymousLogger() {
        return Logger.getAnonymousLogger(null);
    }

    @CallerSensitive
    public static Logger getAnonymousLogger(String string) {
        LogManager logManager = LogManager.getLogManager();
        logManager.drainLoggerRefQueueBounded();
        Logger logger = new Logger(null, string, Reflection.getCallerClass(), logManager, false);
        logger.anonymous = true;
        Logger logger2 = logManager.getLogger("");
        logger.doSetParent(logger2);
        return logger;
    }

    public ResourceBundle getResourceBundle() {
        return this.findResourceBundle(this.getResourceBundleName(), true);
    }

    public String getResourceBundleName() {
        return this.loggerBundle.resourceBundleName;
    }

    public void setFilter(Filter filter) throws SecurityException {
        this.checkPermission();
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void log(LogRecord logRecord) {
        if (!this.isLoggable(logRecord.getLevel())) {
            return;
        }
        Filter filter = this.filter;
        if (filter != null && !filter.isLoggable(logRecord)) {
            return;
        }
        Logger logger = this;
        while (logger != null) {
            boolean bl;
            Handler[] handlerArray;
            for (Handler handler : handlerArray = this.isSystemLogger ? logger.accessCheckedHandlers() : logger.getHandlers()) {
                handler.publish(logRecord);
            }
            boolean bl2 = bl = this.isSystemLogger ? logger.useParentHandlers : logger.getUseParentHandlers();
            if (!bl) break;
            logger = this.isSystemLogger ? logger.parent : logger.getParent();
        }
    }

    private void doLog(LogRecord logRecord) {
        logRecord.setLoggerName(this.name);
        LoggerBundle loggerBundle = this.getEffectiveLoggerBundle();
        ResourceBundle resourceBundle = loggerBundle.userBundle;
        String string = loggerBundle.resourceBundleName;
        if (string != null && resourceBundle != null) {
            logRecord.setResourceBundleName(string);
            logRecord.setResourceBundle(resourceBundle);
        }
        this.log(logRecord);
    }

    public void log(Level level, String string) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        this.doLog(logRecord);
    }

    public void log(Level level, Supplier<String> supplier) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, supplier.get());
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Object object) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        Object[] objectArray = new Object[]{object};
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Object[] objectArray) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Throwable throwable) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    public void log(Level level, Throwable throwable, Supplier<String> supplier) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, supplier.get());
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, Supplier<String> supplier) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, supplier.get());
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Object object) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        Object[] objectArray = new Object[]{object};
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Object[] objectArray) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Throwable throwable) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, Throwable throwable, Supplier<String> supplier) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, supplier.get());
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    private void doLog(LogRecord logRecord, String string) {
        logRecord.setLoggerName(this.name);
        if (string != null) {
            logRecord.setResourceBundleName(string);
            logRecord.setResourceBundle(this.findResourceBundle(string, false));
        }
        this.log(logRecord);
    }

    private void doLog(LogRecord logRecord, ResourceBundle resourceBundle) {
        logRecord.setLoggerName(this.name);
        if (resourceBundle != null) {
            logRecord.setResourceBundleName(resourceBundle.getBaseBundleName());
            logRecord.setResourceBundle(resourceBundle);
        }
        this.log(logRecord);
    }

    @Deprecated
    public void logrb(Level level, String string, String string2, String string3, String string4) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        this.doLog(logRecord, string3);
    }

    @Deprecated
    public void logrb(Level level, String string, String string2, String string3, String string4, Object object) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        Object[] objectArray = new Object[]{object};
        logRecord.setParameters(objectArray);
        this.doLog(logRecord, string3);
    }

    @Deprecated
    public void logrb(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setParameters(objectArray);
        this.doLog(logRecord, string3);
    }

    public void logrb(Level level, String string, String string2, ResourceBundle resourceBundle, String string3, Object ... objectArray) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        if (objectArray != null && objectArray.length != 0) {
            logRecord.setParameters(objectArray);
        }
        this.doLog(logRecord, resourceBundle);
    }

    @Deprecated
    public void logrb(Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord, string3);
    }

    public void logrb(Level level, String string, String string2, ResourceBundle resourceBundle, String string3, Throwable throwable) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord, resourceBundle);
    }

    public void entering(String string, String string2) {
        this.logp(Level.FINER, string, string2, "ENTRY");
    }

    public void entering(String string, String string2, Object object) {
        this.logp(Level.FINER, string, string2, "ENTRY {0}", object);
    }

    public void entering(String string, String string2, Object[] objectArray) {
        String string3 = "ENTRY";
        if (objectArray == null) {
            this.logp(Level.FINER, string, string2, string3);
            return;
        }
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            string3 = string3 + " {" + i + "}";
        }
        this.logp(Level.FINER, string, string2, string3, objectArray);
    }

    public void exiting(String string, String string2) {
        this.logp(Level.FINER, string, string2, "RETURN");
    }

    public void exiting(String string, String string2, Object object) {
        this.logp(Level.FINER, string, string2, "RETURN {0}", object);
    }

    public void throwing(String string, String string2, Throwable throwable) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        LogRecord logRecord = new LogRecord(Level.FINER, "THROW");
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    public void severe(String string) {
        this.log(Level.SEVERE, string);
    }

    public void warning(String string) {
        this.log(Level.WARNING, string);
    }

    public void info(String string) {
        this.log(Level.INFO, string);
    }

    public void config(String string) {
        this.log(Level.CONFIG, string);
    }

    public void fine(String string) {
        this.log(Level.FINE, string);
    }

    public void finer(String string) {
        this.log(Level.FINER, string);
    }

    public void finest(String string) {
        this.log(Level.FINEST, string);
    }

    public void severe(Supplier<String> supplier) {
        this.log(Level.SEVERE, supplier);
    }

    public void warning(Supplier<String> supplier) {
        this.log(Level.WARNING, supplier);
    }

    public void info(Supplier<String> supplier) {
        this.log(Level.INFO, supplier);
    }

    public void config(Supplier<String> supplier) {
        this.log(Level.CONFIG, supplier);
    }

    public void fine(Supplier<String> supplier) {
        this.log(Level.FINE, supplier);
    }

    public void finer(Supplier<String> supplier) {
        this.log(Level.FINER, supplier);
    }

    public void finest(Supplier<String> supplier) {
        this.log(Level.FINEST, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(Level level) throws SecurityException {
        this.checkPermission();
        Object object = treeLock;
        synchronized (object) {
            this.levelObject = level;
            this.updateEffectiveLevel();
        }
    }

    final boolean isLevelInitialized() {
        return this.levelObject != null;
    }

    public Level getLevel() {
        return this.levelObject;
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.levelValue && this.levelValue != offValue;
    }

    public String getName() {
        return this.name;
    }

    public void addHandler(Handler handler) throws SecurityException {
        handler.getClass();
        this.checkPermission();
        this.handlers.add(handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        this.checkPermission();
        if (handler == null) {
            return;
        }
        this.handlers.remove(handler);
    }

    public Handler[] getHandlers() {
        return this.accessCheckedHandlers();
    }

    Handler[] accessCheckedHandlers() {
        return this.handlers.toArray(emptyHandlers);
    }

    public void setUseParentHandlers(boolean bl) {
        this.checkPermission();
        this.useParentHandlers = bl;
    }

    public boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    private static ResourceBundle findSystemResourceBundle(final Locale locale) {
        return AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

            @Override
            public ResourceBundle run() {
                try {
                    return ResourceBundle.getBundle(Logger.SYSTEM_LOGGER_RB_NAME, locale, ClassLoader.getSystemClassLoader());
                }
                catch (MissingResourceException missingResourceException) {
                    throw new InternalError(missingResourceException.toString());
                }
            }
        });
    }

    private synchronized ResourceBundle findResourceBundle(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        Locale locale = Locale.getDefault();
        LoggerBundle loggerBundle = this.loggerBundle;
        if (loggerBundle.userBundle != null && string.equals(loggerBundle.resourceBundleName)) {
            return loggerBundle.userBundle;
        }
        if (this.catalog != null && locale.equals(this.catalogLocale) && string.equals(this.catalogName)) {
            return this.catalog;
        }
        if (string.equals(SYSTEM_LOGGER_RB_NAME)) {
            this.catalog = Logger.findSystemResourceBundle(locale);
            this.catalogName = string;
            this.catalogLocale = locale;
            return this.catalog;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            this.catalog = ResourceBundle.getBundle(string, locale, classLoader);
            this.catalogName = string;
            this.catalogLocale = locale;
            return this.catalog;
        }
        catch (MissingResourceException missingResourceException) {
            if (bl) {
                ClassLoader classLoader2 = this.getCallersClassLoader();
                if (classLoader2 == null || classLoader2 == classLoader) {
                    return null;
                }
                try {
                    this.catalog = ResourceBundle.getBundle(string, locale, classLoader2);
                    this.catalogName = string;
                    this.catalogLocale = locale;
                    return this.catalog;
                }
                catch (MissingResourceException missingResourceException2) {
                    return null;
                }
            }
            return null;
        }
    }

    private synchronized void setupResourceInfo(String string, Class<?> clazz) {
        LoggerBundle loggerBundle = this.loggerBundle;
        if (loggerBundle.resourceBundleName != null) {
            if (loggerBundle.resourceBundleName.equals(string)) {
                return;
            }
            throw new IllegalArgumentException(loggerBundle.resourceBundleName + " != " + string);
        }
        if (string == null) {
            return;
        }
        this.setCallersClassLoaderRef(clazz);
        if (this.isSystemLogger && this.getCallersClassLoader() != null) {
            this.checkPermission();
        }
        if (this.findResourceBundle(string, true) == null) {
            this.callersClassLoaderRef = null;
            throw new MissingResourceException("Can't find " + string + " bundle", string, "");
        }
        assert (loggerBundle.userBundle == null);
        this.loggerBundle = LoggerBundle.get(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.checkPermission();
        String string = resourceBundle.getBaseBundleName();
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("resource bundle must have a name");
        }
        Logger logger = this;
        synchronized (logger) {
            boolean bl;
            LoggerBundle loggerBundle = this.loggerBundle;
            boolean bl2 = bl = loggerBundle.resourceBundleName == null || loggerBundle.resourceBundleName.equals(string);
            if (!bl) {
                throw new IllegalArgumentException("can't replace resource bundle");
            }
            this.loggerBundle = LoggerBundle.get(string, resourceBundle);
        }
    }

    public Logger getParent() {
        return this.parent;
    }

    public void setParent(Logger logger) {
        if (logger == null) {
            throw new NullPointerException();
        }
        if (this.manager == null) {
            this.manager = LogManager.getLogManager();
        }
        this.manager.checkPermission();
        this.doSetParent(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetParent(Logger logger) {
        Object object = treeLock;
        synchronized (object) {
            LogManager.LoggerWeakRef loggerWeakRef = null;
            if (this.parent != null) {
                Iterator<LogManager.LoggerWeakRef> iterator = this.parent.kids.iterator();
                while (iterator.hasNext()) {
                    loggerWeakRef = iterator.next();
                    Logger logger2 = (Logger)loggerWeakRef.get();
                    if (logger2 == this) {
                        iterator.remove();
                        break;
                    }
                    loggerWeakRef = null;
                }
            }
            this.parent = logger;
            if (this.parent.kids == null) {
                this.parent.kids = new ArrayList(2);
            }
            if (loggerWeakRef == null) {
                LogManager logManager = this.manager;
                logManager.getClass();
                loggerWeakRef = logManager.new LogManager.LoggerWeakRef(this);
            }
            loggerWeakRef.setParentRef(new WeakReference<Logger>(this.parent));
            this.parent.kids.add(loggerWeakRef);
            this.updateEffectiveLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeChildLogger(LogManager.LoggerWeakRef loggerWeakRef) {
        Object object = treeLock;
        synchronized (object) {
            Iterator<LogManager.LoggerWeakRef> iterator = this.kids.iterator();
            while (iterator.hasNext()) {
                LogManager.LoggerWeakRef loggerWeakRef2 = iterator.next();
                if (loggerWeakRef2 != loggerWeakRef) continue;
                iterator.remove();
                return;
            }
        }
    }

    private void updateEffectiveLevel() {
        int n = this.levelObject != null ? this.levelObject.intValue() : (this.parent != null ? this.parent.levelValue : Level.INFO.intValue());
        if (this.levelValue == n) {
            return;
        }
        this.levelValue = n;
        if (this.kids != null) {
            for (int i = 0; i < this.kids.size(); ++i) {
                LogManager.LoggerWeakRef loggerWeakRef = this.kids.get(i);
                Logger logger = (Logger)loggerWeakRef.get();
                if (logger == null) continue;
                logger.updateEffectiveLevel();
            }
        }
    }

    private LoggerBundle getEffectiveLoggerBundle() {
        LoggerBundle loggerBundle = this.loggerBundle;
        if (loggerBundle.isSystemBundle()) {
            return SYSTEM_BUNDLE;
        }
        ResourceBundle resourceBundle = this.getResourceBundle();
        if (resourceBundle != null && resourceBundle == loggerBundle.userBundle) {
            return loggerBundle;
        }
        if (resourceBundle != null) {
            String string = this.getResourceBundleName();
            return LoggerBundle.get(string, resourceBundle);
        }
        Logger logger = this.parent;
        while (logger != null) {
            String string;
            LoggerBundle loggerBundle2 = logger.loggerBundle;
            if (loggerBundle2.isSystemBundle()) {
                return SYSTEM_BUNDLE;
            }
            if (loggerBundle2.userBundle != null) {
                return loggerBundle2;
            }
            String string2 = this.isSystemLogger ? (logger.isSystemLogger ? loggerBundle2.resourceBundleName : null) : (string = logger.getResourceBundleName());
            if (string != null) {
                return LoggerBundle.get(string, this.findResourceBundle(string, true));
            }
            logger = this.isSystemLogger ? logger.parent : logger.getParent();
        }
        return NO_RESOURCE_BUNDLE;
    }

    private static class SystemLoggerHelper {
        static boolean disableCallerCheck = SystemLoggerHelper.getBooleanProperty("sun.util.logging.disableCallerCheck");

        private SystemLoggerHelper() {
        }

        private static boolean getBooleanProperty(final String string) {
            String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(string);
                }
            });
            return Boolean.valueOf(string2);
        }
    }

    private static final class LoggerBundle {
        final String resourceBundleName;
        final ResourceBundle userBundle;

        private LoggerBundle(String string, ResourceBundle resourceBundle) {
            this.resourceBundleName = string;
            this.userBundle = resourceBundle;
        }

        boolean isSystemBundle() {
            return Logger.SYSTEM_LOGGER_RB_NAME.equals(this.resourceBundleName);
        }

        static LoggerBundle get(String string, ResourceBundle resourceBundle) {
            if (string == null && resourceBundle == null) {
                return NO_RESOURCE_BUNDLE;
            }
            if (Logger.SYSTEM_LOGGER_RB_NAME.equals(string) && resourceBundle == null) {
                return SYSTEM_BUNDLE;
            }
            return new LoggerBundle(string, resourceBundle);
        }
    }
}

