#ifndef _ELDBUS_TYPES_EOT_H_
#define _ELDBUS_TYPES_EOT_H_

#ifndef _ELDBUS_TYPES_EOT_TYPES
#define _ELDBUS_TYPES_EOT_TYPES

typedef struct _Eldbus_Proxy Eldbus_Proxy;

/** Represents a connection of one the type of connection with the DBus daemon.
 *
 * @ingroup Eldbus
 */
typedef struct _Eldbus_Connection Eldbus_Connection;

/** Represents an object path already attached with bus name or unique id
 *
 * @ingroup Eldbus
 */
typedef struct _Eldbus_Object Eldbus_Object;

typedef enum
{
  ELDBUS_INTROSPECTION_ARGUMENT_DIRECTION_NONE = 0,
  ELDBUS_INTROSPECTION_ARGUMENT_DIRECTION_IN,
  ELDBUS_INTROSPECTION_ARGUMENT_DIRECTION_OUT
} Eldbus_Introspection_Argument_Direction;

typedef enum
{
  ELDBUS_INTROSPECTION_PROPERTY_ACCESS_READ = 0,
  ELDBUS_INTROSPECTION_PROPERTY_ACCESS_WRITE,
  ELDBUS_INTROSPECTION_PROPERTY_ACCESS_READWRITE
} Eldbus_Introspection_Property_Access;

typedef struct _Eldbus_Introspection_Node
{
  Eina_Stringshare *name; /** optional */
  Eina_List *nodes;
  Eina_List *interfaces;
} Eldbus_Introspection_Node;

typedef struct _Eldbus_Introspection_Interface
{
  Eina_Stringshare *name;
  Eina_List *methods;
  Eina_List *signals;
  Eina_List *properties;
  Eina_List *annotations;
} Eldbus_Introspection_Interface;

typedef struct _Eldbus_Introspection_Method
{
  Eina_Stringshare *name;
  Eina_List *arguments;
  Eina_List *annotations;
} Eldbus_Introspection_Method;

typedef struct _Eldbus_Introspection_Property
{
  Eina_Stringshare *name;
  Eina_Stringshare *type;
  Eldbus_Introspection_Property_Access access;
  Eina_List *annotations;
} Eldbus_Introspection_Property;

typedef struct _Eldbus_Introspection_Annotation
{
  Eina_Stringshare *name;
  Eina_Stringshare *value;
} Eldbus_Introspection_Annotation;

typedef struct _Eldbus_Introspection_Argument
{
  Eina_Stringshare *name; /** Optional */
  Eina_Stringshare *type;
  Eldbus_Introspection_Argument_Direction direction;
} Eldbus_Introspection_Argument;

typedef struct _Eldbus_Introspection_Signal
{
  Eina_Stringshare *name;
  Eina_List *arguments;
  Eina_List *annotations;
} Eldbus_Introspection_Signal;


#endif

#endif
