/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.State;
import sun.security.provider.certpath.UntrustedChecker;
import sun.security.util.Debug;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

class ForwardState
implements State {
    private static final Debug debug = Debug.getInstance("certpath");
    X500Principal issuerDN;
    X509CertImpl cert;
    HashSet<GeneralNameInterface> subjectNamesTraversed;
    int traversedCACerts;
    private boolean init = true;
    public CrlRevocationChecker crlChecker;
    UntrustedChecker untrustedChecker;
    ArrayList<PKIXCertPathChecker> forwardCheckers;
    boolean keyParamsNeededFlag = false;

    ForwardState() {
    }

    @Override
    public boolean isInitial() {
        return this.init;
    }

    @Override
    public boolean keyParamsNeeded() {
        return this.keyParamsNeededFlag;
    }

    public String toString() {
        StringBuffer sb;
        block2: {
            sb = new StringBuffer();
            try {
                sb.append("State [");
                sb.append("\n  issuerDN of last cert: " + this.issuerDN);
                sb.append("\n  traversedCACerts: " + this.traversedCACerts);
                sb.append("\n  init: " + String.valueOf(this.init));
                sb.append("\n  keyParamsNeeded: " + String.valueOf(this.keyParamsNeededFlag));
                sb.append("\n  subjectNamesTraversed: \n" + this.subjectNamesTraversed);
                sb.append("]\n");
            }
            catch (Exception e) {
                if (debug == null) break block2;
                debug.println("ForwardState.toString() unexpected exception");
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public void initState(List<PKIXCertPathChecker> certPathCheckers) throws CertPathValidatorException {
        this.subjectNamesTraversed = new HashSet();
        this.traversedCACerts = 0;
        this.forwardCheckers = new ArrayList();
        if (certPathCheckers != null) {
            for (PKIXCertPathChecker checker : certPathCheckers) {
                if (!checker.isForwardCheckingSupported()) continue;
                checker.init(true);
                this.forwardCheckers.add(checker);
            }
        }
        this.init = true;
    }

    @Override
    public void updateState(X509Certificate cert) throws CertificateException, IOException, CertPathValidatorException {
        if (cert == null) {
            return;
        }
        X509CertImpl icert = X509CertImpl.toImpl(cert);
        PublicKey newKey = icert.getPublicKey();
        if (newKey instanceof DSAPublicKey && ((DSAPublicKey)newKey).getParams() == null) {
            this.keyParamsNeededFlag = true;
        }
        this.cert = icert;
        this.issuerDN = cert.getIssuerX500Principal();
        if (!X509CertImpl.isSelfIssued(cert) && !this.init && cert.getBasicConstraints() != -1) {
            ++this.traversedCACerts;
        }
        if (this.init || !X509CertImpl.isSelfIssued(cert)) {
            X500Principal subjName = cert.getSubjectX500Principal();
            this.subjectNamesTraversed.add(X500Name.asX500Name(subjName));
            try {
                SubjectAlternativeNameExtension subjAltNameExt = icert.getSubjectAlternativeNameExtension();
                if (subjAltNameExt != null) {
                    GeneralNames gNames = (GeneralNames)subjAltNameExt.get("subject_name");
                    Iterator<GeneralName> t = gNames.iterator();
                    while (t.hasNext()) {
                        GeneralNameInterface gName = t.next().getName();
                        this.subjectNamesTraversed.add(gName);
                    }
                }
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.println("ForwardState.updateState() unexpected exception");
                    e.printStackTrace();
                }
                throw new CertPathValidatorException(e);
            }
        }
        this.init = false;
    }

    @Override
    public Object clone() {
        try {
            ForwardState clonedState = (ForwardState)super.clone();
            clonedState.forwardCheckers = (ArrayList)this.forwardCheckers.clone();
            ListIterator<PKIXCertPathChecker> li = clonedState.forwardCheckers.listIterator();
            while (li.hasNext()) {
                PKIXCertPathChecker checker = li.next();
                if (!(checker instanceof Cloneable)) continue;
                li.set((PKIXCertPathChecker)checker.clone());
            }
            clonedState.subjectNamesTraversed = (HashSet)this.subjectNamesTraversed.clone();
            return clonedState;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }
}

