/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate.extensions;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.render.intermediate.extensions.AbstractAction;

public class ActionSet {
    private int lastGeneratedID;
    private Map actionRegistry = new HashMap();

    public synchronized String generateNewID(AbstractAction action) {
        ++this.lastGeneratedID;
        String prefix = action.getIDPrefix();
        if (prefix == null) {
            throw new IllegalArgumentException("Action class is not compatible");
        }
        return prefix + this.lastGeneratedID;
    }

    public AbstractAction get(String id) {
        return (AbstractAction)this.actionRegistry.get(id);
    }

    public AbstractAction put(AbstractAction action) {
        AbstractAction effAction;
        if (!action.hasID()) {
            action.setID(this.generateNewID(action));
        }
        if ((effAction = this.normalize(action)) == action) {
            this.actionRegistry.put(action.getID(), action);
        }
        return effAction;
    }

    public void clear() {
        this.actionRegistry.clear();
    }

    private AbstractAction normalize(AbstractAction action) {
        for (AbstractAction a : this.actionRegistry.values()) {
            if (!a.isSame(action)) continue;
            return a;
        }
        return action;
    }
}

