/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import com.google.common.hash.HashCode;
import java.util.Map;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.Serializer;

public class JarSnapshotDataSerializer
implements Serializer<JarSnapshotData> {
    private final MapSerializer<String, HashCode> mapSerializer;
    private final Serializer<ClassSetAnalysisData> analysisSerializer;
    private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();

    public JarSnapshotDataSerializer() {
        this.mapSerializer = new MapSerializer(BaseSerializerFactory.STRING_SERIALIZER, (Serializer)this.hashCodeSerializer);
        this.analysisSerializer = new ClassSetAnalysisData.Serializer();
    }

    public JarSnapshotData read(Decoder decoder) throws Exception {
        HashCode hash = this.hashCodeSerializer.read(decoder);
        Map hashes = this.mapSerializer.read(decoder);
        ClassSetAnalysisData data = (ClassSetAnalysisData)this.analysisSerializer.read(decoder);
        return new JarSnapshotData(hash, hashes, data);
    }

    public void write(Encoder encoder, JarSnapshotData value) throws Exception {
        this.hashCodeSerializer.write(encoder, value.hash);
        this.mapSerializer.write(encoder, value.hashes);
        this.analysisSerializer.write(encoder, (Object)value.data);
    }
}

