/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.gnu.trove.TObjectHashingStrategy;
import org.jetbrains.kotlin.gnu.trove.TObjectIntHashMap;
import org.jetbrains.kotlin.gnu.trove.TObjectIntIterator;

public class Enumerator<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.containers.Enumerator");
    private final TObjectIntHashMap<T> myNumbers;
    private int myNextNumber = 1;

    public Enumerator(int expectNumber, TObjectHashingStrategy<T> strategy) {
        this.myNumbers = new TObjectIntHashMap<T>(expectNumber, strategy);
    }

    public int[] enumerate(T[] objects, int startShift, int endCut) {
        int[] idx = ArrayUtil.newIntArray(objects.length - startShift - endCut);
        for (int i = startShift; i < objects.length - endCut; ++i) {
            int number;
            T object = objects[i];
            idx[i - startShift] = number = this.enumerate(object);
        }
        return idx;
    }

    public int enumerate(T object) {
        int res = this.enumerateImpl(object);
        return Math.max(res, -res);
    }

    public int enumerateImpl(T object) {
        if (object == null) {
            return 0;
        }
        int number = this.myNumbers.get(object);
        if (number == 0) {
            number = this.myNextNumber++;
            this.myNumbers.put(object, number);
            return -number;
        }
        return number;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        TObjectIntIterator<T> iter = this.myNumbers.iterator();
        while (iter.hasNext()) {
            iter.advance();
            buffer.append(Integer.toString(iter.value()) + ": " + iter.key().toString() + "\n");
        }
        return buffer.toString();
    }
}

