/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.base14.Symbol;
import org.apache.fop.fonts.base14.ZapfDingbats;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFXObject;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;

public class PDFResources
extends PDFDictionary {
    protected Map<String, PDFFont> fonts = new LinkedHashMap<String, PDFFont>();
    protected Set<PDFXObject> xObjects = new LinkedHashSet<PDFXObject>();
    protected Set<PDFPattern> patterns = new LinkedHashSet<PDFPattern>();
    protected Set<PDFShading> shadings = new LinkedHashSet<PDFShading>();
    protected Set<PDFGState> gstates = new LinkedHashSet<PDFGState>();
    protected Map<PDFName, PDFColorSpace> colorSpaces = new LinkedHashMap<PDFName, PDFColorSpace>();
    protected Map<String, PDFICCBasedColorSpace> iccColorSpaces = new LinkedHashMap<String, PDFICCBasedColorSpace>();

    public PDFResources(int objnum) {
        this.setObjectNumber(objnum);
    }

    public void addFont(PDFFont font) {
        this.fonts.put(font.getName(), font);
    }

    public void addFonts(PDFDocument doc, FontInfo fontInfo) {
        Map<String, Typeface> usedFonts = fontInfo.getUsedFonts();
        for (String f : usedFonts.keySet()) {
            Typeface font = usedFonts.get(f);
            if (!font.hadMappingOperations()) continue;
            FontDescriptor desc = null;
            if (font instanceof FontDescriptor) {
                desc = (FontDescriptor)((Object)font);
            }
            String encoding = font.getEncodingName();
            if (font instanceof Symbol || font instanceof ZapfDingbats) {
                encoding = null;
            }
            this.addFont(doc.getFactory().makeFont(f, font.getEmbedFontName(), encoding, font, desc));
        }
    }

    public void addGState(PDFGState gs) {
        this.gstates.add(gs);
    }

    public void addShading(PDFShading theShading) {
        this.shadings.add(theShading);
    }

    public void addPattern(PDFPattern thePattern) {
        this.patterns.add(thePattern);
    }

    public void addXObject(PDFXObject xObject) {
        this.xObjects.add(xObject);
    }

    public void addColorSpace(PDFColorSpace colorSpace) {
        this.colorSpaces.put(new PDFName(colorSpace.getName()), colorSpace);
        if (colorSpace instanceof PDFICCBasedColorSpace) {
            PDFICCBasedColorSpace icc = (PDFICCBasedColorSpace)colorSpace;
            String desc = ColorProfileUtil.getICCProfileDescription(icc.getICCStream().getICCProfile());
            this.iccColorSpaces.put(desc, icc);
        }
    }

    public PDFICCBasedColorSpace getICCColorSpaceByProfileName(String desc) {
        PDFICCBasedColorSpace cs = this.iccColorSpaces.get(desc);
        return cs;
    }

    public PDFColorSpace getColorSpace(PDFName name) {
        PDFColorSpace cs = this.colorSpaces.get(name);
        return cs;
    }

    public int output(OutputStream stream) throws IOException {
        this.populateDictionary();
        return super.output(stream);
    }

    private void populateDictionary() {
        PDFDictionary dict;
        PDFDictionary dict2;
        if (!this.fonts.isEmpty()) {
            PDFDictionary dict22 = new PDFDictionary(this);
            for (Map.Entry entry : this.fonts.entrySet()) {
                dict22.put((String)entry.getKey(), entry.getValue());
            }
            this.put("Font", dict22);
        }
        if (!this.shadings.isEmpty()) {
            dict2 = new PDFDictionary(this);
            for (PDFShading pDFShading : this.shadings) {
                dict2.put(pDFShading.getName(), pDFShading);
            }
            this.put("Shading", dict2);
        }
        if (!this.patterns.isEmpty()) {
            dict2 = new PDFDictionary(this);
            for (PDFPattern pDFPattern : this.patterns) {
                dict2.put(pDFPattern.getName(), pDFPattern);
            }
            this.put("Pattern", dict2);
        }
        PDFArray procset = new PDFArray(this);
        procset.add(new PDFName("PDF"));
        procset.add(new PDFName("ImageB"));
        procset.add(new PDFName("ImageC"));
        procset.add(new PDFName("Text"));
        this.put("ProcSet", procset);
        if (this.xObjects != null && !this.xObjects.isEmpty()) {
            dict = new PDFDictionary(this);
            for (PDFXObject xObject : this.xObjects) {
                dict.put(xObject.getName().toString(), xObject);
            }
            this.put("XObject", dict);
        }
        if (!this.gstates.isEmpty()) {
            dict = new PDFDictionary(this);
            for (PDFGState gstate : this.gstates) {
                dict.put(gstate.getName(), gstate);
            }
            this.put("ExtGState", dict);
        }
        if (!this.colorSpaces.isEmpty()) {
            dict = new PDFDictionary(this);
            for (PDFColorSpace colorSpace : this.colorSpaces.values()) {
                dict.put(colorSpace.getName(), colorSpace);
            }
            this.put("ColorSpace", dict);
        }
    }
}

