/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.layer.ImageProcessor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.layer.WMTSLayer;
import org.openstreetmap.josm.gui.layer.imagery.ImageryFilterSettings;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public abstract class ImageryLayer
extends Layer {
    public static final ColorProperty PROP_FADE_COLOR = new ColorProperty(I18n.marktr("Imagery fade"), Color.white);
    public static final IntegerProperty PROP_FADE_AMOUNT = new IntegerProperty("imagery.fade_amount", 0);
    public static final IntegerProperty PROP_SHARPEN_LEVEL = new IntegerProperty("imagery.sharpen_level", 0);
    private final List<ImageProcessor> imageProcessors = new ArrayList<ImageProcessor>();
    protected final ImageryInfo info;
    protected Icon icon;
    private final ImageryFilterSettings filterSettings = new ImageryFilterSettings();

    public static Color getFadeColor() {
        return PROP_FADE_COLOR.get();
    }

    public static Color getFadeColorWithAlpha() {
        Color color = PROP_FADE_COLOR.get();
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), PROP_FADE_AMOUNT.get() * 255 / 100);
    }

    public ImageryLayer(ImageryInfo imageryInfo) {
        super(imageryInfo.getName());
        this.info = imageryInfo;
        if (imageryInfo.getIcon() != null) {
            this.icon = new ImageProvider(imageryInfo.getIcon()).setOptional(true).setMaxSize(ImageProvider.ImageSizes.LAYER).get();
        }
        if (this.icon == null) {
            this.icon = ImageProvider.get("imagery_small");
        }
        for (ImageProcessor imageProcessor : this.filterSettings.getProcessors()) {
            this.addImageProcessor(imageProcessor);
        }
        this.filterSettings.setSharpenLevel(1.0f + (float)PROP_SHARPEN_LEVEL.get().intValue() / 2.0f);
    }

    public double getPPD() {
        if (!Main.isDisplayingMapView()) {
            return Main.getProjection().getDefaultZoomInPPD();
        }
        ProjectionBounds projectionBounds = Main.map.mapView.getProjectionBounds();
        return (double)Main.map.mapView.getWidth() / (projectionBounds.maxEast - projectionBounds.minEast);
    }

    @Deprecated
    public double getDx() {
        return 0.0;
    }

    @Deprecated
    public double getDy() {
        return 0.0;
    }

    @Deprecated
    public void setOffset(double d, double d2) {
    }

    @Deprecated
    public void displace(double d, double d2) {
    }

    public ImageryInfo getInfo() {
        return this.info;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public boolean isMergable(Layer layer) {
        return false;
    }

    @Override
    public void mergeFrom(Layer layer) {
    }

    @Override
    public Object getInfoComponent() {
        String string;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(this.getToolTipText()), GBC.eol());
        if (this.info != null && (string = this.info.getUrl()) != null) {
            jPanel.add((Component)new JLabel(I18n.tr("URL: ", new Object[0])), GBC.std().insets(0, 5, 2, 0));
            jPanel.add((Component)new UrlLabel(string), GBC.eol().insets(2, 5, 10, 0));
        }
        return jPanel;
    }

    public static ImageryLayer create(ImageryInfo imageryInfo) {
        switch (imageryInfo.getImageryType()) {
            case WMS: 
            case HTML: {
                return new WMSLayer(imageryInfo);
            }
            case WMTS: {
                return new WMTSLayer(imageryInfo);
            }
            case TMS: 
            case BING: 
            case SCANEX: {
                return new TMSLayer(imageryInfo);
            }
        }
        throw new AssertionError((Object)I18n.tr("Unsupported imagery type: {0}", new Object[]{imageryInfo.getImageryType()}));
    }

    public JMenuItem getOffsetMenuItem() {
        JMenu jMenu = new JMenu(I18n.trc("layer", "Offset"));
        jMenu.setIcon(ImageProvider.get("mapmode", "adjustimg"));
        return (JMenuItem)this.getOffsetMenuItem(jMenu);
    }

    public JComponent getOffsetMenuItem(JComponent jComponent) {
        JMenuItem jMenuItem = new JMenuItem(this.getAdjustAction());
        if (OffsetBookmark.allBookmarks.isEmpty()) {
            return jMenuItem;
        }
        jComponent.add(jMenuItem);
        jComponent.add(new JSeparator());
        boolean bl = false;
        int n = 0;
        for (OffsetBookmark offsetBookmark : OffsetBookmark.allBookmarks) {
            if (!offsetBookmark.isUsable(this)) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new ApplyOffsetAction(offsetBookmark));
            if (Utils.equalsEpsilon(offsetBookmark.dx, this.getDx()) && Utils.equalsEpsilon(offsetBookmark.dy, this.getDy())) {
                jCheckBoxMenuItem.setSelected(true);
            }
            jComponent.add(jCheckBoxMenuItem);
            n = jCheckBoxMenuItem.getPreferredSize().height;
            bl = true;
        }
        if (n > 0) {
            if (jComponent instanceof JMenu) {
                MenuScroller.setScrollerFor((JMenu)jComponent);
            } else if (jComponent instanceof JPopupMenu) {
                MenuScroller.setScrollerFor((JPopupMenu)jComponent);
            }
        }
        return bl ? jComponent : jMenuItem;
    }

    protected abstract Action getAdjustAction();

    public ImageryFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public boolean addImageProcessor(ImageProcessor imageProcessor) {
        return imageProcessor != null && this.imageProcessors.add(imageProcessor);
    }

    public boolean removeImageProcessor(ImageProcessor imageProcessor) {
        return this.imageProcessors.remove(imageProcessor);
    }

    public static ImageProcessor createImageProcessor(BufferedImageOp bufferedImageOp, boolean bl) {
        return bufferedImage -> bufferedImageOp.filter(bufferedImage, bl ? bufferedImage : null);
    }

    public List<ImageProcessor> getImageProcessors() {
        return this.imageProcessors;
    }

    public BufferedImage applyImageProcessors(BufferedImage bufferedImage) {
        for (ImageProcessor imageProcessor : this.imageProcessors) {
            bufferedImage = imageProcessor.process(bufferedImage);
        }
        return bufferedImage;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [info=" + this.info + ']';
    }

    public class OffsetAction
    extends AbstractAction
    implements Layer.LayerAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        @Override
        public Component createMenuComponent() {
            return ImageryLayer.this.getOffsetMenuItem();
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return false;
        }
    }

    class ApplyOffsetAction
    extends AbstractAction {
        private final transient OffsetBookmark b;

        ApplyOffsetAction(OffsetBookmark offsetBookmark) {
            super(offsetBookmark.name);
            this.b = offsetBookmark;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImageryLayer.this.setOffset(this.b.dx, this.b.dy);
            Main.main.menu.imageryMenu.refreshOffsetMenu();
            Main.map.repaint();
        }
    }
}

